/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.externalSystem.autoimport.AutoImportProjectTracker;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTracker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Function;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.buildtool.MavenImportSpec;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomExclusion;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenGeneralSettingsWatcher;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsAware;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.importing.MavenImportingManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

public final class MavenProjectsManagerWatcher {
    private static final Logger LOG = Logger.getInstance(MavenProjectsManagerWatcher.class);
    private final Project myProject;
    private MavenProjectsTree myProjectsTree;
    private final MavenGeneralSettings myGeneralSettings;
    private final MavenProjectsAware myProjectsAware;
    private final ExecutorService myBackgroundExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"MavenProjectsManagerWatcher.backgroundExecutor", (int)1);
    private final Disposable myDisposable;

    public MavenProjectsManagerWatcher(Project project2, MavenProjectsTree projectsTree, MavenGeneralSettings generalSettings) {
        this.myProject = project2;
        this.myProjectsTree = projectsTree;
        this.myGeneralSettings = generalSettings;
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.myProject);
        this.myProjectsAware = new MavenProjectsAware(project2, projectsManager, this, this.myBackgroundExecutor);
        this.myDisposable = Disposer.newDisposable((Disposable)projectsManager, (String)MavenProjectsManagerWatcher.class.toString());
    }

    public synchronized void start() {
        MessageBusConnection busConnection = this.myProject.getMessageBus().connect(this.myDisposable);
        busConnection.subscribe(ProjectTopics.MODULES, (Object)new MavenRenameModulesWatcher());
        busConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new MyRootChangesListener());
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.myProject);
        MavenGeneralSettingsWatcher.registerGeneralSettingsWatcher(projectsManager, this, this.myBackgroundExecutor, this.myDisposable);
        ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.getInstance((Project)this.myProject);
        projectTracker.register((ExternalSystemProjectAware)this.myProjectsAware, (Disposable)projectsManager);
        projectTracker.activate(this.myProjectsAware.getProjectId());
    }

    @TestOnly
    public synchronized void enableAutoImportInTests() {
        AutoImportProjectTracker.enableAutoReloadInTests((Disposable)this.myDisposable);
    }

    public synchronized void stop() {
        Disposer.dispose((Disposable)this.myDisposable);
    }

    public void setProjectsTree(MavenProjectsTree tree) {
        this.myProjectsTree = tree;
    }

    @TestOnly
    public synchronized void resetManagedFilesAndProfilesInTests(List<VirtualFile> files2, MavenExplicitProfiles explicitProfiles) {
        this.myProjectsTree.resetManagedFilesAndProfiles(files2, explicitProfiles);
        this.scheduleUpdateAll(new MavenImportSpec(true, true, true));
    }

    public synchronized void removeManagedFiles(List<VirtualFile> files2) {
        this.myProjectsTree.removeManagedFiles(files2);
        this.scheduleUpdateAll(new MavenImportSpec(false, true, true));
    }

    public synchronized void setExplicitProfiles(MavenExplicitProfiles profiles2) {
        this.myProjectsTree.setExplicitProfiles(profiles2);
        this.scheduleUpdateAll(new MavenImportSpec(false, false, false));
    }

    public Promise<Void> scheduleUpdateAll(MavenImportSpec spec) {
        if (MavenUtil.isLinearImportEnabled()) {
            return MavenImportingManager.getInstance(this.myProject).scheduleImportAll(spec).getFinishPromise().then(it -> null);
        }
        return this.scheduleUpdateAllSuspendable(spec);
    }

    private Promise<Void> scheduleUpdateAllSuspendable(MavenImportSpec spec) {
        AsyncPromise promise2 = new AsyncPromise();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.updateAllMavenProjectsSync(spec, (AsyncPromise<Void>)promise2);
        } else {
            AppExecutorUtil.getAppExecutorService().execute(() -> this.updateAllMavenProjectsSync(spec, (AsyncPromise<Void>)promise2));
        }
        return promise2;
    }

    private void updateAllMavenProjectsSync(MavenImportSpec spec, AsyncPromise<Void> promise2) {
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.myProject);
        try {
            projectsManager.updateAllMavenProjectsSync(spec);
            promise2.setResult(null);
        }
        catch (Exception e) {
            promise2.setError((Throwable)e);
        }
    }

    private Promise<Void> scheduleUpdateSuspendable(MavenImportSpec spec, List<VirtualFile> filesToUpdate, List<VirtualFile> filesToDelete) {
        AsyncPromise promise2 = new AsyncPromise();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (!ApplicationManager.getApplication().isWriteAccessAllowed()) {
                this.updateMavenProjectsSync(spec, filesToUpdate, filesToDelete, (AsyncPromise<Void>)promise2);
            } else {
                MavenLog.LOG.warn("updateAllMavenProjectsSync skipped in write action");
            }
        } else {
            AppExecutorUtil.getAppExecutorService().execute(() -> this.updateMavenProjectsSync(spec, filesToUpdate, filesToDelete, (AsyncPromise<Void>)promise2));
        }
        return promise2;
    }

    private void updateMavenProjectsSync(MavenImportSpec spec, List<VirtualFile> filesToUpdate, List<VirtualFile> filesToDelete, AsyncPromise<Void> promise2) {
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(this.myProject);
        try {
            projectsManager.updateMavenProjectsSync(spec, filesToUpdate, filesToDelete);
            promise2.setResult(null);
        }
        catch (Exception e) {
            promise2.setError((Throwable)e);
        }
    }

    public Promise<Void> scheduleUpdate(@NotNull List<VirtualFile> filesToUpdate, @NotNull List<VirtualFile> filesToDelete, MavenImportSpec spec) {
        if (filesToUpdate == null) {
            MavenProjectsManagerWatcher.$$$reportNull$$$0(0);
        }
        if (filesToDelete == null) {
            MavenProjectsManagerWatcher.$$$reportNull$$$0(1);
        }
        if (MavenUtil.isLinearImportEnabled()) {
            return MavenImportingManager.getInstance(this.myProject).scheduleUpdate(filesToUpdate, filesToDelete, spec).getFinishPromise().then(it -> null);
        }
        return this.scheduleUpdateSuspendable(spec, filesToUpdate, filesToDelete);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "filesToUpdate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "filesToDelete";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/maven/project/MavenProjectsManagerWatcher";
        objectArray[2] = "scheduleUpdate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MavenRenameModulesWatcher
    implements ModuleListener {
        private MavenRenameModulesWatcher() {
        }

        public void modulesRenamed(@NotNull Project project2, @NotNull List<? extends Module> modules, @NotNull Function<? super Module, String> oldNameProvider) {
            if (project2 == null) {
                MavenRenameModulesWatcher.$$$reportNull$$$0(0);
            }
            if (modules == null) {
                MavenRenameModulesWatcher.$$$reportNull$$$0(1);
            }
            if (oldNameProvider == null) {
                MavenRenameModulesWatcher.$$$reportNull$$$0(2);
            }
            for (Module module2 : modules) {
                new MavenRenameModuleHandler(project2, module2, (String)oldNameProvider.fun((Object)module2)).handleModuleRename();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "modules";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "oldNameProvider";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/project/MavenProjectsManagerWatcher$MavenRenameModulesWatcher";
            objectArray[2] = "modulesRenamed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class MavenRenameModuleHandler {
            private final Project myProject;
            private final Module myModule;
            private final String myOldName;
            private final String myNewName;
            private String myGroupId;
            private final MavenProjectsManager myProjectsManager;
            private final List<MavenProject> myUpdatedMavenProjects;

            private MavenRenameModuleHandler(@NotNull Project project2, @NotNull Module module2, @NotNull String oldName) {
                if (project2 == null) {
                    MavenRenameModuleHandler.$$$reportNull$$$0(0);
                }
                if (module2 == null) {
                    MavenRenameModuleHandler.$$$reportNull$$$0(1);
                }
                if (oldName == null) {
                    MavenRenameModuleHandler.$$$reportNull$$$0(2);
                }
                this.myUpdatedMavenProjects = new ArrayList<MavenProject>();
                this.myProject = project2;
                this.myModule = module2;
                this.myOldName = oldName;
                String[] myNewNameHierarchy = module2.getName().split("\\.");
                this.myNewName = myNewNameHierarchy[myNewNameHierarchy.length - 1];
                this.myProjectsManager = MavenProjectsManager.getInstance(project2);
            }

            private boolean replaceArtifactId(@Nullable XmlTag parentTag) {
                if (null == parentTag) {
                    return false;
                }
                XmlTag artifactIdTag = parentTag.findFirstSubTag("artifactId");
                if (null == artifactIdTag) {
                    return false;
                }
                XmlTag groupIdTag = parentTag.findFirstSubTag("groupId");
                if (null == groupIdTag) {
                    return false;
                }
                if (this.myGroupId.equals(groupIdTag.getValue().getText()) && this.myOldName.equals(artifactIdTag.getValue().getText())) {
                    artifactIdTag.getValue().setText(this.myNewName);
                    return true;
                }
                return false;
            }

            private boolean replaceModuleArtifactId(MavenDomProjectModel mavenModel) {
                XmlTag artifactIdTag = mavenModel.getArtifactId().getXmlTag();
                if (null != artifactIdTag && this.myOldName.equals(artifactIdTag.getValue().getText())) {
                    artifactIdTag.getValue().setText(this.myNewName);
                    return true;
                }
                return false;
            }

            private boolean replaceArtifactIdReferences(MavenDomProjectModel mavenModel) {
                boolean replaced = false;
                if (null != mavenModel.getXmlTag()) {
                    replaced = this.replaceArtifactId(mavenModel.getXmlTag().findFirstSubTag("parent"));
                }
                MavenDomDependencies dependencies = mavenModel.getDependencies();
                for (MavenDomDependency dependency : dependencies.getDependencies()) {
                    replaced |= this.replaceArtifactId(dependency.getXmlTag());
                    for (MavenDomExclusion exclusion : dependency.getExclusions().getExclusions()) {
                        replaced |= this.replaceArtifactId(exclusion.getXmlTag());
                    }
                }
                return replaced;
            }

            private void processModule(Module module2, Predicate<MavenDomProjectModel> artifactIdReplacer) {
                if (!this.myProjectsManager.isMavenizedModule(module2)) {
                    return;
                }
                MavenProject mavenProject2 = this.myProjectsManager.findProject(module2);
                if (null == mavenProject2) {
                    return;
                }
                MavenDomProjectModel mavenModel = MavenDomUtil.getMavenDomProjectModel(this.myProject, mavenProject2.getFile());
                if (null == mavenModel) {
                    return;
                }
                XmlFile psiFile = DomUtil.getFile((DomElement)mavenModel);
                AtomicBoolean mavenProjectUpdated = new AtomicBoolean(false);
                WriteCommandAction.writeCommandAction((Project)this.myProject, (PsiFile[])new PsiFile[]{psiFile}).run(() -> {
                    PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
                    Document document = documentManager.getDocument((PsiFile)psiFile);
                    if (document != null) {
                        documentManager.commitDocument(document);
                    }
                    mavenProjectUpdated.set(artifactIdReplacer.test(mavenModel));
                    if (document != null) {
                        FileDocumentManager.getInstance().saveDocument(document);
                    }
                });
                if (mavenProjectUpdated.get()) {
                    this.myUpdatedMavenProjects.add(mavenProject2);
                }
            }

            public void handleModuleRename() {
                Module[] modules;
                if (!this.myProjectsManager.isMavenizedModule(this.myModule)) {
                    return;
                }
                MavenProject mavenProject2 = this.myProjectsManager.findProject(this.myModule);
                if (null == mavenProject2) {
                    return;
                }
                this.myGroupId = mavenProject2.getMavenId().getGroupId();
                for (Module module2 : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
                    if (module2 == this.myModule) {
                        this.processModule(module2, this::replaceModuleArtifactId);
                        continue;
                    }
                    this.processModule(module2, this::replaceArtifactIdReferences);
                }
                this.myProjectsManager.forceUpdateProjects(this.myUpdatedMavenProjects);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "module";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "oldName";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/idea/maven/project/MavenProjectsManagerWatcher$MavenRenameModulesWatcher$MavenRenameModuleHandler";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private class MyRootChangesListener
    implements ModuleRootListener {
        private MyRootChangesListener() {
        }

        public void rootsChanged(@NotNull ModuleRootEvent event) {
            if (event == null) {
                MyRootChangesListener.$$$reportNull$$$0(0);
            }
            List<VirtualFile> existingFiles = MavenProjectsManagerWatcher.this.myProjectsTree.getProjectsFiles();
            ArrayList<VirtualFile> newFiles = new ArrayList<VirtualFile>();
            ArrayList<VirtualFile> deletedFiles = new ArrayList<VirtualFile>();
            for (VirtualFile f : MavenProjectsManagerWatcher.this.myProjectsTree.getExistingManagedFiles()) {
                if (existingFiles.contains(f)) continue;
                newFiles.add(f);
            }
            for (VirtualFile f : existingFiles) {
                if (f.isValid()) continue;
                deletedFiles.add(f);
            }
            if (!deletedFiles.isEmpty() || !newFiles.isEmpty()) {
                MavenProjectsManagerWatcher.this.scheduleUpdate(newFiles, deletedFiles, new MavenImportSpec(false, false, true));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/maven/project/MavenProjectsManagerWatcher$MyRootChangesListener", "rootsChanged"));
        }
    }
}

