/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.build.BuildProgressListener;
import com.intellij.build.SyncViewManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.idea.maven.buildtool.MavenDownloadConsole;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenArtifactDownloader;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

public final class MavenProjectsProcessorArtifactsDownloadingTask
implements MavenProjectsProcessorTask {
    @NotNull
    private final Collection<MavenProject> myProjects;
    @Nullable
    private final Collection<MavenArtifact> myArtifacts;
    private final boolean myDownloadSources;
    private final boolean myDownloadDocs;
    @Nullable
    private final AsyncPromise<? super MavenArtifactDownloader.DownloadResult> myCallbackResult;
    @NotNull
    private final MavenProjectsTree myTree;

    public MavenProjectsProcessorArtifactsDownloadingTask(@NotNull Collection<MavenProject> projects, @NotNull MavenProjectsTree tree, @Nullable Collection<MavenArtifact> artifacts, boolean downloadSources, boolean downloadDocs, @Nullable AsyncPromise<? super MavenArtifactDownloader.DownloadResult> callbackResult) {
        if (projects == null) {
            MavenProjectsProcessorArtifactsDownloadingTask.$$$reportNull$$$0(0);
        }
        if (tree == null) {
            MavenProjectsProcessorArtifactsDownloadingTask.$$$reportNull$$$0(1);
        }
        this.myProjects = projects;
        this.myTree = tree;
        this.myArtifacts = artifacts;
        this.myDownloadSources = downloadSources;
        this.myDownloadDocs = downloadDocs;
        this.myCallbackResult = callbackResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(@NotNull Project project2, @NotNull MavenEmbeddersManager embeddersManager, @NotNull MavenConsole console2, @NotNull MavenProgressIndicator indicator) throws MavenProcessCanceledException {
        if (project2 == null) {
            MavenProjectsProcessorArtifactsDownloadingTask.$$$reportNull$$$0(2);
        }
        if (embeddersManager == null) {
            MavenProjectsProcessorArtifactsDownloadingTask.$$$reportNull$$$0(3);
        }
        if (console2 == null) {
            MavenProjectsProcessorArtifactsDownloadingTask.$$$reportNull$$$0(4);
        }
        if (indicator == null) {
            MavenProjectsProcessorArtifactsDownloadingTask.$$$reportNull$$$0(5);
        }
        SyncViewManager progressListener = (SyncViewManager)project2.getService(SyncViewManager.class);
        MavenDownloadConsole downloadConsole = new MavenDownloadConsole(project2);
        MavenArtifactDownloader.DownloadResult result2 = null;
        try {
            downloadConsole.startDownload((BuildProgressListener)progressListener, this.myDownloadSources, this.myDownloadDocs);
            downloadConsole.startDownloadTask();
            MavenArtifactDownloader downloader = new MavenArtifactDownloader(project2, this.myTree, this.myArtifacts, indicator.getIndicator(), indicator.getSyncConsole());
            result2 = downloader.downloadSourcesAndJavadocs(this.myProjects, this.myDownloadSources, this.myDownloadDocs, embeddersManager, console2);
            downloadConsole.finishDownloadTask();
        }
        catch (Exception e) {
            downloadConsole.addException(e);
        }
        finally {
            downloadConsole.finishDownload();
        }
        if (this.myCallbackResult != null) {
            this.myCallbackResult.setResult(result2);
        }
        ApplicationManager.getApplication().invokeLater(() -> VirtualFileManager.getInstance().asyncRefresh(), project2.getDisposed());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projects";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embeddersManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/project/MavenProjectsProcessorArtifactsDownloadingTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

