/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.statistics.MavenPluginCollector;
import org.jetbrains.idea.maven.statistics.MavenPluginCoordinatesWhitelistValidationRule;
import org.jetbrains.idea.maven.statistics.MavenPluginVersionValidationRule;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/idea/maven/statistics/MavenPluginCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "mavenPluginId", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenPluginCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenPluginCollector.kt\norg/jetbrains/idea/maven/statistics/MavenPluginCollector\n+ 2 EventFields.kt\ncom/intellij/internal/statistic/eventLog/events/EventFields\n*L\n1#1,90:1\n82#2:91\n82#2:92\n*S KotlinDebug\n*F\n+ 1 MavenPluginCollector.kt\norg/jetbrains/idea/maven/statistics/MavenPluginCollector\n*L\n42#1:91\n43#1:92\n*E\n"})
public final class MavenPluginCollector
extends ProjectUsagesCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VarargEventId mavenPluginId;
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("maven.plugins", 4, null, 4, null);
    @NotNull
    private static final StringEventField groupArtifactId;
    @NotNull
    private static final StringEventField version;
    @NotNull
    private static final BooleanEventField isExtension;
    @NotNull
    private static final BooleanEventField hasConfiguration;

    public MavenPluginCollector() {
        EventField[] eventFieldArray = new EventField[]{groupArtifactId, version, isExtension, hasConfiguration};
        this.mavenPluginId = this.getGroup().registerVarargEvent("maven.plugins.used", eventFieldArray);
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        MavenProjectsManager manager = MavenProjectsManager.getInstance(project2);
        if (!manager.isMavenizedProject()) {
            return SetsKt.emptySet();
        }
        List<MavenProject> list = manager.getProjects();
        Intrinsics.checkNotNullExpressionValue(list, (String)"manager.projects");
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)getMetrics.1.INSTANCE), (Function1)((Function1)new Function1<MavenPlugin, MetricEvent>(this){
            final /* synthetic */ MavenPluginCollector this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final MetricEvent invoke(MavenPlugin it) {
                EventPair[] eventPairArray = new EventPair[]{MavenPluginCollector.Companion.getGroupArtifactId().with((Object)(it.getGroupId() + ":" + it.getArtifactId())), MavenPluginCollector.Companion.getVersion().with((Object)it.getVersion()), MavenPluginCollector.Companion.isExtension().with((Object)it.isExtensions()), MavenPluginCollector.Companion.getHasConfiguration().with((Object)(it.getConfigurationElement() != null ? 1 : 0))};
                return MavenPluginCollector.access$getMavenPluginId$p(this.this$0).metric(eventPairArray);
            }
        })));
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    public static final /* synthetic */ VarargEventId access$getMavenPluginId$p(MavenPluginCollector $this) {
        return $this.mavenPluginId;
    }

    static {
        EventFields eventFields = EventFields.INSTANCE;
        String name$iv = "group_artifact_id";
        boolean $i$f$StringValidatedByCustomRule = false;
        groupArtifactId = EventFields.StringValidatedByCustomRule((String)name$iv, MavenPluginCoordinatesWhitelistValidationRule.class);
        EventFields this_$iv = EventFields.INSTANCE;
        name$iv = "version";
        $i$f$StringValidatedByCustomRule = false;
        version = EventFields.StringValidatedByCustomRule((String)name$iv, MavenPluginVersionValidationRule.class);
        isExtension = EventFields.Boolean((String)"extension");
        hasConfiguration = EventFields.Boolean((String)"has_configuration");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/idea/maven/statistics/MavenPluginCollector$Companion;", "", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "groupArtifactId", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "getGroupArtifactId", "()Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "hasConfiguration", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "getHasConfiguration", "()Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "isExtension", "version", "getVersion", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StringEventField getGroupArtifactId() {
            return groupArtifactId;
        }

        @NotNull
        public final StringEventField getVersion() {
            return version;
        }

        @NotNull
        public final BooleanEventField isExtension() {
            return isExtension;
        }

        @NotNull
        public final BooleanEventField getHasConfiguration() {
            return hasConfiguration;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

