/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenExtraArtifactType;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenArtifactDownloader;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

final class MavenAttachSourcesProvider
implements AttachSourcesProvider {
    MavenAttachSourcesProvider() {
    }

    @NotNull
    public Collection<? extends AttachSourcesProvider.AttachSourcesAction> getActions(final @NotNull List<? extends LibraryOrderEntry> orderEntries, final @NotNull PsiFile psiFile) {
        Collection<MavenProject> projects;
        if (orderEntries == null) {
            MavenAttachSourcesProvider.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            MavenAttachSourcesProvider.$$$reportNull$$$0(1);
        }
        if ((projects = MavenAttachSourcesProvider.getMavenProjects(psiFile)).isEmpty()) {
            List list = List.of();
            if (list == null) {
                MavenAttachSourcesProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (MavenAttachSourcesProvider.findArtifacts(projects, orderEntries).isEmpty()) {
            List list = List.of();
            if (list == null) {
                MavenAttachSourcesProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<1> list = List.of(new AttachSourcesProvider.AttachSourcesAction(){

            public String getName() {
                return MavenProjectBundle.message("maven.action.download.sources", new Object[0]);
            }

            public String getBusyText() {
                return MavenProjectBundle.message("maven.action.download.sources.busy.text", new Object[0]);
            }

            @NotNull
            public ActionCallback perform(@NotNull List<? extends LibraryOrderEntry> orderEntriesContainingFile) {
                Collection<MavenProject> mavenProjects2;
                if (orderEntriesContainingFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((mavenProjects2 = MavenAttachSourcesProvider.getMavenProjects(psiFile)).isEmpty()) {
                    ActionCallback actionCallback = ActionCallback.REJECTED;
                    if (actionCallback == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return actionCallback;
                }
                MavenProjectsManager manager = MavenProjectsManager.getInstance(psiFile.getProject());
                Collection<MavenArtifact> artifacts = MavenAttachSourcesProvider.findArtifacts(mavenProjects2, orderEntries);
                if (artifacts.isEmpty()) {
                    ActionCallback actionCallback = ActionCallback.REJECTED;
                    if (actionCallback == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return actionCallback;
                }
                MavenArtifactDownloader.DownloadResult downloadResult = manager.downloadArtifactsSync(mavenProjects2, artifacts, true, false);
                ActionCallback resultWrapper = new ActionCallback();
                HtmlBuilder builder = null;
                if (!downloadResult.unresolvedSources.isEmpty()) {
                    builder = new HtmlBuilder();
                    builder.append(MavenProjectBundle.message("sources.not.found.for", new Object[0]));
                    int count = 0;
                    for (MavenId each : downloadResult.unresolvedSources) {
                        if (count++ > 5) {
                            builder.append((HtmlChunk)HtmlChunk.br()).append(MavenProjectBundle.message("and.more", new Object[0]));
                            break;
                        }
                        builder.append((HtmlChunk)HtmlChunk.br()).append(each.getDisplayString());
                    }
                }
                if (builder != null) {
                    MavenAttachSourcesProvider.cleanUpUnresolvedSourceFiles(psiFile.getProject(), downloadResult.unresolvedSources);
                    Notifications.Bus.notify((Notification)new Notification("Maven", MavenProjectBundle.message("maven.sources.cannot.download", new Object[0]), builder.wrapWithHtmlBody().toString(), NotificationType.WARNING), (Project)psiFile.getProject());
                }
                if (downloadResult.resolvedSources.isEmpty()) {
                    resultWrapper.setRejected();
                } else {
                    resultWrapper.setDone();
                }
                ActionCallback actionCallback = resultWrapper;
                if (actionCallback == null) {
                    1.$$$reportNull$$$0(3);
                }
                return actionCallback;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "orderEntriesContainingFile";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/idea/maven/utils/MavenAttachSourcesProvider$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/idea/maven/utils/MavenAttachSourcesProvider$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "perform";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "perform";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2, 3 -> new IllegalStateException(string);
                };
            }
        });
        if (list == null) {
            MavenAttachSourcesProvider.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static void cleanUpUnresolvedSourceFiles(Project project2, Collection<MavenId> mavenIds) {
        for (MavenId mavenId : mavenIds) {
            Path parentFile = MavenUtil.getRepositoryParentFile(project2, mavenId);
            if (parentFile == null) continue;
            try {
                Stream<Path> paths = Files.list(parentFile);
                try {
                    paths.filter(path -> MavenAttachSourcesProvider.isTargetFile(path.getFileName().toString(), MavenExtraArtifactType.SOURCES)).forEach(path -> {
                        try {
                            FileUtil.delete((Path)path);
                        }
                        catch (IOException e) {
                            MavenLog.LOG.warn(path + " not deleted", (Throwable)e);
                        }
                    });
                }
                finally {
                    if (paths == null) continue;
                    paths.close();
                }
            }
            catch (IOException e) {
                MavenLog.LOG.warn(parentFile + " cannot be listed", (Throwable)e);
            }
        }
    }

    private static boolean isTargetFile(String name, MavenExtraArtifactType type2) {
        return name.contains("-" + type2.getDefaultClassifier()) && name.contains("." + type2.getDefaultExtension());
    }

    @NotNull
    private static Collection<MavenArtifact> findArtifacts(@NotNull Collection<? extends MavenProject> mavenProjects2, @NotNull List<? extends LibraryOrderEntry> orderEntries) {
        if (mavenProjects2 == null) {
            MavenAttachSourcesProvider.$$$reportNull$$$0(5);
        }
        if (orderEntries == null) {
            MavenAttachSourcesProvider.$$$reportNull$$$0(6);
        }
        HashSet<MavenArtifact> artifacts = new HashSet<MavenArtifact>();
        for (MavenProject mavenProject2 : mavenProjects2) {
            for (LibraryOrderEntry libraryOrderEntry : orderEntries) {
                MavenArtifact artifact = MavenRootModelAdapter.findArtifact(mavenProject2, libraryOrderEntry.getLibrary());
                if (artifact == null || "system".equals(artifact.getScope())) continue;
                artifacts.add(artifact);
            }
        }
        HashSet<MavenArtifact> hashSet = artifacts;
        if (hashSet == null) {
            MavenAttachSourcesProvider.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    @NotNull
    private static Collection<MavenProject> getMavenProjects(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            MavenAttachSourcesProvider.$$$reportNull$$$0(8);
        }
        Project project2 = psiFile.getProject();
        ArrayList<MavenProject> result2 = new ArrayList<MavenProject>();
        for (OrderEntry each : ProjectRootManager.getInstance((Project)project2).getFileIndex().getOrderEntriesForFile(psiFile.getVirtualFile())) {
            MavenProject mavenProject2 = MavenProjectsManager.getInstance(project2).findProject(each.getOwnerModule());
            if (mavenProject2 == null) continue;
            result2.add(mavenProject2);
        }
        ArrayList<MavenProject> arrayList = result2;
        if (arrayList == null) {
            MavenAttachSourcesProvider.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntries";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/utils/MavenAttachSourcesProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/utils/MavenAttachSourcesProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findArtifacts";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMavenProjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findArtifacts";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMavenProjects";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 7, 9 -> new IllegalStateException(string);
        };
    }
}

