/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.GitSilentFileAdder;
import com.intellij.openapi.GitSilentFileAdderProvider;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlElement;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomModule;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.statistics.MavenActionsUsagesCollector;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenModuleBuilderHelper {
    private final MavenId myProjectId;
    private final MavenProject myAggregatorProject;
    private final MavenProject myParentProject;
    private final boolean myInheritGroupId;
    private final boolean myInheritVersion;
    private final MavenArchetype myArchetype;
    private final Map<String, String> myPropertiesToCreateByArtifact;
    private final @NlsContexts.Command String myCommandName;

    public MavenModuleBuilderHelper(@NotNull MavenId projectId, MavenProject aggregatorProject, MavenProject parentProject, boolean inheritGroupId, boolean inheritVersion, MavenArchetype archetype, Map<String, String> propertiesToCreateByArtifact, @NlsContexts.Command String commandName) {
        if (projectId == null) {
            MavenModuleBuilderHelper.$$$reportNull$$$0(0);
        }
        this.myProjectId = projectId;
        this.myAggregatorProject = aggregatorProject;
        this.myParentProject = parentProject;
        this.myInheritGroupId = inheritGroupId;
        this.myInheritVersion = inheritVersion;
        this.myArchetype = archetype;
        this.myPropertiesToCreateByArtifact = propertiesToCreateByArtifact;
        this.myCommandName = commandName;
    }

    public void configure(Project project2, VirtualFile root, boolean isInteractive) {
        PsiFile[] psiFileArray;
        MavenActionsUsagesCollector.trigger(project2, MavenActionsUsagesCollector.CREATE_MAVEN_PROJECT);
        if (this.myAggregatorProject != null) {
            PsiFile[] psiFileArray2 = new PsiFile[1];
            psiFileArray = psiFileArray2;
            psiFileArray2[0] = MavenModuleBuilderHelper.getPsiFile(project2, this.myAggregatorProject.getFile());
        } else {
            psiFileArray = PsiFile.EMPTY_ARRAY;
        }
        PsiFile[] psiFiles = psiFileArray;
        VirtualFile pom = (VirtualFile)WriteCommandAction.writeCommandAction((Project)project2, (PsiFile[])psiFiles).withName(this.myCommandName).compute(() -> {
            VirtualFile aggregatorProjectFile;
            MavenDomProjectModel model;
            GitSilentFileAdder vcsFileAdder = GitSilentFileAdderProvider.create((Project)project2);
            VirtualFile file = null;
            try {
                try {
                    file = root.findChild("pom.xml");
                    if (file != null) {
                        file.delete((Object)this);
                    }
                    file = root.createChildData((Object)this, "pom.xml");
                    vcsFileAdder.markFileForAdding(file);
                    MavenUtil.runOrApplyMavenProjectFileTemplate(project2, file, this.myProjectId, isInteractive);
                }
                catch (IOException e) {
                    MavenModuleBuilderHelper.showError(project2, e);
                    VirtualFile virtualFile = file;
                    vcsFileAdder.finish();
                    return virtualFile;
                }
                this.updateProjectPom(project2, file);
            }
            finally {
                vcsFileAdder.finish();
            }
            if (this.myAggregatorProject != null && (model = MavenDomUtil.getMavenDomProjectModel(project2, aggregatorProjectFile = this.myAggregatorProject.getFile())) != null) {
                model.getPackaging().setStringValue("pom");
                MavenDomModule module2 = model.getModules().addModule();
                module2.setValue(MavenModuleBuilderHelper.getPsiFile(project2, file));
                MavenModuleBuilderHelper.unblockAndSaveDocuments(project2, aggregatorProjectFile);
            }
            return file;
        });
        if (pom == null) {
            return;
        }
        if (this.myAggregatorProject == null) {
            MavenProjectsManager manager = MavenProjectsManager.getInstance(project2);
            manager.addManagedFilesOrUnignore(Collections.singletonList(pom));
        }
        if (this.myArchetype == null) {
            try {
                VfsUtil.createDirectories((String)(root.getPath() + "/src/main/java"));
                VfsUtil.createDirectories((String)(root.getPath() + "/src/main/resources"));
                VfsUtil.createDirectories((String)(root.getPath() + "/src/test/java"));
            }
            catch (IOException e) {
                MavenLog.LOG.info((Throwable)e);
            }
        }
        MavenProjectsManager.getInstance(project2).forceUpdateAllProjectsOrFindAllAvailablePomFiles();
        MavenUtil.invokeLater(project2, ModalityState.nonModal(), () -> {
            if (!pom.isValid()) {
                MavenModuleBuilderHelper.showError(project2, new RuntimeException("Project is not valid"));
                return;
            }
            EditorHelper.openInEditor((PsiElement)MavenModuleBuilderHelper.getPsiFile(project2, pom));
            if (this.myArchetype != null) {
                this.generateFromArchetype(project2, pom);
            }
        });
    }

    private void updateProjectPom(Project project2, VirtualFile pom) {
        if (this.myParentProject == null) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)project2).withName(this.myCommandName).run(() -> {
            XmlElement el;
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
            MavenDomProjectModel model = MavenDomUtil.getMavenDomProjectModel(project2, pom);
            if (model == null) {
                return;
            }
            MavenDomUtil.updateMavenParent(model, this.myParentProject);
            if (this.myInheritGroupId && (el = model.getGroupId().getXmlElement()) != null) {
                el.delete();
            }
            if (this.myInheritVersion && (el = model.getVersion().getXmlElement()) != null) {
                el.delete();
            }
            CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)MavenModuleBuilderHelper.getPsiFile(project2, pom));
            ArrayList<VirtualFile> pomFiles = new ArrayList<VirtualFile>(2);
            pomFiles.add(pom);
            if (!FileUtil.namesEqual((String)"pom.xml", (String)this.myParentProject.getFile().getName())) {
                pomFiles.add(this.myParentProject.getFile());
                MavenProjectsManager.getInstance(project2).forceUpdateProjects(Collections.singleton(this.myParentProject));
            }
            MavenModuleBuilderHelper.unblockAndSaveDocuments(project2, pomFiles.toArray(VirtualFile.EMPTY_ARRAY));
        });
    }

    private static void unblockAndSaveDocuments(@NotNull Project project2, VirtualFile ... files2) {
        if (project2 == null) {
            MavenModuleBuilderHelper.$$$reportNull$$$0(1);
        }
        if (files2 == null) {
            MavenModuleBuilderHelper.$$$reportNull$$$0(2);
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
        for (VirtualFile file : files2) {
            Document document = fileDocumentManager.getDocument(file);
            if (document == null) continue;
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
            fileDocumentManager.saveDocument(document);
        }
    }

    private static PsiFile getPsiFile(Project project2, VirtualFile pom) {
        return PsiManager.getInstance((Project)project2).findFile(pom);
    }

    private void generateFromArchetype(Project project2, VirtualFile pom) {
        File workingDir;
        MavenActionsUsagesCollector.trigger(project2, MavenActionsUsagesCollector.CREATE_MAVEN_PROJECT_FROM_ARCHETYPE);
        try {
            workingDir = FileUtil.createTempDirectory((String)"archetype", (String)"tmp");
            workingDir.deleteOnExit();
        }
        catch (IOException e) {
            MavenModuleBuilderHelper.showError(project2, e);
            return;
        }
        MavenRunnerParameters params = new MavenRunnerParameters(false, workingDir.getPath(), (String)null, Collections.singletonList("org.apache.maven.plugins:maven-archetype-plugin:RELEASE:generate"), Collections.emptyList());
        MavenRunner runner = MavenRunner.getInstance(project2);
        MavenRunnerSettings settings = runner.getState().clone();
        Map<String, String> props = settings.getMavenProperties();
        props.put("interactiveMode", "false");
        props.putAll(this.myPropertiesToCreateByArtifact);
        runner.run(params, settings, () -> this.copyGeneratedFiles(workingDir, pom, project2, (String)props.get("artifactId")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void copyGeneratedFiles(File workingDir, VirtualFile pom, Project project2, String artifactId) {
        GitSilentFileAdder vcsFileAdder = GitSilentFileAdderProvider.create((Project)project2);
        try {
            try {
                String string = artifactId = artifactId != null ? artifactId : this.myProjectId.getArtifactId();
                if (artifactId != null) {
                    File sourceDir = new File(workingDir, artifactId);
                    File targetDir = new File(pom.getParent().getPath());
                    vcsFileAdder.markFileForAdding(targetDir, true);
                    FileUtil.copyDir((File)sourceDir, (File)targetDir);
                }
                FileUtil.delete((File)workingDir);
            }
            catch (Exception e) {
                MavenModuleBuilderHelper.showError(project2, e);
                vcsFileAdder.finish();
                return;
            }
            pom.getParent().refresh(false, false);
            pom.refresh(false, false);
            this.updateProjectPom(project2, pom);
            LocalFileSystem.getInstance().refreshWithoutFileWatcher(true);
        }
        finally {
            vcsFileAdder.finish();
        }
    }

    private static void showError(Project project2, Throwable e) {
        MavenUtil.showError(project2, MavenProjectBundle.message("notification.title.failed.to.create.maven.project", new Object[0]), e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/wizards/MavenModuleBuilderHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "unblockAndSaveDocuments";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

