/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import org.apache.oro.text.MalformedCachePatternException;
import org.apache.oro.text.PatternCache;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;

public abstract class RegexFilenameFilter
implements FilenameFilter,
FileFilter {
    PatternCache _cache;
    PatternMatcher _matcher;
    Pattern _pattern;

    RegexFilenameFilter(PatternCache patternCache, PatternMatcher patternMatcher, String string2) {
        this._cache = patternCache;
        this._matcher = patternMatcher;
        this.setFilterExpression(string2);
    }

    RegexFilenameFilter(PatternCache patternCache, PatternMatcher patternMatcher, String string2, int n) {
        this._cache = patternCache;
        this._matcher = patternMatcher;
        this.setFilterExpression(string2, n);
    }

    RegexFilenameFilter(PatternCache patternCache, PatternMatcher patternMatcher) {
        this(patternCache, patternMatcher, "");
    }

    public void setFilterExpression(String string2) throws MalformedCachePatternException {
        this._pattern = this._cache.getPattern(string2);
    }

    public void setFilterExpression(String string2, int n) throws MalformedCachePatternException {
        this._pattern = this._cache.getPattern(string2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accept(File file2, String string2) {
        PatternMatcher patternMatcher = this._matcher;
        synchronized (patternMatcher) {
            return this._matcher.matches(string2, this._pattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accept(File file2) {
        PatternMatcher patternMatcher = this._matcher;
        synchronized (patternMatcher) {
            return this._matcher.matches(file2.getName(), this._pattern);
        }
    }
}

