/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.CommandHistoryPresenter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000e\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/terminal/exp/CommandHistoryPresenter;", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;)V", "initialCommand", "", "onCommandHistoryClosed", "", "showCommandHistory", "history", "", "CommandHistoryLookupArranger", "Companion", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nCommandHistoryPresenter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandHistoryPresenter.kt\norg/jetbrains/plugins/terminal/exp/CommandHistoryPresenter\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,114:1\n26#2:115\n1864#3,3:116\n8#4:119\n*S KotlinDebug\n*F\n+ 1 CommandHistoryPresenter.kt\norg/jetbrains/plugins/terminal/exp/CommandHistoryPresenter\n*L\n25#1:115\n27#1:116,3\n70#1:119\n*E\n"})
public final class CommandHistoryPresenter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    @Nullable
    private String initialCommand;
    @NotNull
    private static final Key<Boolean> IS_COMMAND_HISTORY_LOOKUP_KEY;

    public CommandHistoryPresenter(@NotNull Project project, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.project = project;
        this.editor = editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void showCommandHistory(@NotNull List<String> history) {
        String command;
        Intrinsics.checkNotNullParameter(history, (String)"history");
        String string = this.editor.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"editor.document.text");
        this.initialCommand = command = string;
        String prefix = ((Object)StringsKt.trim((CharSequence)command)).toString();
        CommandHistoryLookupArranger arranger = new CommandHistoryLookupArranger();
        boolean $i$f$emptyArray = false;
        Lookup lookup = LookupManager.getInstance((Project)this.project).createLookup(this.editor, new LookupElement[0], prefix, (LookupArranger)arranger);
        Intrinsics.checkNotNull((Object)lookup, (String)"null cannot be cast to non-null type com.intellij.codeInsight.lookup.impl.LookupImpl");
        LookupImpl lookup2 = (LookupImpl)lookup;
        PlainPrefixMatcher matcher = new PlainPrefixMatcher(prefix, true);
        Iterable $this$forEachIndexed$iv = history;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            LookupElementBuilder item;
            void cmd;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string2 = (String)item$iv;
            int index = n;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)LookupElementBuilder.create((Object)index, (String)cmd), (String)"create(index, cmd)");
            lookup2.addItem((LookupElement)item, (PrefixMatcher)matcher);
        }
        lookup2.putUserData(IS_COMMAND_HISTORY_LOOKUP_KEY, (Object)true);
        lookup2.addLookupListener(new LookupListener(lookup2, this){
            final /* synthetic */ LookupImpl $lookup;
            final /* synthetic */ CommandHistoryPresenter this$0;
            {
                this.$lookup = $lookup;
                this.this$0 = $receiver;
            }

            public void currentItemChanged(@NotNull LookupEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Object object = event.getItem();
                if (object == null || (object = object.getLookupString()) == null) {
                    return;
                }
                Object selectedCommand = object;
                ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this.$lookup, this.this$0, (String)selectedCommand){
                    final /* synthetic */ LookupImpl $lookup;
                    final /* synthetic */ CommandHistoryPresenter this$0;
                    final /* synthetic */ String $selectedCommand;
                    {
                        this.$lookup = $lookup;
                        this.this$0 = $receiver;
                        this.$selectedCommand = $selectedCommand;
                        super(0);
                    }

                    public final void invoke() {
                        if (!this.$lookup.isLookupDisposed()) {
                            ActionsKt.runWriteAction((Function0)((Function0)new Function0<Boolean>(this.$lookup, this.this$0, this.$selectedCommand){
                                final /* synthetic */ LookupImpl $lookup;
                                final /* synthetic */ CommandHistoryPresenter this$0;
                                final /* synthetic */ String $selectedCommand;
                                {
                                    this.$lookup = $lookup;
                                    this.this$0 = $receiver;
                                    this.$selectedCommand = $selectedCommand;
                                    super(0);
                                }

                                @NotNull
                                public final Boolean invoke() {
                                    return this.$lookup.performGuardedChange(() -> showCommandHistory.currentItemChanged.1.invoke$lambda$0(this.this$0, this.$selectedCommand));
                                }

                                private static final void invoke$lambda$0(CommandHistoryPresenter this$0, String $selectedCommand) {
                                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                                    Intrinsics.checkNotNullParameter((Object)$selectedCommand, (String)"$selectedCommand");
                                    CommandHistoryPresenter.access$getEditor$p(this$0).getDocument().setText((CharSequence)$selectedCommand);
                                    CommandHistoryPresenter.access$getEditor$p(this$0).getCaretModel().moveToOffset($selectedCommand.length());
                                }
                            }));
                        }
                    }
                }), (int)1, null);
            }

            public boolean beforeItemSelected(@NotNull LookupEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return false;
            }

            public void itemSelected(@NotNull LookupEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                CommandHistoryPresenter.access$setInitialCommand$p(this.this$0, null);
            }

            public void lookupCanceled(@NotNull LookupEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                CommandHistoryPresenter.access$setInitialCommand$p(this.this$0, null);
            }
        });
        Boolean showBottomPanel = (Boolean)this.editor.getUserData(AutoPopupController.SHOW_BOTTOM_PANEL_IN_LOOKUP_UI);
        try {
            this.editor.putUserData(AutoPopupController.SHOW_BOTTOM_PANEL_IN_LOOKUP_UI, (Object)false);
            if (lookup2.showLookup()) {
                lookup2.ensureSelectionVisible(false);
            } else {
                CommandHistoryPresenter $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(CommandHistoryPresenter.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
                logger.error("Failed to show command history");
            }
        }
        finally {
            this.editor.putUserData(AutoPopupController.SHOW_BOTTOM_PANEL_IN_LOOKUP_UI, (Object)showBottomPanel);
        }
    }

    public final void onCommandHistoryClosed() {
        String commandToRestore = this.initialCommand;
        if (commandToRestore != null) {
            this.initialCommand = null;
            ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this, commandToRestore){
                final /* synthetic */ CommandHistoryPresenter this$0;
                final /* synthetic */ String $commandToRestore;
                {
                    this.this$0 = $receiver;
                    this.$commandToRestore = $commandToRestore;
                    super(0);
                }

                public final void invoke() {
                    ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this.this$0, this.$commandToRestore){
                        final /* synthetic */ CommandHistoryPresenter this$0;
                        final /* synthetic */ String $commandToRestore;
                        {
                            this.this$0 = $receiver;
                            this.$commandToRestore = $commandToRestore;
                            super(0);
                        }

                        public final void invoke() {
                            CommandHistoryPresenter.access$getEditor$p(this.this$0).getDocument().setText((CharSequence)this.$commandToRestore);
                            CommandHistoryPresenter.access$getEditor$p(this.this$0).getCaretModel().moveToOffset(this.$commandToRestore.length());
                        }
                    }));
                }
            }), (int)1, null);
        }
    }

    public static final /* synthetic */ Editor access$getEditor$p(CommandHistoryPresenter $this) {
        return $this.editor;
    }

    public static final /* synthetic */ void access$setInitialCommand$p(CommandHistoryPresenter $this, String string) {
        $this.initialCommand = string;
    }

    static {
        Key key = Key.create((String)"isCommandHistoryLookup");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(\"isCommandHistoryLookup\")");
        IS_COMMAND_HISTORY_LOOKUP_KEY = key;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0001H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/terminal/exp/CommandHistoryPresenter$CommandHistoryLookupArranger;", "Lcom/intellij/codeInsight/lookup/LookupArranger;", "()V", "arrangeItems", "Lcom/intellij/openapi/util/Pair;", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "", "lookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "onExplicitAction", "", "createEmptyCopy", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nCommandHistoryPresenter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandHistoryPresenter.kt\norg/jetbrains/plugins/terminal/exp/CommandHistoryPresenter$CommandHistoryLookupArranger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1855#2,2:115\n*S KotlinDebug\n*F\n+ 1 CommandHistoryPresenter.kt\norg/jetbrains/plugins/terminal/exp/CommandHistoryPresenter$CommandHistoryLookupArranger\n*L\n97#1:115,2\n*E\n"})
    private static final class CommandHistoryLookupArranger
    extends LookupArranger {
        @NotNull
        public Pair<List<LookupElement>, Integer> arrangeItems(@NotNull Lookup lookup, boolean onExplicitAction) {
            Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
            List result2 = new ArrayList();
            List list = this.getMatchingItems();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"matchingItems");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LookupElement item = (LookupElement)element$iv;
                boolean bl = false;
                LookupElement lookupElement = (LookupElement)CollectionsKt.lastOrNull((List)result2);
                if (Intrinsics.areEqual((Object)(lookupElement != null ? lookupElement.getLookupString() : null), (Object)item.getLookupString())) continue;
                Intrinsics.checkNotNullExpressionValue((Object)item, (String)"item");
                result2.add(item);
            }
            int selectedIndex = !lookup.isSelectionTouched() && onExplicitAction ? CollectionsKt.getLastIndex((List)result2) : CollectionsKt.indexOf((List)result2, (Object)lookup.getCurrentItem());
            Pair pair = Pair.create((Object)result2, (Object)Math.max(selectedIndex, 0));
            Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(result, max(selectedIndex, 0))");
            return pair;
        }

        @NotNull
        public LookupArranger createEmptyCopy() {
            return new CommandHistoryLookupArranger();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/terminal/exp/CommandHistoryPresenter$Companion;", "", "()V", "IS_COMMAND_HISTORY_LOOKUP_KEY", "Lcom/intellij/openapi/util/Key;", "", "getIS_COMMAND_HISTORY_LOOKUP_KEY", "()Lcom/intellij/openapi/util/Key;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Boolean> getIS_COMMAND_HISTORY_LOOKUP_KEY() {
            return IS_COMMAND_HISTORY_LOOKUP_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

