/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.api.configurations;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\b\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bR\u0014\u0010\t\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/profiler/api/configurations/RepeatingMigratorIndexesException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "repeatingIndex", "", "migratorsSharingIndex", "", "", "(ILjava/util/List;)V", "message", "getMessage", "()Ljava/lang/String;", "getMigratorsSharingIndex", "()Ljava/util/List;", "getRepeatingIndex", "()I", "intellij.profiler.common"})
public final class RepeatingMigratorIndexesException
extends Exception {
    private final int repeatingIndex;
    @NotNull
    private final List<String> migratorsSharingIndex;
    @NotNull
    private final String message;

    public RepeatingMigratorIndexesException(int repeatingIndex, @NotNull List<String> migratorsSharingIndex) {
        Intrinsics.checkNotNullParameter(migratorsSharingIndex, (String)"migratorsSharingIndex");
        this.repeatingIndex = repeatingIndex;
        this.migratorsSharingIndex = migratorsSharingIndex;
        if (!(this.migratorsSharingIndex.size() > 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.message = StringsKt.trimIndent((String)("\n    Precondition failed: one or more migrators have the same index " + this.repeatingIndex + ": " + CollectionsKt.joinToString$default((Iterable)this.migratorsSharingIndex, null, null, null, (int)0, null, null, (int)63, null) + "\n  "));
    }

    public final int getRepeatingIndex() {
        return this.repeatingIndex;
    }

    @NotNull
    public final List<String> getMigratorsSharingIndex() {
        return this.migratorsSharingIndex;
    }

    @Override
    @NotNull
    public String getMessage() {
        return this.message;
    }
}

