/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.eventtrace.intervals;

import com.intellij.execution.filters.Filter;
import com.intellij.profiler.eventtrace.intervals.ColorizeTimelineInterval;
import com.intellij.profiler.eventtrace.intervals.TextualTimelineInterval;
import com.intellij.profiler.eventtrace.intervals.TraceLineIntervalEvent;
import com.intellij.ui.JBColor;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J \u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dJ\b\u0010\u001f\u001a\u00020\u0015H\u0016R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0014\u0010\u0012\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006 "}, d2={"Lcom/intellij/profiler/eventtrace/intervals/TraceEventLineInterval;", "Lcom/intellij/profiler/eventtrace/intervals/ColorizeTimelineInterval;", "Lcom/intellij/profiler/eventtrace/intervals/TraceLineIntervalEvent;", "Lcom/intellij/profiler/eventtrace/intervals/TextualTimelineInterval;", "intervalEvent", "(Lcom/intellij/profiler/eventtrace/intervals/TraceLineIntervalEvent;)V", "color", "Lcom/intellij/ui/JBColor;", "getColor", "()Lcom/intellij/ui/JBColor;", "content", "getContent", "()Lcom/intellij/profiler/eventtrace/intervals/TraceLineIntervalEvent;", "end", "", "getEnd", "()J", "getIntervalEvent", "start", "getStart", "text", "", "getText", "()Ljava/lang/String;", "toLabel", "Ljavax/swing/JComponent;", "filter", "Lcom/intellij/execution/filters/Filter;", "hyperLinkCreator", "Lkotlin/Function0;", "Ljavax/swing/event/HyperlinkListener;", "toString", "intellij.profiler.common"})
public final class TraceEventLineInterval
implements ColorizeTimelineInterval<TraceLineIntervalEvent>,
TextualTimelineInterval<TraceLineIntervalEvent> {
    @NotNull
    private final TraceLineIntervalEvent intervalEvent;
    private final long start;
    private final long end;

    public TraceEventLineInterval(@NotNull TraceLineIntervalEvent intervalEvent) {
        Intrinsics.checkNotNullParameter((Object)intervalEvent, (String)"intervalEvent");
        this.intervalEvent = intervalEvent;
        this.start = this.intervalEvent.getStart();
        this.end = this.intervalEvent.getEnd();
    }

    @NotNull
    public final TraceLineIntervalEvent getIntervalEvent() {
        return this.intervalEvent;
    }

    @Override
    @NotNull
    public TraceLineIntervalEvent getContent() {
        return this.intervalEvent;
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public long getEnd() {
        return this.end;
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.intervalEvent);
    }

    @NotNull
    public final JComponent toLabel(@Nullable Filter filter, @Nullable Function0<? extends HyperlinkListener> hyperLinkCreator) {
        return this.intervalEvent.toLabel(filter, hyperLinkCreator);
    }

    @Override
    @Nullable
    public JBColor getColor() {
        JBColor jBColor;
        if (this.intervalEvent.getColor() == null) {
            jBColor = null;
        } else {
            Color color2 = this.intervalEvent.getColor();
            Intrinsics.checkNotNull((Object)color2);
            Color color3 = this.intervalEvent.getColor();
            Intrinsics.checkNotNull((Object)color3);
            jBColor = new JBColor(color2, color3);
        }
        return jBColor;
    }

    @Override
    @NotNull
    public String getText() {
        return this.intervalEvent.toShortString();
    }
}

