/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.flamegraph;

import com.intellij.profiler.ui.flamegraph.ViewScroller;
import com.intellij.ui.ComponentUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JViewport;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J3\u0010\t\u001a\u00020\n\"\b\b\u0000\u0010\u000b*\u00020\f2\u0006\u0010\r\u001a\u0002H\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u00020\n0\u0003H\u0016\u00a2\u0006\u0002\u0010\u000fR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/profiler/ui/flamegraph/AnchorViewScroller;", "Lcom/intellij/profiler/ui/flamegraph/ViewScroller;", "transform", "Lkotlin/Function1;", "Ljava/awt/Rectangle;", "Ljava/awt/Point;", "(Lkotlin/jvm/functions/Function1;)V", "getTransform", "()Lkotlin/jvm/functions/Function1;", "scroll", "", "T", "Ljava/awt/Component;", "panel", "componentResizing", "(Ljava/awt/Component;Lkotlin/jvm/functions/Function1;)V", "intellij.profiler.common"})
public final class AnchorViewScroller
implements ViewScroller {
    @NotNull
    private final Function1<Rectangle, Point> transform;

    public AnchorViewScroller(@NotNull Function1<? super Rectangle, ? extends Point> transform2) {
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        this.transform = transform2;
    }

    @NotNull
    public final Function1<Rectangle, Point> getTransform() {
        return this.transform;
    }

    @Override
    public <T extends Component> void scroll(@NotNull T panel2, @NotNull Function1<? super T, Unit> componentResizing) {
        block3: {
            Unit unit;
            Intrinsics.checkNotNullParameter(panel2, (String)"panel");
            Intrinsics.checkNotNullParameter(componentResizing, (String)"componentResizing");
            JViewport jViewport = ComponentUtil.getViewport(panel2);
            if (jViewport != null) {
                JViewport it = jViewport;
                boolean bl = false;
                Rectangle view = it.getViewRect();
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
                Point anchor = (Point)this.transform.invoke((Object)view);
                int dx = anchor.x - view.x;
                int dy = anchor.y - view.y;
                double ratioX = (double)anchor.x / (double)panel2.getWidth();
                double ratioY = (double)anchor.y / (double)panel2.getHeight();
                componentResizing.invoke(panel2);
                double d = ratioX;
                if (!Double.isInfinite(d) && !Double.isNaN(d) && !Double.isInfinite(d = ratioY) && !Double.isNaN(d)) {
                    it.setViewPosition(new Point(MathKt.roundToInt((double)((double)panel2.getWidth() * ratioX)) - dx, MathKt.roundToInt((double)((double)panel2.getHeight() * ratioY)) - dy));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block3;
            componentResizing.invoke(panel2);
        }
    }
}

