/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Throwable2Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.CurrentRevisionProvider;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.SLRUMap;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ContentRevisionCache {
    private final Object myLock;
    private final SLRUMap<Key, java.lang.ref.SoftReference<byte[]>> myCache;
    private final SLRUMap<CurrentKey, VcsRevisionNumber> myCurrentRevisionsCache;
    private final Map<Key, byte[]> myConstantCache = new HashMap<Key, byte[]>();
    private long myCounter = 0L;

    public ContentRevisionCache() {
        this.myLock = new Object();
        this.myCache = new SLRUMap(100, 50);
        this.myCurrentRevisionsCache = new SLRUMap(200, 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(FilePath path2, VcsRevisionNumber number, @NotNull VcsKey vcsKey, @NotNull UniqueType type2, byte @Nullable [] bytes) {
        if (vcsKey == null) {
            ContentRevisionCache.$$$reportNull$$$0(0);
        }
        if (type2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(1);
        }
        if (bytes == null) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myCache.put((Object)new Key(path2, number, vcsKey, type2), new java.lang.ref.SoftReference<byte[]>(bytes));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllCurrent() {
        Object object = this.myLock;
        synchronized (object) {
            ++this.myCounter;
            this.myCurrentRevisionsCache.clear();
        }
    }

    public void clearScope(List<? extends VcsDirtyScope> scopes) {
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myLock;
            synchronized (object) {
                ++this.myCounter;
                for (VcsDirtyScope scope2 : scopes) {
                    HashSet toRemove = new HashSet();
                    this.myCurrentRevisionsCache.iterateKeys(currentKey -> {
                        if (scope2.belongsTo(currentKey.getPath())) {
                            toRemove.add(currentKey);
                        }
                    });
                    for (CurrentKey key2 : toRemove) {
                        this.myCurrentRevisionsCache.remove((Object)key2);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCurrent(Set<String> paths) {
        HashSet<String> converted = new HashSet<String>();
        for (String path2 : paths) {
            converted.add(FilePathsHelper.convertPath(path2));
        }
        Object object = this.myLock;
        synchronized (object) {
            HashSet toRemove = new HashSet();
            this.myCurrentRevisionsCache.iterateKeys(currentKey -> {
                if (converted.contains(FilePathsHelper.convertPath(currentKey.getPath().getPath()))) {
                    toRemove.add(currentKey);
                }
            });
            for (CurrentKey key2 : toRemove) {
                this.myCurrentRevisionsCache.remove((Object)key2);
            }
        }
    }

    @Contract(value="!null, _, _ -> !null")
    @Nullable
    public static String getAsString(byte @Nullable [] bytes, @NotNull FilePath file, @Nullable Charset charset) {
        if (file == null) {
            ContentRevisionCache.$$$reportNull$$$0(2);
        }
        if (bytes == null) {
            return null;
        }
        if (charset == null) {
            return ContentRevisionCache.bytesToString(file, bytes);
        }
        return CharsetToolkit.bytesToString((byte[])bytes, (Charset)charset);
    }

    @NotNull
    public static String getOrLoadAsString(@NotNull Project project2, @NotNull FilePath file, VcsRevisionNumber number, @NotNull VcsKey key2, @NotNull UniqueType type2, @NotNull Throwable2Computable<byte[], ? extends VcsException, ? extends IOException> loader2, @Nullable Charset charset) throws VcsException, IOException {
        if (project2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(3);
        }
        if (file == null) {
            ContentRevisionCache.$$$reportNull$$$0(4);
        }
        if (key2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(5);
        }
        if (type2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(6);
        }
        if (loader2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(7);
        }
        byte[] bytes = ContentRevisionCache.getOrLoadAsBytes(project2, file, number, key2, type2, loader2);
        String string2 = ContentRevisionCache.getAsString(bytes, file, charset);
        if (string2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @NotNull
    public static String getOrLoadAsString(Project project2, FilePath path2, VcsRevisionNumber number, @NotNull VcsKey vcsKey, @NotNull UniqueType type2, Throwable2Computable<byte[], ? extends VcsException, ? extends IOException> loader2) throws VcsException, IOException {
        if (vcsKey == null) {
            ContentRevisionCache.$$$reportNull$$$0(9);
        }
        if (type2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(10);
        }
        return ContentRevisionCache.getOrLoadAsString(project2, path2, number, vcsKey, type2, loader2, null);
    }

    @NotNull
    private static String bytesToString(FilePath path2, byte @NotNull [] bytes) {
        if (bytes == null) {
            ContentRevisionCache.$$$reportNull$$$0(11);
        }
        Charset charset = null;
        if (path2.getVirtualFile() != null) {
            charset = path2.getVirtualFile().getCharset();
        }
        if (charset != null) {
            int bomLength = CharsetToolkit.getBOMLength((byte[])bytes, (Charset)charset);
            CharBuffer charBuffer = charset.decode(ByteBuffer.wrap(bytes, bomLength, bytes.length - bomLength));
            String string2 = charBuffer.toString();
            if (string2 == null) {
                ContentRevisionCache.$$$reportNull$$$0(12);
            }
            return string2;
        }
        String string3 = CharsetToolkit.bytesToString((byte[])bytes, (Charset)EncodingRegistry.getInstance().getDefaultCharset());
        if (string3 == null) {
            ContentRevisionCache.$$$reportNull$$$0(13);
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte @Nullable [] getBytes(FilePath path2, VcsRevisionNumber number, @NotNull VcsKey vcsKey, @NotNull UniqueType type2) {
        if (vcsKey == null) {
            ContentRevisionCache.$$$reportNull$$$0(14);
        }
        if (type2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(15);
        }
        Object object = this.myLock;
        synchronized (object) {
            java.lang.ref.SoftReference reference = (java.lang.ref.SoftReference)this.myCache.get((Object)new Key(path2, number, vcsKey, type2));
            return (byte[])SoftReference.dereference((Reference)reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putCurrent(FilePath path2, VcsRevisionNumber number, @NotNull VcsKey vcsKey, long counter) {
        if (vcsKey == null) {
            ContentRevisionCache.$$$reportNull$$$0(16);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myCounter != counter) {
                return false;
            }
            ++this.myCounter;
            this.myCurrentRevisionsCache.put((Object)new CurrentKey(path2, vcsKey), (Object)number);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<VcsRevisionNumber, Long> getCurrent(FilePath path2, VcsKey vcsKey) {
        Object object = this.myLock;
        synchronized (object) {
            return new Pair((Object)((VcsRevisionNumber)this.myCurrentRevisionsCache.get((Object)new CurrentKey(path2, vcsKey))), (Object)this.myCounter);
        }
    }

    public static byte @NotNull [] loadAsBytes(@NotNull FilePath path2, Throwable2Computable<byte @NotNull [], ? extends VcsException, ? extends IOException> loader2) throws VcsException, IOException {
        if (path2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(17);
        }
        ContentRevisionCache.checkLocalFileSize(path2);
        byte[] byArray = (byte[])loader2.compute();
        if (byArray == null) {
            ContentRevisionCache.$$$reportNull$$$0(18);
        }
        return byArray;
    }

    public static byte @NotNull [] getOrLoadAsBytes(Project project2, FilePath path2, VcsRevisionNumber number, @NotNull VcsKey vcsKey, @NotNull UniqueType type2, Throwable2Computable<byte @NotNull [], ? extends VcsException, ? extends IOException> loader2) throws VcsException, IOException {
        ContentRevisionCache cache;
        byte[] bytes;
        if (vcsKey == null) {
            ContentRevisionCache.$$$reportNull$$$0(19);
        }
        if (type2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(20);
        }
        if ((bytes = (cache = ProjectLevelVcsManager.getInstance(project2).getContentRevisionCache()).getBytes(path2, number, vcsKey, type2)) != null) {
            if (bytes == null) {
                ContentRevisionCache.$$$reportNull$$$0(21);
            }
            return bytes;
        }
        bytes = cache.getFromConstantCache(path2, number, vcsKey, type2);
        if (bytes != null) {
            if (bytes == null) {
                ContentRevisionCache.$$$reportNull$$$0(22);
            }
            return bytes;
        }
        ContentRevisionCache.checkLocalFileSize(path2);
        bytes = (byte[])loader2.compute();
        cache.put(path2, number, vcsKey, type2, bytes);
        if (bytes == null) {
            ContentRevisionCache.$$$reportNull$$$0(23);
        }
        return bytes;
    }

    private static void checkLocalFileSize(@NotNull FilePath path2) throws VcsException {
        File ioFile;
        if (path2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(24);
        }
        if ((ioFile = path2.getIOFile()).exists()) {
            ContentRevisionCache.checkContentsSize(ioFile.getPath(), ioFile.length());
        }
    }

    public static void checkContentsSize(String path2, long size) throws VcsException {
        if (size > (long)VcsUtil.getMaxVcsLoadedFileSize()) {
            throw new VcsException(VcsBundle.message("file.content.too.big.to.load.increase.property.suggestion", path2, StringUtil.formatFileSize((long)VcsUtil.getMaxVcsLoadedFileSize()), "idea.max.vcs.loaded.size.kb"));
        }
    }

    private static VcsRevisionNumber putIntoCurrentCache(ContentRevisionCache cache, FilePath path2, @NotNull VcsKey vcsKey, CurrentRevisionProvider loader2) throws VcsException {
        Pair<VcsRevisionNumber, Long> currentRevision;
        VcsRevisionNumber loadedRevisionNumber;
        if (vcsKey == null) {
            ContentRevisionCache.$$$reportNull$$$0(25);
        }
        do {
            if (!(loadedRevisionNumber = loader2.getCurrentRevision()).equals((currentRevision = cache.getCurrent(path2, vcsKey)).getFirst())) continue;
            return loadedRevisionNumber;
        } while (!cache.putCurrent(path2, loadedRevisionNumber, vcsKey, (Long)currentRevision.getSecond()));
        return loadedRevisionNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putIntoConstantCache(@NotNull FilePath path2, @NotNull VcsRevisionNumber revisionNumber, @NotNull VcsKey vcsKey, byte[] content) {
        if (path2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(26);
        }
        if (revisionNumber == null) {
            ContentRevisionCache.$$$reportNull$$$0(27);
        }
        if (vcsKey == null) {
            ContentRevisionCache.$$$reportNull$$$0(28);
        }
        Map<Key, byte[]> map2 = this.myConstantCache;
        synchronized (map2) {
            this.myConstantCache.put(new Key(path2, revisionNumber, vcsKey, UniqueType.REPOSITORY_CONTENT), content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getFromConstantCache(@NotNull FilePath path2, @NotNull VcsRevisionNumber revisionNumber, @NotNull VcsKey vcsKey, @NotNull UniqueType type2) {
        if (path2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(29);
        }
        if (revisionNumber == null) {
            ContentRevisionCache.$$$reportNull$$$0(30);
        }
        if (vcsKey == null) {
            ContentRevisionCache.$$$reportNull$$$0(31);
        }
        if (type2 == null) {
            ContentRevisionCache.$$$reportNull$$$0(32);
        }
        Map<Key, byte[]> map2 = this.myConstantCache;
        synchronized (map2) {
            return this.myConstantCache.get(new Key(path2, revisionNumber, vcsKey, type2));
        }
    }

    public void clearConstantCache() {
        this.myConstantCache.clear();
    }

    public static Pair<VcsRevisionNumber, byte[]> getOrLoadCurrentAsBytes(Project project2, FilePath path2, @NotNull VcsKey vcsKey, CurrentRevisionProvider loader2) throws VcsException, IOException {
        VcsRevisionNumber currentRevision;
        Pair<VcsRevisionNumber, byte[]> loaded;
        if (vcsKey == null) {
            ContentRevisionCache.$$$reportNull$$$0(33);
        }
        ContentRevisionCache cache = ProjectLevelVcsManager.getInstance(project2).getContentRevisionCache();
        do {
            byte[] cachedCurrent;
            if ((cachedCurrent = cache.getBytes(path2, currentRevision = ContentRevisionCache.putIntoCurrentCache(cache, path2, vcsKey, loader2), vcsKey, UniqueType.REPOSITORY_CONTENT)) != null) {
                return Pair.create((Object)currentRevision, (Object)cachedCurrent);
            }
            ContentRevisionCache.checkLocalFileSize(path2);
        } while (!((VcsRevisionNumber)(loaded = loader2.get()).getFirst()).equals(currentRevision));
        cache.put(path2, currentRevision, vcsKey, UniqueType.REPOSITORY_CONTENT, (byte[])loaded.getSecond());
        return loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        Object object = this.myLock;
        synchronized (object) {
            ++this.myCounter;
            this.myCurrentRevisionsCache.clear();
            this.myCache.clear();
            this.myConstantCache.clear();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 12, 13, 18, 21, 22, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsKey";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 15: 
            case 20: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/ContentRevisionCache";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 17: 
            case 24: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/ContentRevisionCache";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrLoadAsString";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "bytesToString";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAsBytes";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrLoadAsBytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAsString";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOrLoadAsString";
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "bytesToString";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getBytes";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "putCurrent";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "loadAsBytes";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getOrLoadAsBytes";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkLocalFileSize";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "putIntoCurrentCache";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "putIntoConstantCache";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getFromConstantCache";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getOrLoadCurrentAsBytes";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8, 12, 13, 18, 21, 22, 23 -> new IllegalStateException(string2);
        };
    }

    private static final class Key
    extends CurrentKey {
        private final VcsRevisionNumber myNumber;
        private final UniqueType myType;

        private Key(FilePath path2, VcsRevisionNumber number, VcsKey vcsKey, UniqueType type2) {
            super(path2, vcsKey);
            this.myNumber = number;
            this.myType = type2;
        }

        public VcsRevisionNumber getNumber() {
            return this.myNumber;
        }

        public UniqueType getType() {
            return this.myType;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Key key2 = (Key)o;
            if (this.myNumber != null ? !this.myNumber.equals(key2.myNumber) : key2.myNumber != null) {
                return false;
            }
            if (!this.myPath.equals(key2.myPath)) {
                return false;
            }
            if (this.myType != key2.myType) {
                return false;
            }
            return this.myVcsKey.equals(key2.myVcsKey);
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + this.myPath.hashCode();
            result2 = 31 * result2 + (this.myNumber != null ? this.myNumber.hashCode() : 0);
            result2 = 31 * result2 + this.myVcsKey.hashCode();
            result2 = 31 * result2 + this.myType.hashCode();
            return result2;
        }
    }

    public static enum UniqueType {
        REPOSITORY_CONTENT,
        REMOTE_CONTENT;

    }

    private static class CurrentKey {
        protected final FilePath myPath;
        protected final VcsKey myVcsKey;

        private CurrentKey(FilePath path2, VcsKey vcsKey) {
            this.myPath = path2;
            this.myVcsKey = vcsKey;
        }

        public FilePath getPath() {
            return this.myPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CurrentKey that = (CurrentKey)o;
            if (this.myPath != null ? !this.myPath.equals(that.myPath) : that.myPath != null) {
                return false;
            }
            return !(this.myVcsKey != null ? !this.myVcsKey.equals(that.myVcsKey) : that.myVcsKey != null);
        }

        public int hashCode() {
            int result2 = this.myPath != null ? this.myPath.hashCode() : 0;
            result2 = 31 * result2 + (this.myVcsKey != null ? this.myVcsKey.hashCode() : 0);
            return result2;
        }
    }
}

