/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.impl.ContentRootChangeListener;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsStartupActivity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0003J \u0010\u0013\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0003J\b\u0010\u0018\u001a\u00020\u0012H\u0002J\"\u0010\u0019\u001a\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u00152\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015J\b\u0010\u001c\u001a\u00020\u0012H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/intellij/openapi/vcs/impl/ModuleVcsDetector;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "dirtyContentRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "queue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "vcsManager", "Lcom/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl;", "kotlin.jvm.PlatformType", "getVcsManager", "()Lcom/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl;", "vcsManager$delegate", "Lkotlin/Lazy;", "autoDetectDefaultRoots", "", "autoDetectForContentRoots", "contentRoots", "", "isInitialDetection", "", "runScanForNewContentRoots", "scheduleScanForNewContentRoots", "removed", "added", "startDetection", "MyStartUpActivity", "MyWorkspaceModelChangeListener", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nModuleVcsDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleVcsDetector.kt\ncom/intellij/openapi/vcs/impl/ModuleVcsDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 startUpMeasurer.kt\ncom/intellij/diagnostic/StartUpMeasurerKt\n*L\n1#1,156:1\n766#2:157\n857#2,2:158\n766#2:160\n857#2,2:161\n1855#2,2:163\n1549#2:165\n1620#2,3:166\n1549#2:169\n1620#2,3:170\n766#2:173\n857#2,2:174\n1855#2,2:176\n13#3,5:178\n*S KotlinDebug\n*F\n+ 1 ModuleVcsDetector.kt\ncom/intellij/openapi/vcs/impl/ModuleVcsDetector\n*L\n61#1:157\n61#1:158,2\n62#1:160\n62#1:161,2\n63#1:163,2\n71#1:165\n71#1:166,3\n118#1:169\n118#1:170,3\n119#1:173\n119#1:174,2\n120#1:176,2\n38#1:178,5\n*E\n"})
public final class ModuleVcsDetector {
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy vcsManager$delegate;
    @NotNull
    private final MergingUpdateQueue queue;
    @NotNull
    private final Set<VirtualFile> dirtyContentRoots;

    /*
     * WARNING - void declaration
     */
    public ModuleVcsDetector(@NotNull Project project2) {
        void it;
        MergingUpdateQueue mergingUpdateQueue;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.vcsManager$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<ProjectLevelVcsManagerImpl>(this){
            final /* synthetic */ ModuleVcsDetector this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final ProjectLevelVcsManagerImpl invoke() {
                return ProjectLevelVcsManagerImpl.getInstanceImpl(ModuleVcsDetector.access$getProject$p(this.this$0));
            }
        }));
        MergingUpdateQueue mergingUpdateQueue2 = mergingUpdateQueue = new MergingUpdateQueue("ModuleVcsDetector", 1000, true, null, (Disposable)this.project, null, Alarm.ThreadToUse.POOLED_THREAD);
        ModuleVcsDetector moduleVcsDetector = this;
        boolean bl = false;
        it.setRestartTimerOnAdd(true);
        moduleVcsDetector.queue = mergingUpdateQueue;
        this.dirtyContentRoots = new LinkedHashSet();
    }

    private final ProjectLevelVcsManagerImpl getVcsManager() {
        Lazy lazy = this.vcsManager$delegate;
        return (ProjectLevelVcsManagerImpl)lazy.getValue();
    }

    private final void startDetection() {
        ProjectLevelVcsManagerEx.MAPPING_DETECTION_LOG.debug("ModuleVcsDetector.startDetection");
        this.project.getMessageBus().connect().subscribe(WorkspaceModelTopics.CHANGED, (Object)new MyWorkspaceModelChangeListener());
        if (this.getVcsManager().needAutodetectMappings() && this.getVcsManager().haveDefaultMapping() == null && VcsUtil.shouldDetectVcsMappingsFor(this.project)) {
            this.queue.queue((Update)DisposableUpdate.createDisposable((Disposable)((Disposable)this.queue), (Object)"initial scan", () -> ModuleVcsDetector.startDetection$lambda$2(this)));
        }
    }

    @RequiresBackgroundThread
    private final void autoDetectDefaultRoots() {
        Collection<VirtualFile> collection = DefaultVcsRootPolicy.getInstance(this.project).getDefaultVcsRoots();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getInstance(project).defaultVcsRoots");
        Collection<VirtualFile> contentRoots = collection;
        Object[] objectArray = new Object[]{contentRoots};
        ProjectLevelVcsManagerEx.MAPPING_DETECTION_LOG.debug("ModuleVcsDetector.autoDetectDefaultRoots - contentRoots", objectArray);
        this.autoDetectForContentRoots(contentRoots, true);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    private final void autoDetectForContentRoots(Collection<? extends VirtualFile> contentRoots, boolean isInitialDetection) {
        void $this$mapTo$iv$iv;
        Object element$iv2;
        void $this$forEach$iv;
        VirtualFile it;
        Object element$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object[] objectArray = new Object[]{contentRoots};
        ProjectLevelVcsManagerEx.MAPPING_DETECTION_LOG.debug("ModuleVcsDetector.autoDetectForContentRoots - contentRoots", objectArray);
        if (this.getVcsManager().haveDefaultMapping() != null) {
            return;
        }
        Set usedVcses = new LinkedHashSet();
        Set detectedRoots = new LinkedHashSet();
        Iterable iterable = contentRoots;
        boolean $i$f$filter = false;
        void var7_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!it.isInLocalFileSystem()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!it.isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            VirtualFile root = (VirtualFile)element$iv2;
            boolean bl = false;
            AbstractVcs foundVcs = this.getVcsManager().findVersioningVcs(root);
            if (foundVcs == null || foundVcs == this.getVcsManager().getVcsFor(root)) continue;
            detectedRoots.add(new Pair((Object)root, (Object)foundVcs));
            usedVcses.add(foundVcs);
        }
        Object[] $this$map$iv = detectedRoots;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Pair bl = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add((VirtualFile)it2.getFirst());
        }
        Set directMappings = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv2));
        for (VcsRootChecker rootChecker : VcsRootChecker.EXTENSION_POINT_NAME.getExtensionList()) {
            AbstractVcs vcs;
            Collection<VirtualFile> detectedMappings;
            if (this.getVcsManager().findVcsByName(rootChecker.getSupportedVcs().getName()) == null || rootChecker.detectProjectMappings(this.project, contentRoots, directMappings) == null || detectedMappings.isEmpty()) continue;
            usedVcses.add(vcs);
            for (VirtualFile file : detectedMappings) {
                detectedRoots.add(new Pair((Object)file, (Object)vcs));
            }
        }
        if (detectedRoots.isEmpty()) {
            return;
        }
        $this$map$iv = new Object[]{detectedRoots};
        ProjectLevelVcsManagerEx.MAPPING_DETECTION_LOG.debug("ModuleVcsDetector.autoDetectForContentRoots - detectedRoots", $this$map$iv);
        AbstractVcs commonVcs = (AbstractVcs)CollectionsKt.singleOrNull((Iterable)usedVcses);
        if (commonVcs != null) {
            if (isInitialDetection) {
                ProjectLevelVcsManagerImpl projectLevelVcsManagerImpl = this.getVcsManager();
                List<VcsDirectoryMapping> list = this.getVcsManager().getDirectoryMappings();
                Intrinsics.checkNotNullExpressionValue(list, (String)"vcsManager.directoryMappings");
                projectLevelVcsManagerImpl.setAutoDirectoryMappings(CollectionsKt.plus((Collection)list, (Object)VcsDirectoryMapping.createDefault(commonVcs.getName())));
                return;
            }
            if (!this.getVcsManager().hasAnyMappings()) {
                this.getVcsManager().setAutoDirectoryMappings(CollectionsKt.listOf((Object)VcsDirectoryMapping.createDefault(commonVcs.getName())));
                return;
            }
        }
        this.getVcsManager().registerNewDirectMappings(detectedRoots);
    }

    static /* synthetic */ void autoDetectForContentRoots$default(ModuleVcsDetector moduleVcsDetector, Collection collection, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        moduleVcsDetector.autoDetectForContentRoots(collection, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void scheduleScanForNewContentRoots(@NotNull Collection<? extends VirtualFile> removed2, @NotNull Collection<? extends VirtualFile> added2) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(removed2, (String)"removed");
        Intrinsics.checkNotNullParameter(added2, (String)"added");
        if (!VcsUtil.shouldDetectVcsMappingsFor(this.project)) {
            return;
        }
        if (!added2.isEmpty()) {
            objectArray = new Object[]{added2};
            ProjectLevelVcsManagerEx.MAPPING_DETECTION_LOG.debug("ModuleVcsDetector.contentRootsChanged - roots added", objectArray);
            if (this.getVcsManager().haveDefaultMapping() == null) {
                Set<VirtualFile> set = this.dirtyContentRoots;
                synchronized (set) {
                    boolean bl = false;
                    this.dirtyContentRoots.addAll(added2);
                    bl = this.dirtyContentRoots.removeAll(CollectionsKt.toSet((Iterable)removed2));
                }
                this.queue.queue((Update)DisposableUpdate.createDisposable((Disposable)((Disposable)this.queue), (Object)"modules scan", () -> ModuleVcsDetector.scheduleScanForNewContentRoots$lambda$8(this)));
            }
        }
        if (!removed2.isEmpty()) {
            void $this$filterTo$iv$iv;
            void $this$mapTo$iv$iv;
            objectArray = new Object[]{removed2};
            ProjectLevelVcsManagerEx.MAPPING_DETECTION_LOG.debug("ModuleVcsDetector.contentRootsChanged - roots removed", objectArray);
            Iterable $this$map$iv = removed2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPath());
            }
            Set remotedPaths = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            List<VcsDirectoryMapping> list = this.getVcsManager().getDirectoryMappings();
            Intrinsics.checkNotNullExpressionValue(list, (String)"vcsManager.directoryMappings");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VcsDirectoryMapping it = (VcsDirectoryMapping)element$iv$iv;
                boolean bl = false;
                if (!remotedPaths.contains(it.getDirectory())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List removedMappings = (List)destination$iv$iv2;
            Iterable $this$forEach$iv = removedMappings;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VcsDirectoryMapping mapping = (VcsDirectoryMapping)element$iv;
                boolean bl = false;
                this.getVcsManager().removeDirectoryMapping(mapping);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runScanForNewContentRoots() {
        List contentRoots = null;
        Set<VirtualFile> set = this.dirtyContentRoots;
        synchronized (set) {
            boolean bl = false;
            contentRoots = CollectionsKt.toList((Iterable)this.dirtyContentRoots);
            this.dirtyContentRoots.clear();
            Unit unit = Unit.INSTANCE;
        }
        ModuleVcsDetector.autoDetectForContentRoots$default(this, contentRoots, false, 2, null);
    }

    private static final void startDetection$lambda$2(ModuleVcsDetector this$0) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            String name$iv = "ModuleVcsDetector.autoDetectDefaultRoots";
            ActivityCategory category$iv = ActivityCategory.DEFAULT;
            boolean $i$f$runActivity = false;
            Activity activity$iv = StartUpMeasurer.isEnabled() ? StartUpMeasurer.startActivity((String)name$iv, (ActivityCategory)category$iv) : null;
            boolean bl = false;
            this$0.autoDetectDefaultRoots();
            Unit result$iv = Unit.INSTANCE;
            Activity activity2 = activity$iv;
            if (activity2 == null) break block0;
            activity2.end();
        }
    }

    private static final void scheduleScanForNewContentRoots$lambda$8(ModuleVcsDetector this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.runScanForNewContentRoots();
    }

    public static final /* synthetic */ Project access$getProject$p(ModuleVcsDetector $this) {
        return $this.project;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/impl/ModuleVcsDetector$MyStartUpActivity;", "Lcom/intellij/openapi/vcs/impl/VcsStartupActivity;", "()V", "getOrder", "", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nModuleVcsDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleVcsDetector.kt\ncom/intellij/openapi/vcs/impl/ModuleVcsDetector$MyStartUpActivity\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,156:1\n29#2,3:157\n*S KotlinDebug\n*F\n+ 1 ModuleVcsDetector.kt\ncom/intellij/openapi/vcs/impl/ModuleVcsDetector$MyStartUpActivity\n*L\n148#1:157,3\n*E\n"})
    public static final class MyStartUpActivity
    implements VcsStartupActivity {
        public MyStartUpActivity() {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.create();
                Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"create()");
                throw (Throwable)extensionNotApplicableException;
            }
        }

        @Override
        public void runActivity(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<ModuleVcsDetector> serviceClass$iv = ModuleVcsDetector.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            ((ModuleVcsDetector)object).startDetection();
        }

        @Override
        public int getOrder() {
            return VcsInitObject.MAPPINGS.getOrder() + 10;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/impl/ModuleVcsDetector$MyWorkspaceModelChangeListener;", "Lcom/intellij/openapi/vcs/impl/ContentRootChangeListener;", "(Lcom/intellij/openapi/vcs/impl/ModuleVcsDetector;)V", "contentRootsChanged", "", "removed", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "added", "intellij.platform.vcs.impl"})
    private final class MyWorkspaceModelChangeListener
    extends ContentRootChangeListener {
        public MyWorkspaceModelChangeListener() {
            super(true);
        }

        @Override
        public void contentRootsChanged(@NotNull List<? extends VirtualFile> removed2, @NotNull List<? extends VirtualFile> added2) {
            Intrinsics.checkNotNullParameter(removed2, (String)"removed");
            Intrinsics.checkNotNullParameter(added2, (String)"added");
            ModuleVcsDetector.this.scheduleScanForNewContentRoots((Collection<? extends VirtualFile>)removed2, (Collection<? extends VirtualFile>)added2);
        }
    }
}

