/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.inspection;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.ProblemDescriptorWithReporterName;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.DynamicGroupTool;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.dupLocator.iterators.CountingNodeIterator;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextLikeFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ui.InspectionMetaDataDialog;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.structuralsearch.DefaultMatchResultSink;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;
import com.intellij.structuralsearch.inspection.MatchResultForPreview;
import com.intellij.structuralsearch.inspection.StructuralSearchInspectionToolWrapper;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SSBasedInspection
extends LocalInspectionTool
implements DynamicGroupTool {
    private static final Logger LOG = Logger.getInstance(SSBasedInspection.class);
    public static final Comparator<? super Configuration> CONFIGURATION_COMPARATOR = Comparator.comparing(Configuration::getName, NaturalComparator.INSTANCE).thenComparingInt(Configuration::getOrder);
    private static final Key<Map<Configuration, Matcher>> COMPILED_PATTERNS = Key.create((String)"SSR_COMPILED_PATTERNS");
    private final MultiMapEx<Configuration, Matcher> myCompiledPatterns = new MultiMapEx();
    @NonNls
    public static final String SHORT_NAME = "SSBasedInspection";
    private final List<Configuration> myConfigurations = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myWriteSorted = false;
    private final Set<String> myProblemsReported = new HashSet<String>(1);
    private InspectionProfileImpl mySessionProfile;

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            SSBasedInspection.$$$reportNull$$$0(0);
        }
        if (this.myWriteSorted) {
            ArrayList<Configuration> configurations = new ArrayList<Configuration>(this.myConfigurations);
            Collections.sort(configurations, CONFIGURATION_COMPARATOR);
            ConfigurationManager.writeConfigurations(node, configurations);
            for (Element child : node.getChildren()) {
                child.removeAttribute("order");
            }
        } else {
            ConfigurationManager.writeConfigurations(node, this.myConfigurations);
        }
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            SSBasedInspection.$$$reportNull$$$0(1);
        }
        this.myProblemsReported.clear();
        this.myConfigurations.clear();
        ConfigurationManager.readConfigurations(node, this.myConfigurations);
        Configuration previous = null;
        boolean sorted = true;
        for (Configuration configuration : this.myConfigurations) {
            if (configuration.getOrder() != 0 || previous != null && CONFIGURATION_COMPARATOR.compare(previous, configuration) > 0) {
                sorted = false;
                break;
            }
            previous = configuration;
        }
        if (sorted) {
            previous = null;
            for (Configuration configuration : this.myConfigurations) {
                if (previous != null && previous.getUuid().equals(configuration.getUuid())) {
                    configuration.setOrder(previous.getOrder() + 1);
                }
                previous = configuration;
            }
            this.myWriteSorted = true;
        }
    }

    @NotNull
    public String getGroupDisplayName() {
        String string2 = SSBasedInspection.getGeneralGroupName();
        if (string2 == null) {
            SSBasedInspection.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return SHORT_NAME;
    }

    public void initialize(@NotNull GlobalInspectionContext context) {
        if (context == null) {
            SSBasedInspection.$$$reportNull$$$0(3);
        }
        super.initialize(context);
        this.mySessionProfile = ((GlobalInspectionContextBase)context).getCurrentProfile();
    }

    public void cleanup(@NotNull Project project2) {
        if (project2 == null) {
            SSBasedInspection.$$$reportNull$$$0(4);
        }
        super.cleanup(project2);
        this.mySessionProfile = null;
        this.myCompiledPatterns.clear();
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder problemsHolder) {
        Map compiledPatterns;
        if (session == null) {
            SSBasedInspection.$$$reportNull$$$0(5);
        }
        if (problemsHolder == null) {
            SSBasedInspection.$$$reportNull$$$0(6);
        }
        if ((compiledPatterns = (Map)session.getUserData(COMPILED_PATTERNS)) != null) {
            this.checkInCompiledPatterns(compiledPatterns);
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            SSBasedInspection.$$$reportNull$$$0(7);
        }
        if (session == null) {
            SSBasedInspection.$$$reportNull$$$0(8);
        }
        if (this.myConfigurations.isEmpty()) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                SSBasedInspection.$$$reportNull$$$0(9);
            }
            return psiElementVisitor;
        }
        PsiFile file = holder.getFile();
        FileType fileType = file.getFileType();
        if (fileType instanceof PlainTextLikeFileType) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                SSBasedInspection.$$$reportNull$$$0(10);
            }
            return psiElementVisitor;
        }
        Project project2 = holder.getProject();
        InspectionProfileImpl profile = this.mySessionProfile != null && !isOnTheFly ? this.mySessionProfile : InspectionProfileManager.getInstance((Project)project2).getCurrentProfile();
        SmartList configurations = new SmartList();
        for (Configuration configuration : this.myConfigurations) {
            ToolsImpl tools;
            if (configuration.getFileType() != fileType && !configuration.getMatchOptions().isSearchInjectedCode() || (tools = profile.getToolsOrNull(configuration.getUuid(), project2)) == null || !tools.isEnabled((PsiElement)file)) continue;
            configurations.add(configuration);
            SSBasedInspection.register(configuration);
        }
        if (configurations.isEmpty()) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                SSBasedInspection.$$$reportNull$$$0(11);
            }
            return psiElementVisitor;
        }
        Map<Configuration, Matcher> compiledPatterns = this.checkOutCompiledPatterns((List<? extends Configuration>)configurations, project2);
        session.putUserData(COMPILED_PATTERNS, compiledPatterns);
        return new SSBasedVisitor(compiledPatterns, profile, holder);
    }

    public static void register(@NotNull Configuration configuration) {
        if (configuration == null) {
            SSBasedInspection.$$$reportNull$$$0(12);
        }
        if (configuration.getOrder() != 0) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            String shortName = configuration.getUuid();
            HighlightDisplayKey key2 = HighlightDisplayKey.find((String)shortName);
            if (key2 != null) {
                if (!SSBasedInspection.isMetaDataChanged(configuration, key2)) {
                    return;
                }
                HighlightDisplayKey.unregister((String)shortName);
            }
            String suppressId = configuration.getSuppressId();
            String name = configuration.getName();
            if (suppressId == null) {
                HighlightDisplayKey.register((String)shortName, () -> name, (String)SHORT_NAME);
            } else {
                HighlightDisplayKey.register((String)shortName, () -> name, (String)suppressId, (String)SHORT_NAME);
            }
        }, ModalityState.nonModal());
    }

    private static boolean isMetaDataChanged(@NotNull Configuration configuration, @NotNull HighlightDisplayKey key2) {
        if (configuration == null) {
            SSBasedInspection.$$$reportNull$$$0(13);
        }
        if (key2 == null) {
            SSBasedInspection.$$$reportNull$$$0(14);
        }
        if (StringUtil.isEmpty((String)configuration.getSuppressId()) ? !SHORT_NAME.equals(key2.getID()) : !configuration.getSuppressId().equals(key2.getID())) {
            return true;
        }
        return !configuration.getName().equals(HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)key2));
    }

    @NotNull
    public List<LocalInspectionToolWrapper> getChildren() {
        List<LocalInspectionToolWrapper> list = this.getConfigurations().stream().filter(configuration -> configuration.getOrder() == 0).map(configuration -> new StructuralSearchInspectionToolWrapper(this.getConfigurationsWithUuid(configuration.getUuid()))).collect(Collectors.toList());
        if (list == null) {
            SSBasedInspection.$$$reportNull$$$0(15);
        }
        return list;
    }

    private static LocalQuickFix createQuickFix(@NotNull Project project2, @NotNull MatchResult matchResult, @NotNull Configuration configuration) {
        if (project2 == null) {
            SSBasedInspection.$$$reportNull$$$0(16);
        }
        if (matchResult == null) {
            SSBasedInspection.$$$reportNull$$$0(17);
        }
        if (configuration == null) {
            SSBasedInspection.$$$reportNull$$$0(18);
        }
        if (!(configuration instanceof ReplaceConfiguration)) {
            return null;
        }
        return new StructuralQuickFix(project2, matchResult, configuration.getReplaceOptions());
    }

    @NotNull
    private Configuration getMainConfiguration(@NotNull Configuration configuration) {
        if (configuration == null) {
            SSBasedInspection.$$$reportNull$$$0(19);
        }
        if (configuration.getOrder() == 0) {
            Configuration configuration2 = configuration;
            if (configuration2 == null) {
                SSBasedInspection.$$$reportNull$$$0(20);
            }
            return configuration2;
        }
        String uuid = configuration.getUuid();
        Configuration configuration3 = this.myConfigurations.stream().filter(c -> c.getOrder() == 0 && uuid.equals(c.getUuid())).findFirst().orElse(configuration);
        if (configuration3 == null) {
            SSBasedInspection.$$$reportNull$$$0(21);
        }
        return configuration3;
    }

    @NotNull
    public List<Configuration> getConfigurations() {
        return new SmartList(this.myConfigurations);
    }

    @NotNull
    public List<Configuration> getConfigurationsWithUuid(@NotNull String uuid) {
        if (uuid == null) {
            SSBasedInspection.$$$reportNull$$$0(22);
        }
        List list = ContainerUtil.sorted((Collection)ContainerUtil.filter(this.myConfigurations, c -> uuid.equals(c.getUuid())), Comparator.comparingInt(Configuration::getOrder));
        if (list == null) {
            SSBasedInspection.$$$reportNull$$$0(23);
        }
        return list;
    }

    public boolean addConfiguration(@NotNull Configuration configuration) {
        if (configuration == null) {
            SSBasedInspection.$$$reportNull$$$0(24);
        }
        if (this.myConfigurations.contains(configuration)) {
            return false;
        }
        this.myConfigurations.add(configuration);
        this.myWriteSorted = true;
        return true;
    }

    public boolean addConfigurations(@NotNull Collection<? extends Configuration> configurations) {
        if (configurations == null) {
            SSBasedInspection.$$$reportNull$$$0(25);
        }
        boolean modified = false;
        for (Configuration configuration : configurations) {
            modified |= this.addConfiguration(configuration);
        }
        return modified;
    }

    public boolean removeConfiguration(@NotNull Configuration configuration) {
        boolean removed2;
        if (configuration == null) {
            SSBasedInspection.$$$reportNull$$$0(26);
        }
        if (removed2 = this.myConfigurations.remove(configuration)) {
            this.myWriteSorted = true;
        }
        return removed2;
    }

    public boolean removeConfigurationsWithUuid(@NotNull String uuid) {
        boolean removed2;
        if (uuid == null) {
            SSBasedInspection.$$$reportNull$$$0(27);
        }
        if (removed2 = this.myConfigurations.removeIf(c -> c.getUuid().equals(uuid))) {
            this.myWriteSorted = true;
        }
        return removed2;
    }

    public InspectionMetaDataDialog createMetaDataDialog(Project project2, @Nullable Configuration configuration) {
        List<Configuration> configurations = this.getConfigurations();
        Function<String, @Nullable @NlsContexts.DialogMessage String> nameValidator = name -> {
            for (Configuration current : configurations) {
                if (current.getOrder() != 0 || !current.getName().equals(name) || configuration != null && current.getUuid().equals(configuration.getUuid())) continue;
                return SSRBundle.message("inspection.with.name.exists.warning", name);
            }
            return null;
        };
        if (configuration == null) {
            return new InspectionMetaDataDialog(project2, nameValidator);
        }
        return new InspectionMetaDataDialog(project2, nameValidator, configuration.getName(), configuration.getDescription(), configuration.getProblemDescriptor(), configuration.getSuppressId());
    }

    private Map<Configuration, Matcher> checkOutCompiledPatterns(@NotNull List<? extends Configuration> configurations, @NotNull Project project2) {
        if (configurations == null) {
            SSBasedInspection.$$$reportNull$$$0(28);
        }
        if (project2 == null) {
            SSBasedInspection.$$$reportNull$$$0(29);
        }
        HashMap<Configuration, Matcher> result2 = new HashMap<Configuration, Matcher>();
        for (Configuration configuration : configurations) {
            Matcher matcher = this.myCompiledPatterns.popValue(configuration);
            if (matcher == Matcher.EMPTY) continue;
            if (matcher != null) {
                result2.put(configuration, matcher);
                continue;
            }
            Matcher newMatcher = SSBasedInspection.buildCompiledConfiguration(configuration, project2);
            if (newMatcher != null) {
                MatchContext context = newMatcher.getMatchContext();
                context.setSink(new InspectionResultSink());
                context.setShouldRecursivelyMatch(false);
            }
            result2.put(configuration, newMatcher);
        }
        return result2;
    }

    private static Matcher buildCompiledConfiguration(Configuration configuration, @NotNull Project project2) {
        if (project2 == null) {
            SSBasedInspection.$$$reportNull$$$0(30);
        }
        try {
            MatchOptions matchOptions = configuration.getMatchOptions();
            CompiledPattern compiledPattern = PatternCompiler.compilePattern(project2, matchOptions, false, true);
            return compiledPattern == null ? null : new Matcher(project2, matchOptions, compiledPattern);
        }
        catch (StructuralSearchException e) {
            LOG.warn("Malformed structural search inspection pattern \"" + configuration.getName() + "\"", (Throwable)e);
            return null;
        }
    }

    private void checkInCompiledPatterns(@NotNull Map<Configuration, Matcher> compiledPatterns) {
        if (compiledPatterns == null) {
            SSBasedInspection.$$$reportNull$$$0(31);
        }
        for (Map.Entry<Configuration, Matcher> entry2 : compiledPatterns.entrySet()) {
            Configuration configuration = entry2.getKey();
            Matcher matcher = entry2.getValue();
            if (matcher == null) {
                this.myCompiledPatterns.putValue(configuration, Matcher.EMPTY);
                continue;
            }
            matcher.getMatchContext().getSink().matchingFinished();
            this.myCompiledPatterns.putValue(configuration, matcher);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 9, 10, 11, 15, 20, 21, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 20: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/inspection/SSBasedInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 16: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchResult";
                break;
            }
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uuid";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiledPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/inspection/SSBasedInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainConfiguration";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationsWithUuid";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 20: 
            case 21: 
            case 23: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cleanup";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "inspectionFinished";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isMetaDataChanged";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createQuickFix";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getMainConfiguration";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationsWithUuid";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addConfiguration";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addConfigurations";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "removeConfiguration";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "removeConfigurationsWithUuid";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "checkOutCompiledPatterns";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "buildCompiledConfiguration";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "checkInCompiledPatterns";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 9, 10, 11, 15, 20, 21, 23 -> new IllegalStateException(string2);
        };
    }

    private static class MultiMapEx<K, V>
    extends MultiMap<K, V> {
        MultiMapEx() {
            super(new ConcurrentHashMap());
        }

        @NotNull
        protected Collection<V> createCollection() {
            return new ConcurrentLinkedDeque();
        }

        public V popValue(K k) {
            Deque vs = (Deque)this.myMap.get(k);
            return vs == null ? null : (V)vs.pollLast();
        }
    }

    private class SSBasedVisitor
    extends PsiElementVisitor {
        private final Map<Configuration, Matcher> myCompiledOptions;
        private final InspectionProfileImpl myProfile;
        @NotNull
        private final ProblemsHolder myHolder;

        SSBasedVisitor(Map<Configuration, Matcher> compiledOptions, @NotNull InspectionProfileImpl profile, ProblemsHolder holder) {
            if (holder == null) {
                SSBasedVisitor.$$$reportNull$$$0(0);
            }
            this.myCompiledOptions = compiledOptions;
            this.myProfile = profile;
            this.myHolder = holder;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                SSBasedVisitor.$$$reportNull$$$0(1);
            }
            if (LexicalNodesFilter.getInstance().accepts(element)) {
                return;
            }
            for (Map.Entry<Configuration, Matcher> entry2 : this.myCompiledOptions.entrySet()) {
                MatchingStrategy strategy;
                Matcher matcher = entry2.getValue();
                if (matcher == null || !(strategy = matcher.getMatchContext().getPattern().getStrategy()).continueMatching(element)) continue;
                this.processElement(element, entry2.getKey(), matcher);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processElement(PsiElement element, Configuration configuration, Matcher matcher) {
            if (!this.myProfile.isToolEnabled(HighlightDisplayKey.find((String)configuration.getUuid()), element)) {
                return;
            }
            NodeIterator matchedNodes = SsrFilteringNodeIterator.create(element);
            if (!matcher.checkIfShouldAttemptToMatch(matchedNodes)) {
                return;
            }
            MatchContext matchContext = matcher.getMatchContext();
            InspectionResultSink sink = (InspectionResultSink)matchContext.getSink();
            sink.setConfigurationAndHolder(configuration, this.myHolder);
            int nodeCount = matchContext.getPattern().getNodeCount();
            try {
                matcher.processMatchesInElement(new CountingNodeIterator(nodeCount, matchedNodes));
            }
            catch (StructuralSearchException e) {
                if (SSBasedInspection.this.myProblemsReported.add(configuration.getName())) {
                    String message2 = e.getMessage().replace("a3cd264774bf4efb9ab609b250c5165c", "");
                    NotificationGroupManager.getInstance().getNotificationGroup("Structural Search").createNotification(SSRBundle.message("inspection.script.problem", message2, configuration.getName()), NotificationType.ERROR).setImportant(true).notify(element != null ? element.getProject() : null);
                }
            }
            finally {
                sink.resetConfigurationAndHolder();
                matchedNodes.reset();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/structuralsearch/inspection/SSBasedInspection$SSBasedVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class StructuralQuickFix
    implements LocalQuickFix {
        private final ReplacementInfo myReplacementInfo;
        private final Replacer myReplacer;
        private final ReplaceOptions myReplaceOptions;

        StructuralQuickFix(@NotNull Project project2, @NotNull MatchResult matchResult, @NotNull ReplaceOptions replaceOptions) {
            if (project2 == null) {
                StructuralQuickFix.$$$reportNull$$$0(0);
            }
            if (matchResult == null) {
                StructuralQuickFix.$$$reportNull$$$0(1);
            }
            if (replaceOptions == null) {
                StructuralQuickFix.$$$reportNull$$$0(2);
            }
            this.myReplaceOptions = replaceOptions;
            this.myReplacer = new Replacer(project2, replaceOptions);
            this.myReplacementInfo = this.myReplacer.buildReplacement(matchResult);
        }

        @NotNull
        public String getName() {
            String string2 = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myReplacementInfo.getReplacement()});
            if (string2 == null) {
                StructuralQuickFix.$$$reportNull$$$0(3);
            }
            return string2;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project2 == null) {
                StructuralQuickFix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                StructuralQuickFix.$$$reportNull$$$0(5);
            }
            if ((element = descriptor.getPsiElement()) != null) {
                this.myReplacer.replace(this.myReplacementInfo);
            }
        }

        @Nullable
        public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
            if (target == null) {
                StructuralQuickFix.$$$reportNull$$$0(6);
            }
            return new StructuralQuickFix(target.getProject(), new MatchResultForPreview(this.myReplacementInfo.getMatchResult(), target), this.myReplaceOptions);
        }

        @NotNull
        public String getFamilyName() {
            String string2 = SSRBundle.message("SSRInspection.family.name", new Object[0]);
            if (string2 == null) {
                StructuralQuickFix.$$$reportNull$$$0(7);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchResult";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replaceOptions";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/structuralsearch/inspection/SSBasedInspection$StructuralQuickFix";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/structuralsearch/inspection/SSBasedInspection$StructuralQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 7: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getFileModifierForPreview";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3, 7 -> new IllegalStateException(string2);
            };
        }
    }

    private final class InspectionResultSink
    extends DefaultMatchResultSink {
        private Configuration myConfiguration;
        private ProblemsHolder myHolder;
        private final Set<SmartPsiElementPointer<?>> duplicates = new HashSet();

        InspectionResultSink() {
        }

        void setConfigurationAndHolder(@NotNull Configuration configuration, @NotNull ProblemsHolder holder) {
            if (configuration == null) {
                InspectionResultSink.$$$reportNull$$$0(0);
            }
            if (holder == null) {
                InspectionResultSink.$$$reportNull$$$0(1);
            }
            this.myConfiguration = configuration;
            this.myHolder = holder;
        }

        void resetConfigurationAndHolder() {
            this.myConfiguration = null;
            this.myHolder = null;
        }

        @Override
        public void newMatch(@NotNull MatchResult result2) {
            if (result2 == null) {
                InspectionResultSink.$$$reportNull$$$0(2);
            }
            if (!this.duplicates.add(result2.getMatchRef())) {
                return;
            }
            this.registerProblem(result2, this.myConfiguration, this.myHolder);
        }

        private void registerProblem(MatchResult matchResult, Configuration configuration, ProblemsHolder holder) {
            PsiElement element = matchResult.getMatch();
            PsiFile containingFile = element.getContainingFile();
            PsiFile templateFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)containingFile);
            if (!element.isPhysical() || holder.getFile() != containingFile && holder.getFile() != templateFile) {
                return;
            }
            LocalQuickFix fix = SSBasedInspection.createQuickFix(element.getProject(), matchResult, configuration);
            Configuration mainConfiguration = SSBasedInspection.this.getMainConfiguration(configuration);
            String name = (String)ObjectUtils.notNull((Object)mainConfiguration.getProblemDescriptor(), (Object)mainConfiguration.getName());
            InspectionManager manager = holder.getManager();
            ProblemDescriptor descriptor = manager.createProblemDescriptor(element, name, fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, holder.isOnTheFly());
            String toolName = configuration.getUuid();
            holder.registerProblem((ProblemDescriptor)new ProblemDescriptorWithReporterName((ProblemDescriptorBase)descriptor, toolName));
        }

        @Override
        public void matchingFinished() {
            this.duplicates.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/structuralsearch/inspection/SSBasedInspection$InspectionResultSink";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setConfigurationAndHolder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "newMatch";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

