/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.data.index.VcsLogIndexUtils;
import com.intellij.vcs.log.data.index.VcsLogModifiableIndex;
import com.intellij.vcs.log.impl.VcsLogSharedSettings;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.actions.ResumeIndexingAction;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/log/ui/actions/ResumeIndexingAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getText", "", "repositories", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "update", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nResumeIndexingAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResumeIndexingAction.kt\ncom/intellij/vcs/log/ui/actions/ResumeIndexingAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n766#2:71\n857#2,2:72\n766#2:74\n857#2,2:75\n1549#2:77\n1620#2,3:78\n1549#2:81\n1620#2,3:82\n*S KotlinDebug\n*F\n+ 1 ResumeIndexingAction.kt\ncom/intellij/vcs/log/ui/actions/ResumeIndexingAction\n*L\n33#1:71\n33#1:72,2\n34#1:74\n34#1:75,2\n37#1:77\n37#1:78,3\n52#1:81\n52#1:82,3\n*E\n"})
public final class ResumeIndexingAction
extends DumbAwareAction {
    /*
     * WARNING - void declaration
     */
    public void update(@NotNull AnActionEvent e) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        VcsLogModifiableIndex index;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VcsLogData data2 = (VcsLogData)e.getData(VcsLogInternalDataKeys.LOG_DATA);
        Project project2 = e.getProject();
        VcsLogData vcsLogData = data2;
        VcsLogIndex vcsLogIndex = vcsLogData != null ? vcsLogData.getIndex() : null;
        VcsLogModifiableIndex vcsLogModifiableIndex = index = vcsLogIndex instanceof VcsLogModifiableIndex ? (VcsLogModifiableIndex)vcsLogIndex : null;
        if (data2 == null || project2 == null || !VcsLogSharedSettings.isIndexSwitchedOn(project2) || index == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Set<VirtualFile> set = index.getIndexingRoots();
        Intrinsics.checkNotNullExpressionValue(set, (String)"index.indexingRoots");
        Set<VirtualFile> rootsForIndexing = set;
        if (rootsForIndexing.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Iterable $this$filter$iv = rootsForIndexing;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            VcsLogIndex vcsLogIndex2 = data2.getIndex();
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogIndex2, (String)"data.index");
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!VcsLogIndexUtils.isScheduledForIndexing(vcsLogIndex2, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List scheduledForIndexing = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = rootsForIndexing;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!VcsLogIndexUtils.isBig(it)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List bigRepositories = (List)destination$iv$iv2;
        e.getPresentation().setEnabledAndVisible(!((Collection)bigRepositories).isEmpty() || !((Collection)scheduledForIndexing).isEmpty());
        $this$filterTo$iv$iv = rootsForIndexing;
        Project project3 = project2;
        boolean $i$f$map = false;
        void $i$f$filterTo22 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(data2.getLogProvider((VirtualFile)it));
        }
        String string2 = VcsLogUtil.getVcsDisplayName(project3, (List)destination$iv$iv3);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getVcsDisplayName(projec\u2026ata.getLogProvider(it) })");
        String vcsDisplayName = string2;
        if (!((Collection)scheduledForIndexing).isEmpty()) {
            Object[] objectArray = new Object[]{vcsDisplayName};
            e.getPresentation().setText(VcsLogBundle.message("action.title.pause.indexing", objectArray));
            objectArray = new Object[]{this.getText(scheduledForIndexing)};
            e.getPresentation().setDescription(VcsLogBundle.message("action.description.is.scheduled", objectArray));
            e.getPresentation().setIcon(AllIcons.Process.ProgressPauseSmall);
        } else {
            Object[] objectArray = new Object[]{vcsDisplayName};
            e.getPresentation().setText(VcsLogBundle.message("action.title.resume.indexing", objectArray));
            objectArray = new Object[]{this.getText(bigRepositories)};
            e.getPresentation().setDescription(VcsLogBundle.message("action.description.was.paused", objectArray));
            e.getPresentation().setIcon(AllIcons.Process.ProgressResumeSmall);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getText(List<? extends VirtualFile> repositories) {
        void $this$mapTo$iv$iv;
        int repositoriesLimit = 3;
        Iterable $this$map$iv = repositories;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        String result2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (int)repositoriesLimit), (CharSequence)", ", null, null, (int)0, null, (Function1)getText.result.2.INSTANCE, (int)30, null);
        if (repositories.size() > repositoriesLimit) {
            return result2 + ", ...";
        }
        return result2;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VcsLogUsageTriggerCollector.triggerUsage(e, (Object)this);
        VcsLogIndex vcsLogIndex = ((VcsLogData)e.getRequiredData(VcsLogInternalDataKeys.LOG_DATA)).getIndex();
        VcsLogModifiableIndex vcsLogModifiableIndex = vcsLogIndex instanceof VcsLogModifiableIndex ? (VcsLogModifiableIndex)vcsLogIndex : null;
        if (vcsLogModifiableIndex == null) {
            return;
        }
        VcsLogModifiableIndex index = vcsLogModifiableIndex;
        if (index.getIndexingRoots().isEmpty()) {
            return;
        }
        VcsLogIndexUtils.toggleIndexing(index);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }
}

