/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThreeState;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaInjectorBase;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaBasedLanguageInjector
extends JsonSchemaInjectorBase {
    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        if (registrar == null) {
            JsonSchemaBasedLanguageInjector.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JsonSchemaBasedLanguageInjector.$$$reportNull$$$0(1);
        }
        if (!(context instanceof JsonStringLiteral)) {
            return;
        }
        JsonSchemaInjectorBase.InjectedLanguageData language = JsonSchemaBasedLanguageInjector.getLanguageToInject(context, false);
        if (language == null) {
            return;
        }
        JsonSchemaBasedLanguageInjector.injectForHost(registrar, (JsonStringLiteral)context, language);
    }

    @Nullable
    public static JsonSchemaInjectorBase.InjectedLanguageData getLanguageToInject(@NotNull PsiElement context, boolean relaxPositionCheck) {
        if (context == null) {
            JsonSchemaBasedLanguageInjector.$$$reportNull$$$0(2);
        }
        Project project2 = context.getProject();
        PsiFile containingFile = context.getContainingFile();
        JsonSchemaObject schemaObject = JsonSchemaService.Impl.get(project2).getSchemaObject(containingFile);
        if (schemaObject == null) {
            return null;
        }
        JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(context, schemaObject);
        if (walker == null) {
            return null;
        }
        ThreeState isName = walker.isName(context);
        if (relaxPositionCheck && isName == ThreeState.YES || !relaxPositionCheck && isName != ThreeState.NO) {
            return null;
        }
        JsonPointerPosition position = walker.findPosition(context, true);
        if (position == null || position.isEmpty()) {
            return null;
        }
        Collection<JsonSchemaObject> schemas = new JsonSchemaResolver(project2, schemaObject, position).resolve();
        for (JsonSchemaObject schema : schemas) {
            Language language;
            String injection = schema.getLanguageInjection();
            if (injection == null || (language = Language.findLanguageByID((String)injection)) == null) continue;
            return new JsonSchemaInjectorBase.InjectedLanguageData(language, schema.getLanguageInjectionPrefix(), schema.getLanguageInjectionPostfix());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaBasedLanguageInjector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguagesToInject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguageToInject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

