/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.emojipicker.action;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TypingTarget;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Component;
import java.util.function.Consumer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.emojipicker.ui.EmojiPicker;
import org.jetbrains.plugins.emojipicker.ui.EmojiSearchField;

final class OpenEmojiPickerAction
extends DumbAwareAction {
    OpenEmojiPickerAction() {
    }

    private static Context getContext(AnActionEvent e, boolean findOnly) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor != null) {
            if (editor.isViewer()) {
                return null;
            }
            if (findOnly) {
                return Context.FOUND;
            }
            Consumer<String> input = editor instanceof EditorImpl ? arg_0 -> ((EditorImpl)((EditorImpl)editor)).type(arg_0) : (editor.getContentComponent() instanceof TypingTarget ? arg_0 -> ((TypingTarget)((TypingTarget)editor.getContentComponent())).type(arg_0) : s -> WriteCommandAction.writeCommandAction((Project)editor.getProject()).run(() -> {
                com.intellij.openapi.editor.Document doc = editor.getDocument();
                editor.getCaretModel().runForEachCaret(c -> {
                    doc.insertString(c.getOffset(), (CharSequence)s);
                    c.moveCaretRelatively(1, 0, false, false);
                });
            }));
            return new Context(input, p -> p.showInBestPositionFor(editor));
        }
        Component component = (Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        if (component instanceof EmojiSearchField) {
            return null;
        }
        if (component instanceof TypingTarget) {
            if (findOnly) {
                return Context.FOUND;
            }
            return new Context(arg_0 -> ((TypingTarget)((TypingTarget)component)).type(arg_0), p -> p.showUnderneathOf(component));
        }
        if (component instanceof JTextComponent) {
            JTextComponent field = (JTextComponent)component;
            if (findOnly) {
                return Context.FOUND;
            }
            Document doc = field.getDocument();
            return new Context(s -> {
                try {
                    doc.insertString(field.getCaretPosition(), (String)s, null);
                }
                catch (BadLocationException exception) {
                    throw new RuntimeException(exception);
                }
            }, p -> p.showUnderneathOf(component));
        }
        return null;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            OpenEmojiPickerAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenEmojiPickerAction.$$$reportNull$$$0(1);
        }
        boolean enabled = SystemInfo.isLinux && EmojiPicker.isAvailable() && OpenEmojiPickerAction.getContext(e, true) == Context.FOUND;
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Context context;
        if (e == null) {
            OpenEmojiPickerAction.$$$reportNull$$$0(2);
        }
        if ((context = OpenEmojiPickerAction.getContext(e, false)) != null) {
            JBPopup popup = EmojiPicker.createPopup(e.getProject(), context.myInputCallback);
            context.myPopupShowCallback.accept(popup);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/emojipicker/action/OpenEmojiPickerAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/emojipicker/action/OpenEmojiPickerAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static final class Context {
        private static final Context FOUND = new Context(null, null);
        private final Consumer<String> myInputCallback;
        private final Consumer<JBPopup> myPopupShowCallback;

        private Context(Consumer<String> inputCallback, Consumer<JBPopup> popupShowCallback) {
            this.myInputCallback = inputCallback;
            this.myPopupShowCallback = popupShowCallback;
        }
    }
}

