/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.targets;

import com.intellij.analysis.AnalysisScope;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.staticAnalysis.inspections.targets.TestTarget;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0016R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/targets/MultiScopeTestTarget;", "Lorg/jetbrains/qodana/staticAnalysis/inspections/targets/TestTarget;", "name", "", "tools", "", "Lcom/intellij/analysis/AnalysisScope;", "threshold", "", "macroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "(Ljava/lang/String;Ljava/util/Map;ILcom/intellij/openapi/components/PathMacroManager;)V", "inspections", "", "getInspections", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "getThreshold", "()I", "contains", "", "inspection", "url", "intellij.qodana"})
public final class MultiScopeTestTarget
implements TestTarget {
    @NotNull
    private final String name;
    @NotNull
    private final Map<String, AnalysisScope> tools;
    private final int threshold;
    @NotNull
    private final PathMacroManager macroManager;
    @NotNull
    private final List<String> inspections;

    public MultiScopeTestTarget(@NotNull String name, @NotNull Map<String, ? extends AnalysisScope> tools, int threshold, @NotNull PathMacroManager macroManager) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(tools, (String)"tools");
        Intrinsics.checkNotNullParameter((Object)macroManager, (String)"macroManager");
        this.name = name;
        this.tools = tools;
        this.threshold = threshold;
        this.macroManager = macroManager;
        this.inspections = CollectionsKt.toList((Iterable)this.tools.keySet());
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    @Override
    @NotNull
    public List<String> getInspections() {
        return this.inspections;
    }

    @Override
    public boolean contains(@NotNull String inspection, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)inspection, (String)"inspection");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        VirtualFile virtualFile2 = VirtualFileManager.getInstance().findFileByUrl(this.macroManager.expandPath(url));
        if (virtualFile2 == null) {
            return false;
        }
        VirtualFile virtualFile3 = virtualFile2;
        AnalysisScope analysisScope2 = this.tools.get(inspection);
        if (analysisScope2 == null) {
            return false;
        }
        AnalysisScope scope = analysisScope2;
        return scope.contains(virtualFile3);
    }
}

