/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.ReflectionUtilRt;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.ParseException;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.interpolation.StringSearchModelInterpolator;
import org.apache.maven.model.path.PathTranslator;
import org.apache.maven.model.path.UrlNormalizer;
import org.apache.maven.model.profile.DefaultProfileInjector;
import org.apache.maven.model.validation.ModelValidator;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.PluginDescriptorCache;
import org.apache.maven.plugin.internal.PluginDependenciesResolver;
import org.apache.maven.profiles.activation.JdkPrefixProfileActivator;
import org.apache.maven.profiles.activation.OperatingSystemProfileActivator;
import org.apache.maven.profiles.activation.ProfileActivator;
import org.apache.maven.profiles.activation.SystemPropertyProfileActivator;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DefaultProjectBuilderConfiguration;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.project.inheritance.DefaultModelInheritanceAssembler;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.project.interpolation.ModelInterpolator;
import org.apache.maven.project.path.DefaultPathTranslator;
import org.apache.maven.project.validation.ModelValidationResult;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeResolutionListener;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.context.DefaultContext;
import org.codehaus.plexus.logging.BaseLoggerManager;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.server.LongRunningTask;
import org.jetbrains.idea.maven.server.Maven30AetherModelConverter;
import org.jetbrains.idea.maven.server.Maven30TransferListenerAdapter;
import org.jetbrains.idea.maven.server.Maven30WorkspaceReader;
import org.jetbrains.idea.maven.server.Maven3EffectivePomDumper;
import org.jetbrains.idea.maven.server.Maven3ModelConverter;
import org.jetbrains.idea.maven.server.Maven3ServerConsoleLogger;
import org.jetbrains.idea.maven.server.Maven3ServerEmbedder;
import org.jetbrains.idea.maven.server.MavenArtifactResolutionRequest;
import org.jetbrains.idea.maven.server.MavenArtifactResolveResult;
import org.jetbrains.idea.maven.server.MavenConfigParseException;
import org.jetbrains.idea.maven.server.MavenGoalExecutionRequest;
import org.jetbrains.idea.maven.server.MavenGoalExecutionResult;
import org.jetbrains.idea.maven.server.MavenLeakDetector;
import org.jetbrains.idea.maven.server.MavenServerConfigUtil;
import org.jetbrains.idea.maven.server.MavenServerConsoleIndicatorWrapper;
import org.jetbrains.idea.maven.server.MavenServerExecutionResult;
import org.jetbrains.idea.maven.server.MavenServerGlobals;
import org.jetbrains.idea.maven.server.MavenServerSettings;
import org.jetbrains.idea.maven.server.MavenServerUtil;
import org.jetbrains.idea.maven.server.MyFileProfileActivator;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.server.PluginResolutionRequest;
import org.jetbrains.idea.maven.server.PluginResolutionResponse;
import org.jetbrains.idea.maven.server.ProfileApplicationResult;
import org.jetbrains.idea.maven.server.ProjectResolutionRequest;
import org.jetbrains.idea.maven.server.RemoteNativeMaven3ProjectHolder;
import org.jetbrains.idea.maven.server.embedder.CustomMaven30ArtifactResolver;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3ArtifactFactory;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3ModelInterpolator;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3RepositoryMetadataManager;
import org.jetbrains.idea.maven.server.embedder.Maven3ExecutionResult;
import org.jetbrains.idea.maven.server.security.MavenToken;
import org.jetbrains.idea.maven.server.utils.Maven3SettingsBuilder;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyVisitor;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.repository.WorkspaceReader;
import org.sonatype.aether.transfer.TransferListener;
import org.sonatype.aether.util.DefaultRepositorySystemSession;
import org.sonatype.aether.util.graph.PreorderNodeListGenerator;

public class Maven30ServerEmbedderImpl
extends Maven3ServerEmbedder {
    @NotNull
    private final DefaultPlexusContainer myContainer;
    @NotNull
    private final Settings myMavenSettings;
    private final ArtifactRepository myLocalRepository;
    private final Maven3ServerConsoleLogger myConsoleWrapper;
    private final Properties mySystemProperties;
    private final boolean myAlwaysUpdateSnapshots;
    @NotNull
    private final RepositorySystem myRepositorySystem;

    public Maven30ServerEmbedderImpl(MavenServerSettings settings) {
        super(settings);
        Object cliRequest;
        Class<?> cliRequestClass;
        String mavenHomePath = settings.getMavenHomePath();
        if (mavenHomePath != null) {
            System.setProperty("maven.home", mavenHomePath);
        }
        this.myConsoleWrapper = new Maven3ServerConsoleLogger();
        this.myConsoleWrapper.setThreshold(settings.getLoggingLevel());
        ClassWorld classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
        MavenCli cli = new MavenCli(classWorld){

            protected void customizeContainer(PlexusContainer container) {
                ((DefaultPlexusContainer)container).setLoggerManager((LoggerManager)new BaseLoggerManager(){

                    protected Logger createLogger(String s) {
                        return Maven30ServerEmbedderImpl.this.myConsoleWrapper;
                    }
                });
            }
        };
        try {
            cliRequestClass = MavenCli.class.getClassLoader().loadClass("org.apache.maven.cli.MavenCli$CliRequest");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class \"org.apache.maven.cli.MavenCli$CliRequest\" not found");
        }
        try {
            ArrayList<String> commandLineOptions = new ArrayList<String>(settings.getUserProperties().size());
            for (Map.Entry<Object, Object> each : settings.getUserProperties().entrySet()) {
                commandLineOptions.add("-D" + each.getKey() + "=" + each.getValue());
            }
            if (settings.getLoggingLevel() == 0) {
                commandLineOptions.add("-X");
                commandLineOptions.add("-e");
            } else if (settings.getLoggingLevel() == 5) {
                commandLineOptions.add("-q");
            }
            String mavenEmbedderCliOptions = System.getProperty("idea.maven.embedder.ext.cli.args");
            if (mavenEmbedderCliOptions != null) {
                commandLineOptions.addAll(StringUtilRt.splitHonorQuotes((String)mavenEmbedderCliOptions, (char)' '));
            }
            this.myAlwaysUpdateSnapshots = commandLineOptions.contains("-U") || commandLineOptions.contains("--update-snapshots");
            Constructor<?> constructor = cliRequestClass.getDeclaredConstructor(String[].class, ClassWorld.class);
            constructor.setAccessible(true);
            cliRequest = constructor.newInstance(commandLineOptions.toArray(new String[0]), classWorld);
            for (String each : new String[]{"initialize", "cli", "logging", "properties", "container"}) {
                Method m = MavenCli.class.getDeclaredMethod(each, cliRequestClass);
                m.setAccessible(true);
                m.invoke((Object)cli, cliRequest);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            ParseException cause = (ParseException)ExceptionUtilRt.findCause((Throwable)e, ParseException.class);
            if (cause != null) {
                String workingDir = System.getProperty("user.dir");
                throw new MavenConfigParseException(cause.getMessage(), workingDir);
            }
            throw new RuntimeException(e);
        }
        this.myContainer = (DefaultPlexusContainer)ReflectionUtilRt.getField(MavenCli.class, (Object)cli, DefaultPlexusContainer.class, (String)"container");
        this.myContainer.getLoggerManager().setThreshold(settings.getLoggingLevel());
        this.mySystemProperties = (Properties)ReflectionUtilRt.getField(cliRequestClass, cliRequest, Properties.class, (String)"systemProperties");
        if (settings.getProjectJdk() != null) {
            this.mySystemProperties.setProperty("java.home", settings.getProjectJdk());
        }
        this.myMavenSettings = Maven3SettingsBuilder.buildSettings((SettingsBuilder)((SettingsBuilder)ReflectionUtilRt.getField(MavenCli.class, (Object)cli, SettingsBuilder.class, (String)"settingsBuilder")), (MavenServerSettings)settings, (Properties)this.mySystemProperties, (Properties)((Properties)ReflectionUtilRt.getField(cliRequestClass, cliRequest, Properties.class, (String)"userProperties")));
        this.myLocalRepository = this.createLocalRepository();
        this.myRepositorySystem = this.getComponent(RepositorySystem.class);
    }

    @NotNull
    protected PlexusContainer getContainer() {
        DefaultPlexusContainer defaultPlexusContainer = this.myContainer;
        if (defaultPlexusContainer == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(0);
        }
        return defaultPlexusContainer;
    }

    private static Maven3ExecutionResult handleException(Throwable e) {
        if (e instanceof Error) {
            throw (Error)e;
        }
        return new Maven3ExecutionResult(Collections.singletonList((Exception)e));
    }

    private static Collection<String> collectActivatedProfiles(MavenProject mavenProject) {
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        try {
            while (mavenProject != null) {
                profiles.addAll(mavenProject.getActiveProfiles());
                mavenProject = mavenProject.getParent();
            }
        }
        catch (Exception e) {
            MavenServerGlobals.getLogger().info((Throwable)e);
        }
        return Maven30ServerEmbedderImpl.collectProfilesIds(profiles);
    }

    private static List<Exception> filterExceptions(List<Throwable> list) {
        for (Throwable throwable : list) {
            if (throwable instanceof Exception) continue;
            throw new RuntimeException(throwable);
        }
        return list;
    }

    @NotNull
    public static MavenModel interpolateAndAlignModel(MavenModel model, File basedir) {
        Model result = Maven3ModelConverter.toNativeModel((MavenModel)model);
        result = Maven30ServerEmbedderImpl.doInterpolate(result, basedir);
        DefaultPathTranslator pathTranslator = new DefaultPathTranslator();
        pathTranslator.alignToBaseDirectory(result, basedir);
        MavenModel mavenModel = Maven3ModelConverter.convertModel((Model)result, null);
        if (mavenModel == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(1);
        }
        return mavenModel;
    }

    public static MavenModel assembleInheritance(MavenModel model, MavenModel parentModel) {
        Model result = Maven3ModelConverter.toNativeModel((MavenModel)model);
        new DefaultModelInheritanceAssembler().assembleModelInheritance(result, Maven3ModelConverter.toNativeModel((MavenModel)parentModel));
        return Maven3ModelConverter.convertModel((Model)result, null);
    }

    public static ProfileApplicationResult applyProfiles(MavenModel model, File basedir, MavenExplicitProfiles explicitProfiles, Collection<String> alwaysOnProfiles) {
        Model nativeModel = Maven3ModelConverter.toNativeModel((MavenModel)model);
        Collection enabledProfiles = explicitProfiles.getEnabledProfiles();
        Collection disabledProfiles = explicitProfiles.getDisabledProfiles();
        ArrayList<Profile> activatedPom = new ArrayList<Profile>();
        ArrayList<Profile> activatedExternal = new ArrayList<Profile>();
        ArrayList<Profile> activeByDefault = new ArrayList<Profile>();
        List rawProfiles = nativeModel.getProfiles();
        List expandedProfilesCache = null;
        ArrayList<Profile> deactivatedProfiles = new ArrayList<Profile>();
        for (int i = 0; i < rawProfiles.size(); ++i) {
            Profile eachRawProfile = (Profile)rawProfiles.get(i);
            if (disabledProfiles.contains(eachRawProfile.getId())) {
                deactivatedProfiles.add(eachRawProfile);
                continue;
            }
            boolean shouldAdd = enabledProfiles.contains(eachRawProfile.getId()) || alwaysOnProfiles.contains(eachRawProfile.getId());
            Activation activation = eachRawProfile.getActivation();
            if (activation != null) {
                if (activation.isActiveByDefault()) {
                    activeByDefault.add(eachRawProfile);
                }
                if (expandedProfilesCache == null) {
                    expandedProfilesCache = Maven30ServerEmbedderImpl.doInterpolate(nativeModel, basedir).getProfiles();
                }
                Profile eachExpandedProfile = (Profile)expandedProfilesCache.get(i);
                for (ProfileActivator eachActivator : Maven30ServerEmbedderImpl.getProfileActivators(basedir)) {
                    try {
                        if (!eachActivator.canDetermineActivation(eachExpandedProfile) || !eachActivator.isActive(eachExpandedProfile)) continue;
                        shouldAdd = true;
                        break;
                    }
                    catch (Exception e) {
                        MavenServerGlobals.getLogger().warn((Throwable)e);
                    }
                }
            }
            if (!shouldAdd) continue;
            if ("pom".equals(eachRawProfile.getSource())) {
                activatedPom.add(eachRawProfile);
                continue;
            }
            activatedExternal.add(eachRawProfile);
        }
        ArrayList<Profile> activatedProfiles = new ArrayList<Profile>(activatedPom.isEmpty() ? activeByDefault : activatedPom);
        activatedProfiles.addAll(activatedExternal);
        for (Profile each : activatedProfiles) {
            new DefaultProfileInjector().injectProfile(nativeModel, each, null, null);
        }
        return new ProfileApplicationResult(Maven3ModelConverter.convertModel((Model)nativeModel, null), new MavenExplicitProfiles(Maven30ServerEmbedderImpl.collectProfilesIds(activatedProfiles), Maven30ServerEmbedderImpl.collectProfilesIds(deactivatedProfiles)));
    }

    private static Model doInterpolate(Model result, File basedir) {
        try {
            CustomMaven3ModelInterpolator interpolator = new CustomMaven3ModelInterpolator(new DefaultPathTranslator());
            interpolator.initialize();
            Properties props = MavenServerUtil.collectSystemProperties();
            ProjectBuilderConfiguration config = new DefaultProjectBuilderConfiguration().setExecutionProperties(props);
            config.setBuildStartTime(new Date());
            Properties userProperties = new Properties();
            userProperties.putAll((Map<?, ?>)MavenServerConfigUtil.getMavenAndJvmConfigProperties((File)basedir));
            config.setUserProperties(userProperties);
            result = interpolator.interpolate(result, basedir, config, false);
        }
        catch (ModelInterpolationException e) {
            MavenServerGlobals.getLogger().warn((Throwable)e);
        }
        catch (InitializationException e) {
            MavenServerGlobals.getLogger().error((Throwable)e);
        }
        return result;
    }

    private static Collection<String> collectProfilesIds(List<Profile> profiles) {
        HashSet<String> result = new HashSet<String>();
        for (Profile each : profiles) {
            if (each.getId() == null) continue;
            result.add(each.getId());
        }
        return result;
    }

    private static ProfileActivator[] getProfileActivators(File basedir) {
        SystemPropertyProfileActivator sysPropertyActivator = new SystemPropertyProfileActivator();
        DefaultContext context = new DefaultContext();
        context.put((Object)"SystemProperties", (Object)MavenServerUtil.collectSystemProperties());
        try {
            sysPropertyActivator.contextualize((Context)context);
        }
        catch (ContextException e) {
            MavenServerGlobals.getLogger().error((Throwable)e);
            return new ProfileActivator[0];
        }
        return new ProfileActivator[]{new MyFileProfileActivator(basedir), sysPropertyActivator, new JdkPrefixProfileActivator(), new OperatingSystemProfileActivator()};
    }

    public <T> T getComponent(Class<T> clazz, String roleHint) {
        try {
            return (T)this.myContainer.lookup(clazz.getName(), roleHint);
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T getComponent(Class<T> clazz) {
        try {
            return (T)this.myContainer.lookup(clazz.getName());
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException(e);
        }
    }

    private ArtifactRepository createLocalRepository() {
        try {
            ArtifactRepository localRepository = this.getComponent(RepositorySystem.class).createLocalRepository(new File(this.myMavenSettings.getLocalRepository()));
            String customRepoId = System.getProperty("maven3.localRepository.id", "localIntelliJ");
            if (customRepoId != null) {
                localRepository.setId(customRepoId);
            }
            return localRepository;
        }
        catch (InvalidRepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    private void customizeComponents(@Nullable MavenWorkspaceMap workspaceMap) {
        try {
            ArtifactFactory artifactFactory;
            this.myContainer.addComponent((Object)this.getComponent(ArtifactFactory.class, "ide"), ArtifactFactory.ROLE);
            this.myContainer.addComponent((Object)this.getComponent(ArtifactResolver.class, "ide"), ArtifactResolver.ROLE);
            this.myContainer.addComponent((Object)this.getComponent(RepositoryMetadataManager.class, "ide"), RepositoryMetadataManager.class.getName());
            this.myContainer.addComponent((Object)this.getComponent(PluginDescriptorCache.class, "ide"), PluginDescriptorCache.class.getName());
            org.apache.maven.model.interpolation.ModelInterpolator modelInterpolator = this.getComponent(org.apache.maven.model.interpolation.ModelInterpolator.class, "ide");
            this.myContainer.addComponent((Object)modelInterpolator, org.apache.maven.model.interpolation.ModelInterpolator.class.getName());
            this.myContainer.addComponent((Object)this.getComponent(ModelInterpolator.class, "ide"), ModelInterpolator.ROLE);
            ModelValidator modelValidator = this.getComponent(ModelValidator.class, "ide");
            this.myContainer.addComponent((Object)modelValidator, ModelValidator.class.getName());
            DefaultModelBuilder defaultModelBuilder = (DefaultModelBuilder)this.getComponent(ModelBuilder.class);
            defaultModelBuilder.setModelValidator(modelValidator);
            defaultModelBuilder.setModelInterpolator(modelInterpolator);
            if (!"3.0.5".equals(this.getMavenVersion()) && modelInterpolator instanceof StringSearchModelInterpolator) {
                ((StringSearchModelInterpolator)modelInterpolator).setPathTranslator(this.getComponent(PathTranslator.class));
                ((StringSearchModelInterpolator)modelInterpolator).setUrlNormalizer(this.getComponent(UrlNormalizer.class));
            }
            if ((artifactFactory = this.getComponent(ArtifactFactory.class)) instanceof CustomMaven3ArtifactFactory) {
                ((CustomMaven3ArtifactFactory)artifactFactory).customize();
            }
            ((CustomMaven30ArtifactResolver)this.getComponent(ArtifactResolver.class)).customize(workspaceMap, false);
            ((CustomMaven3RepositoryMetadataManager)this.getComponent(RepositoryMetadataManager.class)).customize(workspaceMap);
        }
        catch (Exception e) {
            throw this.wrapToSerializableRuntimeException(e);
        }
    }

    private void resetComponents() {
        try {
            RepositoryMetadataManager repositoryMetadataManager;
            ArtifactResolver artifactResolver;
            ArtifactFactory artifactFactory = this.getComponent(ArtifactFactory.class);
            if (artifactFactory instanceof CustomMaven3ArtifactFactory) {
                ((CustomMaven3ArtifactFactory)artifactFactory).reset();
            }
            if ((artifactResolver = this.getComponent(ArtifactResolver.class)) instanceof CustomMaven30ArtifactResolver) {
                ((CustomMaven30ArtifactResolver)artifactResolver).reset();
            }
            if ((repositoryMetadataManager = this.getComponent(RepositoryMetadataManager.class)) instanceof CustomMaven3RepositoryMetadataManager) {
                ((CustomMaven3RepositoryMetadataManager)repositoryMetadataManager).reset();
            }
        }
        catch (Exception e) {
            throw this.wrapToSerializableRuntimeException(e);
        }
    }

    @Nullable
    public String evaluateEffectivePom(@NotNull File file, @NotNull List<String> activeProfiles, @NotNull List<String> inactiveProfiles, MavenToken token) {
        if (file == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(2);
        }
        if (activeProfiles == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(3);
        }
        if (inactiveProfiles == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(4);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        return Maven3EffectivePomDumper.evaluateEffectivePom((Maven3ServerEmbedder)this, (File)file, activeProfiles, inactiveProfiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWithMavenSession(MavenExecutionRequest request, Runnable runnable) {
        DefaultMaven maven = (DefaultMaven)this.getComponent(Maven.class);
        RepositorySystemSession repositorySession = maven.newRepositorySession(request);
        request.getProjectBuildingRequest().setRepositorySession(repositorySession);
        MavenSession mavenSession = new MavenSession((PlexusContainer)this.myContainer, repositorySession, request, (MavenExecutionResult)new DefaultMavenExecutionResult());
        LegacySupport legacySupport = this.getComponent(LegacySupport.class);
        MavenSession oldSession = legacySupport.getSession();
        legacySupport.setSession(mavenSession);
        try {
            for (AbstractMavenLifecycleParticipant listener : this.getLifecycleParticipants(Collections.emptyList())) {
                listener.afterSessionStart(mavenSession);
            }
        }
        catch (MavenExecutionException e) {
            throw new RuntimeException(e);
        }
        try {
            runnable.run();
        }
        finally {
            legacySupport.setSession(oldSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    public Collection<MavenServerExecutionResult> resolveProjects(@NotNull String longRunningTaskId, @NotNull ProjectResolutionRequest request, MavenToken token) {
        if (longRunningTaskId == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(5);
        }
        if (request == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(6);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        List files = request.getPomFiles();
        List activeProfiles = request.getActiveProfiles();
        List inactiveProfiles = request.getInactiveProfiles();
        MavenWorkspaceMap workspaceMap = request.getWorkspaceMap();
        boolean updateSnapshots = this.myAlwaysUpdateSnapshots || request.updateSnapshots();
        LongRunningTask task = this.newLongRunningTask(longRunningTaskId, files.size(), (MavenServerConsoleIndicatorWrapper)this.myConsoleWrapper);
        this.customizeComponents(workspaceMap);
        Collection<MavenServerExecutionResult> collection = this.resolveProjects(task, files, activeProfiles, inactiveProfiles, workspaceMap, updateSnapshots);
        this.resetComponents();
        Collection<MavenServerExecutionResult> collection2 = collection;
        if (collection2 == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(7);
        }
        return collection2;
        {
            catch (Throwable throwable) {
                this.resetComponents();
                throw throwable;
            }
        }
        finally {
            if (task != null) {
                task.close();
            }
        }
    }

    @NotNull
    private Collection<MavenServerExecutionResult> resolveProjects(@NotNull LongRunningTask task, @NotNull Collection<File> files, @NotNull List<String> activeProfiles, @NotNull List<String> inactiveProfiles, @Nullable MavenWorkspaceMap workspaceMap, boolean updateSnapshots) {
        if (task == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(8);
        }
        if (files == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(9);
        }
        if (activeProfiles == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(10);
        }
        if (inactiveProfiles == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(11);
        }
        DependencyTreeResolutionListener listener = new DependencyTreeResolutionListener((Logger)this.myConsoleWrapper);
        Collection<Maven3ExecutionResult> results = this.doResolveProject(task, files, activeProfiles, inactiveProfiles, Collections.singletonList(listener), workspaceMap, updateSnapshots);
        List list = ContainerUtilRt.map2List(results, result -> this.createExecutionResult(result.getPomFile(), (Maven3ExecutionResult)result, listener.getRootNode()));
        if (list == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    private Collection<Maven3ExecutionResult> doResolveProject(@NotNull LongRunningTask task, @NotNull Collection<File> files, @NotNull List<String> activeProfiles, @NotNull List<String> inactiveProfiles, List<ResolutionListener> listeners, @Nullable MavenWorkspaceMap workspaceMap, boolean updateSnapshots) {
        if (task == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(13);
        }
        if (files == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(14);
        }
        if (activeProfiles == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(15);
        }
        if (inactiveProfiles == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(16);
        }
        File file = files.size() == 1 ? files.iterator().next() : null;
        MavenExecutionRequest request = this.createRequest(file, activeProfiles, inactiveProfiles);
        request.setUpdateSnapshots(updateSnapshots);
        ArrayList<Maven3ExecutionResult> executionResults = new ArrayList<Maven3ExecutionResult>();
        this.executeWithMavenSession(request, () -> {
            try {
                RepositorySystemSession repositorySession = this.getComponent(LegacySupport.class).getRepositorySession();
                if (repositorySession instanceof DefaultRepositorySystemSession) {
                    ((DefaultRepositorySystemSession)repositorySession).setTransferListener((TransferListener)new Maven30TransferListenerAdapter(task.getIndicator()));
                    if (workspaceMap != null) {
                        ((DefaultRepositorySystemSession)repositorySession).setWorkspaceReader((WorkspaceReader)new Maven30WorkspaceReader(workspaceMap));
                    }
                }
                List buildingResults = this.getProjectBuildingResults(request, files);
                task.updateTotalRequests(buildingResults.size());
                for (ProjectBuildingResult buildingResult : buildingResults) {
                    if (!task.isCanceled()) {
                        ArrayList<Exception> exceptions;
                        MavenProject project = buildingResult.getProject();
                        if (project == null) {
                            exceptions = new ArrayList<Exception>();
                            for (ModelProblem problem : buildingResult.getProblems()) {
                                exceptions.add(problem.getException());
                            }
                            Maven3ExecutionResult mavenExecutionResult = new Maven3ExecutionResult(buildingResult.getPomFile(), exceptions);
                            executionResults.add(mavenExecutionResult);
                            continue;
                        }
                        exceptions = new ArrayList();
                        this.loadExtensions(project, exceptions);
                        project.setDependencyArtifacts(project.createArtifacts(this.getComponent(ArtifactFactory.class), null, null));
                        if (USE_MVN2_COMPATIBLE_DEPENDENCY_RESOLVING) {
                            this.addMvn2CompatResults(project, exceptions, listeners, this.myLocalRepository, executionResults);
                        } else {
                            DependencyResolutionResult dependencyResolutionResult = this.resolveDependencies(project, repositorySession);
                            List dependencies = dependencyResolutionResult.getDependencies();
                            LinkedHashSet<org.apache.maven.artifact.Artifact> artifacts = new LinkedHashSet<org.apache.maven.artifact.Artifact>(dependencies.size());
                            for (Dependency dependency : dependencies) {
                                org.apache.maven.artifact.Artifact artifact = RepositoryUtils.toArtifact((Artifact)dependency.getArtifact());
                                artifact.setScope(dependency.getScope());
                                artifact.setOptional(dependency.isOptional());
                                artifacts.add(artifact);
                                this.resolveAsModule(artifact, workspaceMap);
                            }
                            project.setArtifacts(artifacts);
                            executionResults.add(new Maven3ExecutionResult(project, dependencyResolutionResult, exceptions, buildingResult.getProblems()));
                        }
                        task.incrementFinishedRequests();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                executionResults.add(Maven30ServerEmbedderImpl.handleException(e));
            }
        });
        ArrayList<Maven3ExecutionResult> arrayList = executionResults;
        if (arrayList == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    private boolean resolveAsModule(org.apache.maven.artifact.Artifact a, @Nullable MavenWorkspaceMap workspaceMap) {
        if (workspaceMap == null) {
            return false;
        }
        MavenWorkspaceMap.Data resolved = workspaceMap.findFileAndOriginalId(Maven3ModelConverter.createMavenId((org.apache.maven.artifact.Artifact)a));
        if (resolved == null) {
            return false;
        }
        a.setResolved(true);
        a.setFile(resolved.getFile(a.getType()));
        a.selectVersion(resolved.originalId.getVersion());
        return true;
    }

    private DependencyResolutionResult resolveDependencies(MavenProject project, RepositorySystemSession session) {
        DependencyResolutionResult resolutionResult;
        try {
            ProjectDependenciesResolver dependencyResolver = this.getComponent(ProjectDependenciesResolver.class);
            DefaultDependencyResolutionRequest resolution = new DefaultDependencyResolutionRequest(project, session);
            resolutionResult = dependencyResolver.resolve((DependencyResolutionRequest)resolution);
        }
        catch (DependencyResolutionException e) {
            resolutionResult = e.getResult();
        }
        LinkedHashSet artifacts = new LinkedHashSet();
        if (resolutionResult.getDependencyGraph() != null) {
            RepositoryUtils.toArtifacts(artifacts, (Collection)resolutionResult.getDependencyGraph().getChildren(), Collections.singletonList(project.getArtifact().getId()), null);
            LocalRepositoryManager lrm = session.getLocalRepositoryManager();
            for (org.apache.maven.artifact.Artifact artifact : artifacts) {
                if (artifact.isResolved()) continue;
                String path = lrm.getPathForLocalArtifact(RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)artifact));
                artifact.setFile(new File(lrm.getRepository().getBasedir(), path));
            }
        }
        project.setResolvedArtifacts(artifacts);
        project.setArtifacts(artifacts);
        return resolutionResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExtensions(MavenProject project, List<Exception> exceptions) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Collection<AbstractMavenLifecycleParticipant> lifecycleParticipants = this.getLifecycleParticipants(Collections.singletonList(project));
        if (!lifecycleParticipants.isEmpty()) {
            LegacySupport legacySupport = this.getComponent(LegacySupport.class);
            MavenSession session = legacySupport.getSession();
            session.setCurrentProject(project);
            session.setProjects(Collections.singletonList(project));
            for (AbstractMavenLifecycleParticipant listener : lifecycleParticipants) {
                Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
                try {
                    listener.afterProjectsRead(session);
                }
                catch (MavenExecutionException e) {
                    exceptions.add((Exception)((Object)e));
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalClassLoader);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<AbstractMavenLifecycleParticipant> getLifecycleParticipants(Collection<MavenProject> projects) {
        LinkedHashSet<AbstractMavenLifecycleParticipant> lifecycleListeners = new LinkedHashSet<AbstractMavenLifecycleParticipant>();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                lifecycleListeners.addAll(this.myContainer.lookupList(AbstractMavenLifecycleParticipant.class));
            }
            catch (ComponentLookupException e) {
                Maven30ServerEmbedderImpl.warn((String)"Failed to lookup lifecycle participants", (Throwable)e);
            }
            HashSet<ClassRealm> scannedRealms = new HashSet<ClassRealm>();
            for (MavenProject project : projects) {
                ClassRealm projectRealm = project.getClassRealm();
                if (projectRealm == null || !scannedRealms.add(projectRealm)) continue;
                Thread.currentThread().setContextClassLoader((ClassLoader)projectRealm);
                try {
                    lifecycleListeners.addAll(this.myContainer.lookupList(AbstractMavenLifecycleParticipant.class));
                }
                catch (ComponentLookupException e) {
                    Maven30ServerEmbedderImpl.warn((String)"Failed to lookup lifecycle participants", (Throwable)e);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return lifecycleListeners;
    }

    public MavenExecutionRequest createRequest(@Nullable File file, @Nullable List<String> activeProfiles, @Nullable List<String> inactiveProfiles) {
        DefaultMavenExecutionRequest result = new DefaultMavenExecutionRequest();
        try {
            this.getComponent(MavenExecutionRequestPopulator.class).populateFromSettings((MavenExecutionRequest)result, this.myMavenSettings);
            result.setPom(file);
            this.getComponent(MavenExecutionRequestPopulator.class).populateDefaults((MavenExecutionRequest)result);
            result.setSystemProperties(this.mySystemProperties);
            Properties userProperties = new Properties();
            if (file != null) {
                userProperties.putAll((Map<?, ?>)MavenServerConfigUtil.getMavenAndJvmConfigProperties((File)file.getParentFile()));
            }
            result.setUserProperties(userProperties);
            if (activeProfiles != null) {
                result.setActiveProfiles(activeProfiles);
            }
            if (inactiveProfiles != null) {
                result.setInactiveProfiles(inactiveProfiles);
            }
            result.setCacheNotFound(true);
            result.setCacheTransferError(true);
            result.setStartTime(new Date());
            return result;
        }
        catch (MavenExecutionRequestPopulationException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public File getLocalRepositoryFile() {
        return new File(this.myLocalRepository.getBasedir());
    }

    @NotNull
    private MavenServerExecutionResult createExecutionResult(@Nullable File file, Maven3ExecutionResult result, DependencyNode rootNode) {
        Collection problems = MavenProjectProblem.createProblemsList();
        HashSet unresolvedArtifacts = new HashSet();
        this.collectProblems(file, result.getExceptions(), problems);
        MavenProject mavenProject = result.getMavenProject();
        if (mavenProject == null) {
            return new MavenServerExecutionResult(null, problems, unresolvedArtifacts);
        }
        MavenModel model = new MavenModel();
        try {
            if (USE_MVN2_COMPATIBLE_DEPENDENCY_RESOLVING) {
                List dependencyNodes = rootNode == null ? Collections.emptyList() : rootNode.getChildren();
                model = Maven3ModelConverter.convertModel((Model)mavenProject.getModel(), (List)mavenProject.getCompileSourceRoots(), (List)mavenProject.getTestCompileSourceRoots(), (Collection)mavenProject.getArtifacts(), (Collection)dependencyNodes, (Collection)mavenProject.getExtensionArtifacts(), (File)this.getLocalRepositoryFile());
            } else {
                DependencyResolutionResult dependencyResolutionResult = result.getDependencyResolutionResult();
                org.sonatype.aether.graph.DependencyNode dependencyGraph = dependencyResolutionResult != null ? dependencyResolutionResult.getDependencyGraph() : null;
                List dependencyNodes = dependencyGraph != null ? dependencyGraph.getChildren() : Collections.emptyList();
                model = Maven30AetherModelConverter.convertModelWithAetherDependencyTree(mavenProject.getModel(), mavenProject.getCompileSourceRoots(), mavenProject.getTestCompileSourceRoots(), mavenProject.getArtifacts(), dependencyNodes, mavenProject.getExtensionArtifacts(), this.getLocalRepositoryFile());
            }
        }
        catch (Exception e) {
            this.collectProblems(mavenProject.getFile(), Collections.singleton(e), problems);
        }
        RemoteNativeMaven3ProjectHolder holder = new RemoteNativeMaven3ProjectHolder(mavenProject);
        try {
            UnicastRemoteObject.exportObject((Remote)holder, 0);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        Collection<String> activatedProfiles = Maven30ServerEmbedderImpl.collectActivatedProfiles(mavenProject);
        MavenServerExecutionResult.ProjectData data = new MavenServerExecutionResult.ProjectData(model, Maven3ModelConverter.convertToMap((Object)mavenProject.getModel()), (NativeMavenProjectHolder)holder, activatedProfiles);
        return new MavenServerExecutionResult(data, problems, unresolvedArtifacts);
    }

    @NotNull
    private MavenGoalExecutionResult createEmbedderExecutionResult(@NotNull File file, Maven3ExecutionResult result) {
        if (file == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(18);
        }
        Collection problems = MavenProjectProblem.createProblemsList();
        this.collectProblems(file, result.getExceptions(), problems);
        MavenGoalExecutionResult.Folders folders = new MavenGoalExecutionResult.Folders();
        MavenProject mavenProject = result.getMavenProject();
        if (mavenProject == null) {
            return new MavenGoalExecutionResult(false, file, folders, problems);
        }
        folders.setSources(mavenProject.getCompileSourceRoots());
        folders.setTestSources(mavenProject.getTestCompileSourceRoots());
        folders.setResources(Maven3ModelConverter.convertResources((List)mavenProject.getModel().getBuild().getResources()));
        folders.setTestResources(Maven3ModelConverter.convertResources((List)mavenProject.getModel().getBuild().getTestResources()));
        return new MavenGoalExecutionResult(true, file, folders, problems);
    }

    /*
     * WARNING - void declaration
     */
    private void collectProblems(@Nullable File file, @NotNull Collection<Exception> exceptions, @NotNull Collection<MavenProjectProblem> problems) {
        if (exceptions == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(19);
        }
        if (problems == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(20);
        }
        for (Throwable throwable : exceptions) {
            void var5_5;
            String path;
            if (throwable == null) continue;
            MavenServerGlobals.getLogger().info(throwable);
            if (throwable instanceof IllegalStateException && throwable.getCause() != null) {
                Throwable throwable2 = throwable.getCause();
            }
            String string = path = file == null ? "" : file.getPath();
            if (path.isEmpty() && var5_5 instanceof ProjectBuildingException) {
                File pomFile = ((ProjectBuildingException)var5_5).getPomFile();
                String string2 = path = pomFile == null ? "" : pomFile.getPath();
            }
            if (var5_5 instanceof InvalidProjectModelException) {
                ModelValidationResult modelValidationResult = ((InvalidProjectModelException)var5_5).getValidationResult();
                if (modelValidationResult != null) {
                    for (String eachValidationProblem : modelValidationResult.getMessages()) {
                        problems.add(MavenProjectProblem.createStructureProblem((String)path, (String)eachValidationProblem));
                    }
                    continue;
                }
                problems.add(MavenProjectProblem.createStructureProblem((String)path, (String)var5_5.getCause().getMessage()));
                continue;
            }
            if (var5_5 instanceof ProjectBuildingException) {
                String causeMessage = var5_5.getCause() != null ? var5_5.getCause().getMessage() : var5_5.getMessage();
                problems.add(MavenProjectProblem.createStructureProblem((String)path, (String)causeMessage));
                continue;
            }
            problems.add(MavenProjectProblem.createStructureProblem((String)path, (String)var5_5.getMessage()));
        }
    }

    @NotNull
    private List<MavenArtifact> resolveTransitively(@NotNull List<MavenArtifactInfo> artifacts, @NotNull List<MavenRemoteRepository> remoteRepositories, MavenToken token) {
        List list;
        if (artifacts == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(21);
        }
        if (remoteRepositories == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(22);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        try {
            LinkedHashSet<org.apache.maven.artifact.Artifact> toResolve = new LinkedHashSet<org.apache.maven.artifact.Artifact>();
            for (MavenArtifactInfo each : artifacts) {
                toResolve.add(this.createArtifact(each));
            }
            org.apache.maven.artifact.Artifact project = this.getComponent(ArtifactFactory.class).createBuildArtifact("temp", "temp", "666", "pom");
            Set res = this.getComponent(ArtifactResolver.class).resolveTransitively(toResolve, project, Collections.EMPTY_MAP, this.myLocalRepository, this.convertRepositories(remoteRepositories), this.getComponent(ArtifactMetadataSource.class)).getArtifacts();
            list = Maven3ModelConverter.convertArtifacts((Collection)res, new HashMap(), (File)this.getLocalRepositoryFile());
        }
        catch (Exception e) {
            MavenServerGlobals.getLogger().info((Throwable)e);
            throw this.wrapToSerializableRuntimeException(e);
        }
        if (list == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    public MavenArtifactResolveResult resolveArtifactsTransitively(@NotNull List<MavenArtifactInfo> artifacts, @NotNull List<MavenRemoteRepository> remoteRepositories, MavenToken token) {
        if (artifacts == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(24);
        }
        if (remoteRepositories == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(25);
        }
        return new MavenArtifactResolveResult(this.resolveTransitively(artifacts, remoteRepositories, token), null);
    }

    public List<PluginResolutionResponse> resolvePlugins(@NotNull String longRunningTaskId, @NotNull Collection<PluginResolutionRequest> pluginResolutionRequests, MavenToken token) {
        if (longRunningTaskId == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(26);
        }
        if (pluginResolutionRequests == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(27);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        ArrayList<PluginResolutionResponse> resolvedPlugins = new ArrayList<PluginResolutionResponse>();
        try (LongRunningTask task = this.newLongRunningTask(longRunningTaskId, pluginResolutionRequests.size(), (MavenServerConsoleIndicatorWrapper)this.myConsoleWrapper);){
            for (PluginResolutionRequest pluginResolutionRequest : pluginResolutionRequests) {
                MavenId mavenPluginId = pluginResolutionRequest.getMavenPluginId();
                resolvedPlugins.add(this.resolvePlugin(task, mavenPluginId, pluginResolutionRequest.getNativeMavenProjectId()));
            }
            ArrayList<PluginResolutionResponse> arrayList = resolvedPlugins;
            return arrayList;
        }
    }

    private PluginResolutionResponse resolvePlugin(LongRunningTask task, @NotNull MavenId mavenPluginId, int nativeMavenProjectId) {
        if (mavenPluginId == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(28);
        }
        ArrayList<MavenArtifact> artifacts = new ArrayList<MavenArtifact>();
        if (task.isCanceled()) {
            return new PluginResolutionResponse(mavenPluginId, false, artifacts);
        }
        try {
            Plugin mavenPlugin = new Plugin();
            mavenPlugin.setGroupId(mavenPluginId.getGroupId());
            mavenPlugin.setArtifactId(mavenPluginId.getArtifactId());
            mavenPlugin.setVersion(mavenPluginId.getVersion());
            MavenProject project = RemoteNativeMaven3ProjectHolder.findProjectById((int)nativeMavenProjectId);
            Plugin pluginFromProject = (Plugin)project.getBuild().getPluginsAsMap().get(mavenPluginId.getGroupId() + ':' + mavenPluginId.getArtifactId());
            if (pluginFromProject != null) {
                mavenPlugin.setDependencies(pluginFromProject.getDependencies());
            }
            MavenExecutionRequest request = this.createRequest(null, null, null);
            DefaultMaven maven = (DefaultMaven)this.getComponent(Maven.class);
            RepositorySystemSession repositorySystemSession = maven.newRepositorySession(request);
            PluginDependenciesResolver pluginDependenciesResolver = this.getComponent(PluginDependenciesResolver.class);
            Artifact pluginArtifact = pluginDependenciesResolver.resolve(mavenPlugin, project.getRemotePluginRepositories(), repositorySystemSession);
            org.sonatype.aether.graph.DependencyNode node = pluginDependenciesResolver.resolve(mavenPlugin, pluginArtifact, null, project.getRemotePluginRepositories(), repositorySystemSession);
            PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
            node.accept((DependencyVisitor)nlg);
            for (Artifact artifact : nlg.getArtifacts(true)) {
                if (Objects.equals(artifact.getArtifactId(), mavenPluginId.getArtifactId()) && Objects.equals(artifact.getGroupId(), mavenPluginId.getGroupId())) continue;
                artifacts.add(Maven3ModelConverter.convertArtifact((org.apache.maven.artifact.Artifact)RepositoryUtils.toArtifact((Artifact)artifact), (File)this.getLocalRepositoryFile()));
            }
            task.incrementFinishedRequests();
            return new PluginResolutionResponse(mavenPluginId, true, artifacts);
        }
        catch (Exception e) {
            MavenServerGlobals.getLogger().info((Throwable)e);
            return new PluginResolutionResponse(mavenPluginId, false, artifacts);
        }
    }

    @NotNull
    public List<MavenArtifact> resolveArtifacts(@NotNull String longRunningTaskId, @NotNull Collection<MavenArtifactResolutionRequest> requests, MavenToken token) {
        if (longRunningTaskId == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(29);
        }
        if (requests == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(30);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        LongRunningTask task = this.newLongRunningTask(longRunningTaskId, requests.size(), (MavenServerConsoleIndicatorWrapper)this.myConsoleWrapper);
        List<MavenArtifact> list = this.resolve(task, requests);
        List<MavenArtifact> list2 = list;
        if (list2 == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(31);
        }
        return list2;
        finally {
            if (task != null) {
                task.close();
            }
        }
    }

    @NotNull
    private List<MavenArtifact> resolve(@NotNull LongRunningTask task, @NotNull Collection<MavenArtifactResolutionRequest> requests) {
        if (task == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(32);
        }
        if (requests == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(33);
        }
        ArrayList<MavenArtifact> artifacts = new ArrayList<MavenArtifact>();
        for (MavenArtifactResolutionRequest request : requests) {
            if (task.isCanceled()) break;
            MavenArtifact artifact = this.doResolve(request.getArtifactInfo(), request.getRemoteRepositories());
            artifacts.add(artifact);
            task.incrementFinishedRequests();
        }
        ArrayList<MavenArtifact> arrayList = artifacts;
        if (arrayList == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    private MavenArtifact doResolve(MavenArtifactInfo info, List<MavenRemoteRepository> remoteRepositories) {
        org.apache.maven.artifact.Artifact resolved = this.doResolve(this.createArtifact(info), this.convertRepositories(remoteRepositories));
        return Maven3ModelConverter.convertArtifact((org.apache.maven.artifact.Artifact)resolved, (File)this.getLocalRepositoryFile());
    }

    private org.apache.maven.artifact.Artifact doResolve(org.apache.maven.artifact.Artifact artifact, List<ArtifactRepository> remoteRepositories) {
        try {
            return this.resolve(artifact, remoteRepositories);
        }
        catch (Exception e) {
            MavenServerGlobals.getLogger().info((Throwable)e);
            return artifact;
        }
    }

    private org.apache.maven.artifact.Artifact resolve(@NotNull org.apache.maven.artifact.Artifact artifact, @NotNull List<ArtifactRepository> repos) throws ArtifactResolutionException, ArtifactNotFoundException {
        if (artifact == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(35);
        }
        if (repos == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(36);
        }
        DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest();
        request.setRemoteRepositories(repos);
        try {
            this.getComponent(MavenExecutionRequestPopulator.class).populateFromSettings((MavenExecutionRequest)request, this.myMavenSettings);
            this.getComponent(MavenExecutionRequestPopulator.class).populateDefaults((MavenExecutionRequest)request);
        }
        catch (MavenExecutionRequestPopulationException e) {
            throw new RuntimeException(e);
        }
        this.getComponent(ArtifactResolver.class).resolve(artifact, request.getRemoteRepositories(), this.myLocalRepository);
        return artifact;
    }

    @NotNull
    protected List<ArtifactRepository> convertRepositories(List<MavenRemoteRepository> repositories) {
        List result = this.map2ArtifactRepositories(repositories);
        if (this.getComponent(LegacySupport.class).getRepositorySession() == null) {
            this.myRepositorySystem.injectMirror(result, this.myMavenSettings.getMirrors());
            this.myRepositorySystem.injectProxy(result, this.myMavenSettings.getProxies());
            this.myRepositorySystem.injectAuthentication(result, this.myMavenSettings.getServers());
        }
        List list = result;
        if (list == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(37);
        }
        return list;
    }

    private org.apache.maven.artifact.Artifact createArtifact(MavenArtifactInfo info) {
        return this.getComponent(ArtifactFactory.class).createArtifactWithClassifier(info.getGroupId(), info.getArtifactId(), info.getVersion(), info.getPackaging(), info.getClassifier());
    }

    @NotNull
    public List<MavenGoalExecutionResult> executeGoal(@NotNull String longRunningTaskId, @NotNull Collection<MavenGoalExecutionRequest> requests, @NotNull String goal, MavenToken token) {
        if (longRunningTaskId == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(38);
        }
        if (requests == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(39);
        }
        if (goal == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(40);
        }
        MavenServerUtil.checkToken((MavenToken)token);
        LongRunningTask task = this.newLongRunningTask(longRunningTaskId, requests.size(), (MavenServerConsoleIndicatorWrapper)this.myConsoleWrapper);
        List<MavenGoalExecutionResult> list = this.executeGoal(task, requests, goal);
        List<MavenGoalExecutionResult> list2 = list;
        if (list2 == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(41);
        }
        return list2;
        finally {
            if (task != null) {
                task.close();
            }
        }
    }

    private List<MavenGoalExecutionResult> executeGoal(@NotNull LongRunningTask task, @NotNull Collection<MavenGoalExecutionRequest> requests, @NotNull String goal) {
        if (task == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(42);
        }
        if (requests == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(43);
        }
        if (goal == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(44);
        }
        ArrayList<MavenGoalExecutionResult> results = new ArrayList<MavenGoalExecutionResult>();
        for (MavenGoalExecutionRequest request : requests) {
            if (task.isCanceled()) break;
            File file = request.file();
            MavenExplicitProfiles profiles = request.profiles();
            Maven3ExecutionResult result = this.doExecute(file, new ArrayList<String>(profiles.getEnabledProfiles()), new ArrayList<String>(profiles.getDisabledProfiles()), goal);
            results.add(this.createEmbedderExecutionResult(file, result));
            task.incrementFinishedRequests();
        }
        return results;
    }

    private Maven3ExecutionResult doExecute(@NotNull File file, @NotNull List<String> activeProfiles, @NotNull List<String> inactiveProfiles, @NotNull String goal) {
        if (file == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(45);
        }
        if (activeProfiles == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(46);
        }
        if (inactiveProfiles == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(47);
        }
        if (goal == null) {
            Maven30ServerEmbedderImpl.$$$reportNull$$$0(48);
        }
        MavenExecutionRequest request = this.createRequest(file, activeProfiles, inactiveProfiles);
        request.setGoals(Collections.singletonList(goal));
        MavenExecutionResult executionResult = this.safeExecute(request, this.getComponent(Maven.class));
        return new Maven3ExecutionResult(executionResult.getProject(), Maven30ServerEmbedderImpl.filterExceptions(executionResult.getExceptions()));
    }

    private MavenExecutionResult safeExecute(MavenExecutionRequest request, Maven maven) {
        MavenLeakDetector detector = new MavenLeakDetector().mark();
        MavenExecutionResult result = maven.execute(request);
        detector.check();
        return result;
    }

    public void release(MavenToken token) {
        MavenServerUtil.checkToken((MavenToken)token);
        this.myContainer.dispose();
    }

    protected ArtifactRepository getLocalRepository() {
        return this.myLocalRepository;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/Maven30ServerEmbedderImpl";
                break;
            }
            case 2: 
            case 18: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 10: 
            case 15: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 4: 
            case 11: 
            case 16: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inactiveProfiles";
                break;
            }
            case 5: 
            case 26: 
            case 29: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "longRunningTaskId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 8: 
            case 13: 
            case 32: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteRepositories";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginResolutionRequests";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenPluginId";
                break;
            }
            case 30: 
            case 33: 
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repos";
                break;
            }
            case 40: 
            case 44: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "interpolateAndAlignModel";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/Maven30ServerEmbedderImpl";
                break;
            }
            case 7: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveProjects";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveProject";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTransitively";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveArtifacts";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "convertRepositories";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "executeGoal";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "evaluateEffectivePom";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjects";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doResolveProject";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createEmbedderExecutionResult";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectProblems";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "resolveTransitively";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "resolveArtifactsTransitively";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "resolvePlugins";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "resolvePlugin";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "resolveArtifacts";
                break;
            }
            case 32: 
            case 33: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "executeGoal";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Computable<T> {
        public T compute();
    }
}

