/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions.updateFromSources;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateFromSourcesDialog;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateFromSourcesKt;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateFromSourcesSettings;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateFromSourcesSettingsKt;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateFromSourcesSettingsState;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateIdeFromSourcesAction;
import org.jetbrains.idea.devkit.util.PsiUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/idea/devkit/actions/updateFromSources/UpdateIdeFromSourcesAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "forceShowSettings", "", "(Z)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.devkit.core"})
public class UpdateIdeFromSourcesAction
extends AnAction
implements DumbAware {
    private final boolean forceShowSettings;

    @JvmOverloads
    public UpdateIdeFromSourcesAction(boolean forceShowSettings) {
        super(forceShowSettings ? DevKitBundle.message("action.UpdateIdeFromSourcesAction.update.show.settings.text", new Object[0]) : DevKitBundle.message("action.UpdateIdeFromSourcesAction.update.text", new Object[0]), DevKitBundle.message("action.UpdateIdeFromSourcesAction.update.description", new Object[0]), null);
        this.forceShowSettings = forceShowSettings;
    }

    public /* synthetic */ UpdateIdeFromSourcesAction(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        if (this.forceShowSettings || UpdateFromSourcesSettings.Companion.getState().getShowSettings()) {
            String oldWorkIdePath = UpdateFromSourcesSettingsKt.getActualIdePath(UpdateFromSourcesSettings.Companion.getState());
            boolean ok = new UpdateFromSourcesDialog(project2, this.forceShowSettings).showAndGet();
            if (!ok) {
                return;
            }
            UpdateFromSourcesSettingsState updatedState = UpdateFromSourcesSettings.Companion.getState();
            if (!Intrinsics.areEqual((Object)oldWorkIdePath, (Object)UpdateFromSourcesSettingsKt.getActualIdePath(updatedState))) {
                updatedState.getWorkIdePathsHistory().remove(oldWorkIdePath);
                updatedState.getWorkIdePathsHistory().remove(UpdateFromSourcesSettingsKt.getActualIdePath(updatedState));
                updatedState.getWorkIdePathsHistory().add(0, UpdateFromSourcesSettingsKt.getActualIdePath(updatedState));
                updatedState.getWorkIdePathsHistory().add(0, oldWorkIdePath);
            }
        }
        UpdateFromSourcesKt.updateFromSources(project2, (Function0<Unit>)((Function0)actionPerformed.1.INSTANCE), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(project2){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Messages.showErrorDialog((Project)this.$project, (String)it, (String)CommonBundle.getErrorTitle());
            }
        }));
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        e.getPresentation().setEnabledAndVisible(project != null && PsiUtil.isIdeaProject(project));
    }

    @JvmOverloads
    public UpdateIdeFromSourcesAction() {
        this(false, 1, null);
    }
}

