/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.PsiUtil;

public final class DevKitInspectionUtil {
    static boolean isAllowedInPluginsOnly(@NotNull PsiFile file) {
        if (file == null) {
            DevKitInspectionUtil.$$$reportNull$$$0(0);
        }
        return DevKitInspectionUtil.isAllowed(file, DevKitInspectionUtil::isPluginFile);
    }

    public static boolean isAllowed(@NotNull PsiFile file) {
        if (file == null) {
            DevKitInspectionUtil.$$$reportNull$$$0(1);
        }
        return DevKitInspectionUtil.isAllowed(file, __ -> true);
    }

    public static boolean isClassAvailable(@NotNull ProblemsHolder holder, @NonNls String classFqn) {
        if (holder == null) {
            DevKitInspectionUtil.$$$reportNull$$$0(2);
        }
        return JavaPsiFacade.getInstance((Project)holder.getProject()).findClass(classFqn, holder.getFile().getResolveScope()) != null;
    }

    private static boolean isAllowed(@NotNull PsiFile file, @NotNull Predicate<? super PsiFile> predicate) {
        if (file == null) {
            DevKitInspectionUtil.$$$reportNull$$$0(3);
        }
        if (predicate == null) {
            DevKitInspectionUtil.$$$reportNull$$$0(4);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return false;
        }
        if (TestSourcesFilter.isTestSources((VirtualFile)vFile, (Project)file.getProject())) {
            return false;
        }
        if (PsiUtil.isIdeaProject(file.getProject())) {
            return predicate.test((PsiFile)file);
        }
        return DevKitInspectionUtil.isInPluginModule(file);
    }

    private static boolean isInPluginModule(@NotNull PsiFile file) {
        Module module;
        if (file == null) {
            DevKitInspectionUtil.$$$reportNull$$$0(5);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) == null) {
            return false;
        }
        return PluginModuleType.isPluginModuleOrDependency(module) || PsiUtil.isPluginModule(module);
    }

    private static boolean isPluginFile(@NotNull PsiFile file) {
        String path;
        if (file == null) {
            DevKitInspectionUtil.$$$reportNull$$$0(6);
        }
        boolean isPlatform = (path = file.getVirtualFile().getPath()).contains("/platform/") && !path.contains("/platform/cwm-") && !path.contains("/platform/rd-");
        boolean isRider = path.contains("/Rider/Frontend/rider/") || path.contains("/Rider/Frontend/rider-cpp-core/") || path.contains("/Rider/Frontend/rdclient-dotnet/");
        return !isPlatform && !isRider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/inspections/DevKitInspectionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAllowedInPluginsOnly";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isAllowed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isClassAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isInPluginModule";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isPluginFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

