/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.uast.UastHintedVisitorAdapter;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionUtil;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

abstract class UseEqualsInspectionBase
extends DevKitUastInspectionBase
implements CleanupLocalInspectionTool {
    public static final Class<? extends UElement>[] HINTS = new Class[]{UBinaryExpression.class};

    UseEqualsInspectionBase() {
    }

    @Override
    protected boolean isAllowed(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            UseEqualsInspectionBase.$$$reportNull$$$0(0);
        }
        return super.isAllowed(holder) && DevKitInspectionUtil.isClassAvailable(holder, this.getTargetClass().getName());
    }

    @NotNull
    protected abstract Class<?> getTargetClass();

    @Override
    @NotNull
    protected final PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UseEqualsInspectionBase.$$$reportNull$$$0(1);
        }
        PsiElementVisitor psiElementVisitor = UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(){

            public boolean visitBinaryExpression(@NotNull UBinaryExpression binaryExpression) {
                UastBinaryOperator operator;
                if (binaryExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (UseEqualsInspectionBase.isIdentityComparison(operator = binaryExpression.getOperator()) && UseEqualsInspectionBase.this.isNotExcluded(binaryExpression)) {
                    PsiElement sourcePsi = binaryExpression.getSourcePsi();
                    if (sourcePsi == null) {
                        return true;
                    }
                    String operatorText = UseEqualsInspectionBase.getOperatorText(binaryExpression);
                    holder.registerProblem(sourcePsi, DevKitBundle.message("inspections.use.equals.description", UseEqualsInspectionBase.this.getTargetClass().getSimpleName()), UseEqualsInspectionBase.createFix(operatorText, operator == UastBinaryOperator.IDENTITY_NOT_EQUALS, sourcePsi.getLanguage()));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryExpression", "org/jetbrains/idea/devkit/inspections/internal/UseEqualsInspectionBase$1", "visitBinaryExpression"));
            }
        }, (Class[])HINTS);
        if (psiElementVisitor == null) {
            UseEqualsInspectionBase.$$$reportNull$$$0(2);
        }
        return psiElementVisitor;
    }

    private static boolean isIdentityComparison(@NotNull UastBinaryOperator operator) {
        if (operator == null) {
            UseEqualsInspectionBase.$$$reportNull$$$0(3);
        }
        return operator == UastBinaryOperator.IDENTITY_EQUALS || operator == UastBinaryOperator.IDENTITY_NOT_EQUALS;
    }

    private boolean isNotExcluded(@NotNull UBinaryExpression binaryExpression) {
        UExpression leftOperand;
        if (binaryExpression == null) {
            UseEqualsInspectionBase.$$$reportNull$$$0(4);
        }
        if (this.isExcluded(leftOperand = binaryExpression.getLeftOperand())) {
            return false;
        }
        UExpression rightOperand = binaryExpression.getRightOperand();
        if (this.isExcluded(rightOperand)) {
            return false;
        }
        return this.hasTargetType(leftOperand) || this.hasTargetType(rightOperand);
    }

    private static String getOperatorText(@NotNull UBinaryExpression binaryExpression) {
        UIdentifier identifier;
        if (binaryExpression == null) {
            UseEqualsInspectionBase.$$$reportNull$$$0(5);
        }
        if ((identifier = binaryExpression.getOperatorIdentifier()) == null) {
            return null;
        }
        PsiElement identifierSourcePsi = identifier.getSourcePsi();
        if (identifierSourcePsi == null) {
            return null;
        }
        return identifierSourcePsi.getText();
    }

    protected boolean isExcluded(@NotNull UExpression operand) {
        if (operand == null) {
            UseEqualsInspectionBase.$$$reportNull$$$0(6);
        }
        return operand instanceof ULiteralExpression || operand instanceof UThisExpression;
    }

    private boolean hasTargetType(@NotNull UExpression operand) {
        if (operand == null) {
            UseEqualsInspectionBase.$$$reportNull$$$0(7);
        }
        return operand.getSourcePsi() != null && InheritanceUtil.isInheritor((PsiType)operand.getExpressionType(), (String)this.getTargetClass().getName());
    }

    private static LocalQuickFix @NotNull [] createFix(String operatorText, boolean negated, Language language) {
        if (language.is((Language)JavaLanguage.INSTANCE)) {
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new ReplaceIdentityWithEqualsComparisonFix(operatorText, negated)};
            if (localQuickFixArray == null) {
                UseEqualsInspectionBase.$$$reportNull$$$0(8);
            }
            return localQuickFixArray;
        }
        if (LocalQuickFix.EMPTY_ARRAY == null) {
            UseEqualsInspectionBase.$$$reportNull$$$0(9);
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/internal/UseEqualsInspectionBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/UseEqualsInspectionBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildInternalVisitor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAllowed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildInternalVisitor";
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isIdentityComparison";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isNotExcluded";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOperatorText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasTargetType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 8, 9 -> new IllegalStateException(string);
        };
    }

    private static class ReplaceIdentityWithEqualsComparisonFix
    implements LocalQuickFix {
        private final String myCurrentOperator;
        protected final boolean myNegated;

        ReplaceIdentityWithEqualsComparisonFix(String currentOperator, boolean negated) {
            this.myCurrentOperator = currentOperator;
            this.myNegated = negated;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                ReplaceIdentityWithEqualsComparisonFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                ReplaceIdentityWithEqualsComparisonFix.$$$reportNull$$$0(1);
            }
            if (!((element = descriptor.getPsiElement()) instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)element;
            PsiExpression lOperand = binaryExpression.getLOperand();
            PsiExpression rOperand = binaryExpression.getROperand();
            if (rOperand == null) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            String lText = commentTracker.text(PsiUtil.skipParenthesizedExprUp((PsiElement)lOperand));
            String rText = commentTracker.text(PsiUtil.skipParenthesizedExprUp((PsiElement)rOperand));
            @NonNls String expString = (this.myNegated ? "!" : "") + lText + ".equals(" + rText + ")";
            PsiReplacementUtil.replaceExpression((PsiExpression)binaryExpression, (String)expString, (CommentTracker)commentTracker);
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.myNegated ? DevKitBundle.message("inspections.use.equals.fix.replace.equality.with.not.equals.name", this.myCurrentOperator) : DevKitBundle.message("inspections.use.equals.fix.replace.equality.with.equals.name", this.myCurrentOperator);
            if (string == null) {
                ReplaceIdentityWithEqualsComparisonFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = DevKitBundle.message("inspections.use.equals.fix.replace.equality.with.equals.family.name", new Object[0]);
            if (string == null) {
                ReplaceIdentityWithEqualsComparisonFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/inspections/internal/UseEqualsInspectionBase$ReplaceIdentityWithEqualsComparisonFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/UseEqualsInspectionBase$ReplaceIdentityWithEqualsComparisonFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

