/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.impl.jcef;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.cef.callback.CefCallback;
import org.cef.handler.CefResourceHandler;
import org.cef.misc.IntRef;
import org.cef.misc.StringRef;
import org.cef.network.CefRequest;
import org.cef.network.CefResponse;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J \u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J(\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/intellij/images/editor/impl/jcef/CefStreamResourceHandler;", "Lorg/cef/handler/CefResourceHandler;", "Lcom/intellij/openapi/Disposable;", "myStream", "Ljava/io/InputStream;", "myMimeType", "", "parent", "(Ljava/io/InputStream;Ljava/lang/String;Lcom/intellij/openapi/Disposable;)V", "cancel", "", "dispose", "getResponseHeaders", "response", "Lorg/cef/network/CefResponse;", "responseLength", "Lorg/cef/misc/IntRef;", "redirectUrl", "Lorg/cef/misc/StringRef;", "processRequest", "", "request", "Lorg/cef/network/CefRequest;", "callback", "Lorg/cef/callback/CefCallback;", "readResponse", "dataOut", "", "bytesToRead", "", "bytesRead", "intellij.platform.images"})
public final class CefStreamResourceHandler
implements CefResourceHandler,
Disposable {
    @NotNull
    private final InputStream myStream;
    @NotNull
    private final String myMimeType;

    public CefStreamResourceHandler(@NotNull InputStream myStream, @NotNull String myMimeType, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)myStream, (String)"myStream");
        Intrinsics.checkNotNullParameter((Object)myMimeType, (String)"myMimeType");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.myStream = myStream;
        this.myMimeType = myMimeType;
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public boolean processRequest(@NotNull CefRequest request, @NotNull CefCallback callback) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        callback.Continue();
        return true;
    }

    public void getResponseHeaders(@NotNull CefResponse response, @NotNull IntRef responseLength, @NotNull StringRef redirectUrl) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)responseLength, (String)"responseLength");
        Intrinsics.checkNotNullParameter((Object)redirectUrl, (String)"redirectUrl");
        response.setMimeType(this.myMimeType);
        response.setStatus(200);
    }

    public boolean readResponse(@NotNull byte[] dataOut, int bytesToRead, @NotNull IntRef bytesRead, @NotNull CefCallback callback) {
        Intrinsics.checkNotNullParameter((Object)dataOut, (String)"dataOut");
        Intrinsics.checkNotNullParameter((Object)bytesRead, (String)"bytesRead");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        try {
            bytesRead.set(this.myStream.read(dataOut, 0, bytesToRead));
            if (bytesRead.get() != -1) {
                return true;
            }
        }
        catch (IOException e) {
            callback.cancel();
        }
        bytesRead.set(0);
        Disposer.dispose((Disposable)this);
        return false;
    }

    public void cancel() {
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
        try {
            this.myStream.close();
        }
        catch (IOException e) {
            Logger.getInstance(CefStreamResourceHandler.class).warn("Failed to close the stream", (Throwable)e);
        }
    }
}

