/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.classFilter;

import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.filters.KotlinUtils;
import com.intellij.rt.coverage.instrumentation.filters.classFilter.ClassFilter;
import org.jetbrains.coverage.org.objectweb.asm.FieldVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class KotlinValueClassFilter
extends ClassFilter {
    private boolean myEqualsVisited;
    private boolean myToStringVisited;
    private boolean myHashCodeVisited;
    private boolean myConstructorVisited;
    private boolean myBoxingVisited;
    private boolean myUnboxingVisited;
    private int myGetterLine = -1;
    private int myConstructorLine = -1;
    private int myFieldsCount = 0;
    private String myFieldType;

    public boolean isApplicable(Instrumenter context) {
        return true;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
        if (!KotlinUtils.isKotlinClass(this.myContext)) {
            return mv;
        }
        if ("constructor-impl".equals(name) && (access & 8) != 0) {
            this.myConstructorVisited = true;
            return new MethodVisitor(589824, mv){

                public void visitCode() {
                    super.visitCode();
                    if (KotlinValueClassFilter.this.myConstructorLine >= 0) {
                        Label label = new Label();
                        super.visitLabel(label);
                        super.visitLineNumber(KotlinValueClassFilter.this.myConstructorLine, label);
                    }
                }
            };
        }
        if ("toString-impl".equals(name) && (access & 8) != 0) {
            this.myToStringVisited = true;
            return mv;
        }
        if ("equals-impl".equals(name) && (access & 8) != 0) {
            this.myEqualsVisited = true;
            return mv;
        }
        if ("hashCode-impl".equals(name) && (access & 8) != 0) {
            this.myHashCodeVisited = true;
            return mv;
        }
        if ("box-impl".equals(name) && (access & 8) != 0 && (access & 0x10) != 0 && (access & 0x1000) != 0) {
            this.myBoxingVisited = true;
            return mv;
        }
        if ("unbox-impl".equals(name) && (access & 0x10) != 0 && (access & 0x1000) != 0) {
            this.myUnboxingVisited = true;
            return mv;
        }
        if (name.startsWith("get") && this.myFieldType != null && ("()" + this.myFieldType).equals(descriptor) && !name.endsWith("-impl")) {
            return new MethodVisitor(589824, mv){

                public void visitLineNumber(int line, Label start) {
                    super.visitLineNumber(line, start);
                    if (KotlinValueClassFilter.this.myGetterLine == line) {
                        return;
                    }
                    if (KotlinValueClassFilter.this.myGetterLine == -1) {
                        KotlinValueClassFilter.this.myGetterLine = line;
                    } else {
                        KotlinValueClassFilter.this.myGetterLine = -2;
                    }
                }
            };
        }
        if ("<init>".equals(name) && (access & 0x1000) != 0 && (access & 2) != 0) {
            return new MethodVisitor(589824, mv){

                public void visitLineNumber(int line, Label start) {
                    super.visitLineNumber(line, start);
                    if (KotlinValueClassFilter.this.myConstructorLine == line) {
                        return;
                    }
                    if (KotlinValueClassFilter.this.myConstructorLine == -1) {
                        KotlinValueClassFilter.this.myConstructorLine = line;
                    } else {
                        KotlinValueClassFilter.this.myConstructorLine = -2;
                    }
                }
            };
        }
        return mv;
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        ++this.myFieldsCount;
        this.myFieldType = descriptor;
        return super.visitField(access, name, descriptor, signature, value);
    }

    public void visitEnd() {
        if (this.myConstructorVisited && this.myEqualsVisited && this.myHashCodeVisited && this.myToStringVisited && this.myBoxingVisited && this.myUnboxingVisited && this.myFieldsCount == 1 && this.myGetterLine >= 0 && this.myGetterLine != this.myConstructorLine) {
            this.myContext.removeLine(this.myGetterLine);
        }
        super.visitEnd();
    }
}

