/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.lines;

import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.filters.KotlinUtils;
import com.intellij.rt.coverage.instrumentation.filters.lines.LinesFilter;
import java.util.HashSet;
import org.jetbrains.coverage.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class KotlinDeprecatedMethodFilter
extends LinesFilter {
    private static final String DEPRECATED_METHODS = "DEPRECATED_METHODS_SET";
    private String myName;
    private String myDesc;
    private boolean myShouldIgnore;

    public boolean isApplicable(Instrumenter context, int access, String name, String desc, String signature, String[] exceptions) {
        return KotlinUtils.isKotlinClass(context);
    }

    public void initFilter(MethodVisitor methodVisitor, Instrumenter context, String name, String desc) {
        String originalName;
        HashSet deprecatedMethods;
        Object property;
        super.initFilter(methodVisitor, context, name, desc);
        this.myName = name;
        this.myDesc = desc;
        if (name.endsWith("$default") && (property = this.myContext.getProperty(DEPRECATED_METHODS)) != null && (deprecatedMethods = (HashSet)property).contains(originalName = name.substring(0, name.length() - "$default".length()))) {
            this.myContext.setIgnoreSection(true);
            this.myShouldIgnore = true;
        }
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        AnnotationVisitor av = super.visitAnnotation(descriptor, visible);
        if (!"Lkotlin/Deprecated;".equals(descriptor)) {
            return av;
        }
        return new AnnotationVisitor(589824, av){

            public void visitEnum(String name, String descriptor, String value) {
                super.visitEnum(name, descriptor, value);
                if (!"Lkotlin/DeprecationLevel;".equals(descriptor)) {
                    return;
                }
                if ("ERROR".equals(value) || "HIDDEN".equals(value)) {
                    HashSet property;
                    if (!KotlinDeprecatedMethodFilter.this.myShouldIgnore) {
                        KotlinDeprecatedMethodFilter.this.myContext.setIgnoreSection(true);
                        KotlinDeprecatedMethodFilter.this.myShouldIgnore = true;
                    }
                    if ((property = KotlinDeprecatedMethodFilter.this.myContext.getProperty(KotlinDeprecatedMethodFilter.DEPRECATED_METHODS)) == null) {
                        property = new HashSet();
                        KotlinDeprecatedMethodFilter.this.myContext.addProperty(KotlinDeprecatedMethodFilter.DEPRECATED_METHODS, property);
                    }
                    HashSet deprecatedMethods = property;
                    deprecatedMethods.add(KotlinDeprecatedMethodFilter.this.myName);
                }
            }
        };
    }

    public void visitCode() {
        super.visitCode();
        if (this.myShouldIgnore) {
            this.myContext.getProjectData().addIgnoredMethod(this.myContext.getClassName(), this.myName, this.myDesc);
        }
    }

    public void visitEnd() {
        super.visitEnd();
        if (this.myShouldIgnore) {
            this.myContext.setIgnoreSection(false);
        }
    }
}

