/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.action;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.JavaXmlDocumentKt;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.statistics.GradleActionsUsagesCollector;
import org.jetbrains.plugins.gradle.util.GradleUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PasteMvnDependencyPreProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        return null;
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        if (this.isApplicable(file) && PasteMvnDependencyPreProcessor.isMvnDependency(text)) {
            GradleActionsUsagesCollector.trigger(project, GradleActionsUsagesCollector.PASTE_MAVEN_DEPENDENCY);
            GradleVersion gradleVersion2 = GradleUtil.getGradleVersion(project, file);
            return PasteMvnDependencyPreProcessor.toGradleDependency(text, gradleVersion2);
        }
        String string2 = text;
        if (string2 == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(0);
        }
        return string2;
    }

    protected boolean isApplicable(PsiFile file) {
        return file.getName().endsWith(".gradle");
    }

    @NotNull
    private static String formatGradleDependency(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @NotNull String scope, @NotNull String classifier) {
        if (groupId == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(1);
        }
        if (artifactId == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(2);
        }
        if (version == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(4);
        }
        if (classifier == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(5);
        }
        Object gradleClassifier = classifier.isEmpty() ? "" : ":" + classifier;
        String string2 = scope + " '" + groupId + ":" + artifactId + ":" + version + (String)gradleClassifier + "'";
        if (string2 == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @ApiStatus.Internal
    @NotNull
    public static String toGradleDependency(@NotNull String mavenDependency, @NotNull GradleVersion gradleVersion2) {
        String string2;
        if (mavenDependency == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(7);
        }
        if (gradleVersion2 == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(8);
        }
        try {
            DocumentBuilder builder = JavaXmlDocumentKt.createDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(mavenDependency)));
            String gradleDependency = PasteMvnDependencyPreProcessor.extractGradleDependency(document, gradleVersion2);
            string2 = gradleDependency != null ? gradleDependency : mavenDependency;
        }
        catch (IOException | SAXException exception) {
            String string3 = mavenDependency;
            if (string3 == null) {
                PasteMvnDependencyPreProcessor.$$$reportNull$$$0(10);
            }
            return string3;
        }
        if (string2 == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @Nullable
    private static String extractGradleDependency(Document document, @NotNull GradleVersion gradleVersion2) {
        if (gradleVersion2 == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(11);
        }
        String groupId = PasteMvnDependencyPreProcessor.getGroupId(document);
        String artifactId = PasteMvnDependencyPreProcessor.getArtifactId(document);
        String version = PasteMvnDependencyPreProcessor.getVersion(document);
        String scope = PasteMvnDependencyPreProcessor.getScope(document, gradleVersion2);
        String classifier = PasteMvnDependencyPreProcessor.getClassifier(document);
        if (groupId.isEmpty() || artifactId.isEmpty() || version.isEmpty()) {
            return null;
        }
        return PasteMvnDependencyPreProcessor.formatGradleDependency(groupId, artifactId, version, scope, classifier);
    }

    @NotNull
    private static String getScope(@NotNull Document document, @NotNull GradleVersion gradleVersion2) {
        if (document == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(12);
        }
        if (gradleVersion2 == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(13);
        }
        String scope = PasteMvnDependencyPreProcessor.firstOrEmpty(document.getElementsByTagName("scope"));
        boolean isSupportedImplementation = GradleUtil.isSupportedImplementationScope(gradleVersion2);
        return switch (scope) {
            case "test" -> {
                if (isSupportedImplementation) {
                    yield "testImplementation";
                }
                yield "testCompile";
            }
            case "provided" -> "compileOnly";
            case "runtime" -> "runtime";
            case "compile" -> {
                if (isSupportedImplementation) {
                    yield "implementation";
                }
                yield "compile";
            }
            default -> isSupportedImplementation ? "implementation" : "compile";
        };
    }

    private static String getVersion(@NotNull Document document) {
        if (document == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(14);
        }
        return PasteMvnDependencyPreProcessor.firstOrEmpty(document.getElementsByTagName("version"));
    }

    private static String getArtifactId(@NotNull Document document) {
        if (document == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(15);
        }
        return PasteMvnDependencyPreProcessor.firstOrEmpty(document.getElementsByTagName("artifactId"));
    }

    private static String getGroupId(@NotNull Document document) {
        if (document == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(16);
        }
        return PasteMvnDependencyPreProcessor.firstOrEmpty(document.getElementsByTagName("groupId"));
    }

    private static String getClassifier(@NotNull Document document) {
        if (document == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(17);
        }
        return PasteMvnDependencyPreProcessor.firstOrEmpty(document.getElementsByTagName("classifier"));
    }

    private static String firstOrEmpty(@NotNull NodeList list2) {
        Node first;
        if (list2 == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(18);
        }
        return (first = list2.item(0)) != null ? first.getTextContent() : "";
    }

    private static boolean isMvnDependency(String text) {
        String trimmed = PasteMvnDependencyPreProcessor.trimLeadingComment(text.trim());
        return trimmed.startsWith("<dependency>") && trimmed.endsWith("</dependency>");
    }

    private static String trimLeadingComment(String text) {
        int start = text.indexOf("<!--");
        int end = text.indexOf("-->");
        if (start == 0 && end > 0) {
            return text.substring(end + "-->".length()).trim();
        }
        return text;
    }

    public boolean requiresAllDocumentsToBeCommitted(@NotNull Editor editor, @NotNull Project project) {
        if (editor == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(19);
        }
        if (project == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(20);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 7, 8, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/action/PasteMvnDependencyPreProcessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classifier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenDependency";
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleVersion";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/action/PasteMvnDependencyPreProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "formatGradleDependency";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toGradleDependency";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "formatGradleDependency";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toGradleDependency";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "extractGradleDependency";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactId";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getGroupId";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getClassifier";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "firstOrEmpty";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "requiresAllDocumentsToBeCommitted";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5, 7, 8, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20 -> new IllegalArgumentException(string2);
        };
    }
}

