/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.build.BuildConsoleUtils;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.externalSystem.issue.quickfix.ReimportQuickFix;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.util.PlatformUtils;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.internal.jvm.UnsupportedJavaRuntimeException;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleSettingsQuickFix;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleVersionQuickFix;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleWrapperSettingsOpenQuickFix;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportMatrix;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016JD\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00130\u0012H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/gradle/issue/IncompatibleGradleJdkIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "Companion", "intellij.gradle.common"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nIncompatibleGradleJdkIssueChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncompatibleGradleJdkIssueChecker.kt\norg/jetbrains/plugins/gradle/issue/IncompatibleGradleJdkIssueChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,261:1\n1#2:262\n*E\n"})
public final class IncompatibleGradleJdkIssueChecker
implements GradleIssueChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String couldNotDetermineJavaUsingExecutablePrefix = "org.gradle.api.GradleException: Could not determine Java version using executable ";

    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        GradleVersion gradleVersion2;
        JavaVersion it;
        JavaVersion javaVersion;
        List quickFixes;
        boolean isUnsupportedJavaVersionForGradle;
        boolean unableToStartDaemonProcessForJDK11;
        boolean unableToStartDaemonProcessForJDK9;
        boolean isUnsupportedClassVersionErrorIssue;
        boolean isRemovedUnsafeDefineClassMethodInJDK11Issue;
        JavaVersion javaVersionUsed;
        boolean couldNotDetermineJavaIssue;
        GradleVersion gradleVersionUsed;
        Throwable rootCause;
        block28: {
            block27: {
                Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
                rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
                String rootCauseText = rootCause.toString();
                gradleVersionUsed = null;
                File buildEnvironmentJavaHome = null;
                if (issueData.getBuildEnvironment() != null) {
                    gradleVersionUsed = GradleVersion.version((String)issueData.getBuildEnvironment().getGradle().getGradleVersion());
                    buildEnvironmentJavaHome = issueData.getBuildEnvironment().getJava().getJavaHome();
                }
                Intrinsics.checkNotNullExpressionValue((Object)rootCause, (String)"rootCause");
                couldNotDetermineJavaIssue = IncompatibleGradleJdkIssueChecker.Companion.couldNotDetermineJavaIssue(rootCause, rootCauseText);
                boolean isUnsupportedJavaRuntimeIssue = Intrinsics.areEqual((Object)rootCause.getClass().getSimpleName(), (Object)UnsupportedJavaRuntimeException.class.getSimpleName()) || couldNotDetermineJavaIssue;
                javaVersionUsed = IncompatibleGradleJdkIssueChecker.Companion.detectJavaVersion(couldNotDetermineJavaIssue, rootCauseText, issueData, buildEnvironmentJavaHome);
                isRemovedUnsafeDefineClassMethodInJDK11Issue = IncompatibleGradleJdkIssueChecker.Companion.causedByUnsafeDefineClassApiUsage(gradleVersionUsed, javaVersionUsed, rootCause, rootCauseText);
                isUnsupportedClassVersionErrorIssue = Intrinsics.areEqual((Object)rootCause.getClass().getName(), (Object)UnsupportedClassVersionError.class.getName()) && javaVersionUsed != null && javaVersionUsed.feature < 7;
                unableToStartDaemonProcessForJDK9 = false;
                unableToStartDaemonProcessForJDK11 = false;
                if (!isRemovedUnsafeDefineClassMethodInJDK11Issue && StringsKt.startsWith$default((String)rootCauseText, (String)"org.gradle.api.GradleException: Unable to start the daemon process.", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)rootCauseText, (CharSequence)"FAILURE: Build failed with an exception.", (boolean)false, (int)2, null) && gradleVersionUsed != null && gradleVersionUsed.getBaseVersion().compareTo(GradleVersion.version((String)"4.6")) <= 0) {
                    if (gradleVersionUsed.getBaseVersion().compareTo(GradleVersion.version((String)"3.0")) < 0) {
                        unableToStartDaemonProcessForJDK9 = true;
                    } else {
                        unableToStartDaemonProcessForJDK11 = true;
                    }
                }
                boolean bl = isUnsupportedJavaVersionForGradle = javaVersionUsed != null && gradleVersionUsed != null && !GradleJvmSupportMatrix.Companion.isSupported(gradleVersionUsed, javaVersionUsed);
                if (!(isUnsupportedJavaVersionForGradle || isUnsupportedClassVersionErrorIssue || isUnsupportedJavaRuntimeIssue || isRemovedUnsafeDefineClassMethodInJDK11Issue || unableToStartDaemonProcessForJDK11 || unableToStartDaemonProcessForJDK9)) {
                    return null;
                }
                quickFixes = new ArrayList();
                javaVersion = javaVersionUsed;
                if (javaVersion == null) break block27;
                it = javaVersion;
                boolean bl2 = false;
                GradleVersion gradleVersion3 = GradleJvmSupportMatrix.Companion.suggestOldestSupportedGradleVersion(it);
                javaVersion = gradleVersion3;
                if (gradleVersion3 != null) break block28;
            }
            javaVersion = GradleJvmSupportMatrix.Companion.getOldestRecommendedGradleVersionByIdea();
        }
        JavaVersion oldestCompatibleGradleVersion = javaVersion;
        JavaVersion javaVersion2 = javaVersionUsed;
        if (javaVersion2 != null) {
            it = javaVersion2;
            boolean bl = false;
            gradleVersion2 = GradleJvmSupportMatrix.Companion.suggestLatestSupportedGradleVersion(it);
        } else {
            gradleVersion2 = null;
        }
        GradleVersion newestCompatibleGradleVersion = gradleVersion2;
        String versionSuggestion = IncompatibleGradleJdkIssueChecker.Companion.getSuggestedGradleVersion(newestCompatibleGradleVersion, (GradleVersion)oldestCompatibleGradleVersion);
        StringBuilder issueDescription = new StringBuilder();
        JavaVersion javaVersion3 = javaVersionUsed;
        Object incompatibleJavaVersion = javaVersion3 != null ? "Java " + javaVersion3 : "incompatible Java";
        if (couldNotDetermineJavaIssue || isRemovedUnsafeDefineClassMethodInJDK11Issue && newestCompatibleGradleVersion != null) {
            issueDescription.append("Unsupported Java. \n").append("Your build is currently configured to use " + (String)incompatibleJavaVersion + ". It's recommended to use Gradle " + versionSuggestion + ".");
        } else if (isUnsupportedClassVersionErrorIssue) {
            issueDescription.append("Unsupported Java. \n").append("Your build is currently configured to use " + (String)incompatibleJavaVersion + ". You need to use at least Java 7.");
        } else if (isUnsupportedJavaVersionForGradle) {
            StringBuilder stringBuilder = issueDescription.append("Unsupported Java. \n");
            GradleVersion gradleVersion4 = gradleVersionUsed;
            Intrinsics.checkNotNull((Object)gradleVersion4);
            stringBuilder.append("Your build is currently configured to use Java " + javaVersionUsed + " and Gradle " + gradleVersion4.getVersion() + ".");
        } else {
            issueDescription.append(rootCause.getMessage());
        }
        GradleVersion gradleVersion5 = gradleVersionUsed;
        String gradleVersionString = gradleVersion5 != null ? gradleVersion5.getVersion() : "version";
        if (isRemovedUnsafeDefineClassMethodInJDK11Issue) {
            issueDescription.append("\n\nThe project uses Gradle " + gradleVersionString + " which is incompatible with Java 11 or newer.\nSee details at https://github.com/gradle/gradle/issues/4860\n");
        } else if (unableToStartDaemonProcessForJDK9) {
            StringsKt.clear((StringBuilder)issueDescription).append("Unable to start the daemon process.").append("\n\nThe project uses Gradle " + gradleVersionString + " which is incompatible with Java 9 or newer.\n");
        } else if (unableToStartDaemonProcessForJDK11) {
            StringsKt.clear((StringBuilder)issueDescription).append("Unable to start the daemon process.").append("\n\nThe project uses Gradle " + gradleVersionString + " which is incompatible with Java 11 or newer.\n");
        } else {
            issueDescription.append("\n");
        }
        boolean isAndroidStudio = Intrinsics.areEqual((Object)"AndroidStudio", (Object)PlatformUtils.getPlatformPrefix());
        if (!isAndroidStudio || !isUnsupportedClassVersionErrorIssue) {
            issueDescription.append("\nPossible solution:\n");
        }
        if (!isAndroidStudio) {
            GradleSettingsQuickFix gradleSettingsFix = new GradleSettingsQuickFix(issueData.getProjectPath(), true, GradleSettingsQuickFix.GradleJvmChangeDetector.INSTANCE, GradleBundle.message("gradle.settings.text.jvm.path", new Object[0]));
            quickFixes.add(gradleSettingsFix);
            String suggestedJavaVersion = IncompatibleGradleJdkIssueChecker.Companion.getSuggestedJavaVersion(gradleVersionUsed, javaVersionUsed);
            issueDescription.append(" - Use Java " + suggestedJavaVersion + " as Gradle JVM: <a href=\"" + gradleSettingsFix.getId() + "\">Open Gradle settings</a> \n");
        }
        if (!isUnsupportedClassVersionErrorIssue) {
            Path wrapperPropertiesFile = GradleUtil.findDefaultWrapperPropertiesFile(issueData.getProjectPath());
            if (wrapperPropertiesFile == null || gradleVersionUsed != null && gradleVersionUsed.getBaseVersion().compareTo((GradleVersion)oldestCompatibleGradleVersion) < 0) {
                GradleVersionQuickFix gradleVersionFix = new GradleVersionQuickFix(issueData.getProjectPath(), (GradleVersion)oldestCompatibleGradleVersion, true);
                issueDescription.append(" - <a href=\"" + gradleVersionFix.getId() + "\">Upgrade Gradle wrapper to " + oldestCompatibleGradleVersion.getVersion() + " version and re-import the project</a>\n");
                quickFixes.add(gradleVersionFix);
            } else {
                GradleWrapperSettingsOpenQuickFix wrapperSettingsOpenQuickFix = new GradleWrapperSettingsOpenQuickFix(issueData.getProjectPath(), "distributionUrl");
                String string2 = issueData.getProjectPath();
                ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
                Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"SYSTEM_ID");
                ReimportQuickFix reimportQuickFix = new ReimportQuickFix(string2, projectSystemId);
                issueDescription.append(" - <a href=\"" + wrapperSettingsOpenQuickFix.getId() + "\">Open Gradle wrapper settings</a>, change `distributionUrl` property to use compatible Gradle version and <a href=\"" + reimportQuickFix.getId() + "\">reload the project</a>\n");
                quickFixes.add(wrapperSettingsOpenQuickFix);
                quickFixes.add(reimportQuickFix);
            }
        }
        String string3 = issueDescription.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"issueDescription.toString()");
        String description = string3;
        String string4 = BuildConsoleUtils.getMessageTitle((String)description);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getMessageTitle(description)");
        String title = string4;
        return new BuildIssue(title, description, quickFixes){
            @NotNull
            private final String title;
            @NotNull
            private final String description;
            @NotNull
            private final List<BuildIssueQuickFix> quickFixes;
            {
                this.title = $title;
                this.description = $description;
                this.quickFixes = $quickFixes;
            }

            @NotNull
            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public List<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return null;
            }
        };
    }

    @Override
    public boolean consumeBuildOutputFailureMessage(@NotNull String message, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return StringsKt.startsWith$default((String)failureCause, (String)"Could not create service of type ", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)failureCause, (CharSequence)" using BuildScopeServices.", (boolean)false, (int)2, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0002J,\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u001c\u0010\u0017\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/gradle/issue/IncompatibleGradleJdkIssueChecker$Companion;", "", "()V", "couldNotDetermineJavaUsingExecutablePrefix", "", "causedByUnsafeDefineClassApiUsage", "", "gradleVersionUsed", "Lorg/gradle/util/GradleVersion;", "javaVersion", "Lcom/intellij/util/lang/JavaVersion;", "rootCause", "", "rootCauseText", "couldNotDetermineJavaIssue", "detectJavaVersion", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "javaHome", "Ljava/io/File;", "getSuggestedGradleVersion", "newestCompatibleGradleVersion", "oldestCompatibleGradleVersion", "getSuggestedJavaVersion", "javaVersionUsed", "intellij.gradle.common"})
    @SourceDebugExtension(value={"SMAP\nIncompatibleGradleJdkIssueChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncompatibleGradleJdkIssueChecker.kt\norg/jetbrains/plugins/gradle/issue/IncompatibleGradleJdkIssueChecker$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,261:1\n1#2:262\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean couldNotDetermineJavaIssue(Throwable rootCause, String rootCauseText) {
            return StringsKt.startsWith$default((String)rootCauseText, (String)IncompatibleGradleJdkIssueChecker.couldNotDetermineJavaUsingExecutablePrefix, (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)rootCause.getMessage(), (Object)"Could not determine Java version.");
        }

        private final boolean causedByUnsafeDefineClassApiUsage(GradleVersion gradleVersionUsed, JavaVersion javaVersion, Throwable rootCause, String rootCauseText) {
            Object object;
            block9: {
                GradleVersion gradleVersion2 = gradleVersionUsed;
                Object object2 = gradleVersion2 != null ? gradleVersion2.getBaseVersion() : null;
                if (object2 == null) {
                    return false;
                }
                GradleVersion baseVersion = object2;
                if (baseVersion.compareTo(GradleVersion.version((String)"4.7")) > 0) {
                    return false;
                }
                if (StringsKt.startsWith$default((String)rootCauseText, (String)"java.lang.NoSuchMethodError: sun.misc.Unsafe.defineClass", (boolean)false, (int)2, null)) {
                    boolean bl;
                    JavaVersion javaVersion2 = javaVersion;
                    if (javaVersion2 != null) {
                        int it = javaVersion2.feature;
                        boolean bl2 = false;
                        bl = it >= 11;
                    } else {
                        bl = false;
                    }
                    if (bl) {
                        return true;
                    }
                }
                String string2 = rootCause.getMessage();
                if (string2 == null) {
                    return false;
                }
                String message = string2;
                if (!StringsKt.startsWith$default((String)message, (String)"'java.lang.Class sun.misc.Unsafe.defineClass", (boolean)false, (int)2, null)) {
                    return false;
                }
                StackTraceElement[] stackTraceElementArray = rootCause.getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"rootCause.stackTrace");
                for (Object object3 : (Object[])stackTraceElementArray) {
                    StackTraceElement it = (StackTraceElement)object3;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getClassName(), (Object)"org.gradle.internal.classloader.ClassLoaderUtils")) continue;
                    object = object3;
                    break block9;
                }
                object = null;
            }
            return object != null;
        }

        private final JavaVersion detectJavaVersion(boolean couldNotDetermineJavaIssue, String rootCauseText, GradleIssueData issueData, File javaHome) {
            Object object;
            if (couldNotDetermineJavaIssue) {
                File javaHomeCandidate;
                char[] cArray = new char[]{'.'};
                String javaExeCandidate = StringsKt.trimEnd((String)StringsKt.substringAfter$default((String)rootCauseText, (String)IncompatibleGradleJdkIssueChecker.couldNotDetermineJavaUsingExecutablePrefix, null, (int)2, null), (char[])cArray);
                File file = new File(javaExeCandidate).getParentFile();
                if (file == null || (file = file.getParentFile()) == null) {
                    file = javaHome;
                }
                File file2 = javaHomeCandidate = file;
                if (file2 != null) {
                    File it = file2;
                    boolean bl = false;
                    if (it.isDirectory()) {
                        JdkVersionDetector.JdkVersionInfo jdkVersionInfo = JdkVersionDetector.getInstance().detectJdkVersionInfo(it.getPath());
                        object = jdkVersionInfo != null ? jdkVersionInfo.version : null;
                    } else {
                        object = null;
                    }
                } else {
                    object = null;
                }
            } else {
                Object object2 = issueData.getBuildEnvironment();
                if (object2 != null && (object2 = object2.getJava()) != null && (object2 = object2.getJavaHome()) != null) {
                    Object it = object2;
                    boolean bl = false;
                    JdkVersionDetector.JdkVersionInfo jdkVersionInfo = JdkVersionDetector.getInstance().detectJdkVersionInfo(((File)it).getPath());
                    object = jdkVersionInfo != null ? jdkVersionInfo.version : null;
                } else {
                    object = null;
                }
            }
            return object;
        }

        private final String getSuggestedGradleVersion(GradleVersion newestCompatibleGradleVersion, GradleVersion oldestCompatibleGradleVersion) {
            return newestCompatibleGradleVersion != null && !Intrinsics.areEqual((Object)newestCompatibleGradleVersion, (Object)oldestCompatibleGradleVersion) ? (Intrinsics.areEqual((Object)GradleVersion.current(), (Object)newestCompatibleGradleVersion) ? oldestCompatibleGradleVersion.getVersion() + " or newer" : "version from range [" + oldestCompatibleGradleVersion.getVersion() + ", " + newestCompatibleGradleVersion.getVersion() + "]") : (Intrinsics.areEqual((Object)GradleVersion.current(), (Object)oldestCompatibleGradleVersion) && Intrinsics.areEqual((Object)oldestCompatibleGradleVersion, (Object)newestCompatibleGradleVersion) ? oldestCompatibleGradleVersion.getVersion() + " or newer" : oldestCompatibleGradleVersion.getVersion());
        }

        private final String getSuggestedJavaVersion(GradleVersion gradleVersionUsed, JavaVersion javaVersionUsed) {
            GradleVersion newestCompatibleJavaVersion;
            GradleVersion oldestCompatibleJavaVersion;
            String suggestedJavaVersion;
            block15: {
                GradleVersion gradleVersion2;
                block14: {
                    block13: {
                        GradleVersion gradleVersion3;
                        block12: {
                            suggestedJavaVersion = null;
                            gradleVersion3 = gradleVersionUsed;
                            if (gradleVersion3 == null) break block12;
                            GradleVersion it = gradleVersion3;
                            boolean bl = false;
                            JavaVersion javaVersion = GradleJvmSupportMatrix.Companion.suggestOldestSupportedJavaVersion(it);
                            gradleVersion3 = javaVersion;
                            if (javaVersion != null) break block13;
                        }
                        gradleVersion3 = oldestCompatibleJavaVersion = GradleJvmSupportMatrix.Companion.getOldestRecommendedJavaVersionByIdea();
                    }
                    if ((gradleVersion2 = gradleVersionUsed) == null) break block14;
                    GradleVersion it = gradleVersion2;
                    boolean bl = false;
                    JavaVersion javaVersion = GradleJvmSupportMatrix.Companion.suggestLatestSupportedJavaVersion(it);
                    gradleVersion2 = javaVersion;
                    if (javaVersion != null) break block15;
                }
                gradleVersion2 = newestCompatibleJavaVersion = GradleJvmSupportMatrix.Companion.getOldestRecommendedJavaVersionByIdea();
            }
            if (javaVersionUsed != null) {
                if (javaVersionUsed.compareTo((JavaVersion)oldestCompatibleJavaVersion) < 0) {
                    String string2 = oldestCompatibleJavaVersion.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"oldestCompatibleJavaVersion.toString()");
                    suggestedJavaVersion = string2;
                } else if (javaVersionUsed.compareTo((JavaVersion)newestCompatibleJavaVersion) > 0) {
                    String string3 = newestCompatibleJavaVersion.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"newestCompatibleJavaVersion.toString()");
                    suggestedJavaVersion = string3;
                } else {
                    String string4 = newestCompatibleJavaVersion.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"newestCompatibleJavaVersion.toString()");
                    suggestedJavaVersion = string4;
                }
            } else {
                String string5 = newestCompatibleJavaVersion.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"newestCompatibleJavaVersion.toString()");
                suggestedJavaVersion = string5;
            }
            return suggestedJavaVersion;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

