/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/InconsistentOperatorFromJavaCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "CONCURRENT_HASH_MAP_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend.java"})
public final class InconsistentOperatorFromJavaCallChecker
implements CallChecker {
    @NotNull
    public static final InconsistentOperatorFromJavaCallChecker INSTANCE = new InconsistentOperatorFromJavaCallChecker();
    @NotNull
    private static final FqName CONCURRENT_HASH_MAP_FQ_NAME = new FqName("java.util.concurrent.ConcurrentHashMap");

    private InconsistentOperatorFromJavaCallChecker() {
    }

    public void check(@NotNull ResolvedCall<?> resolvedCall, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CallableDescriptor candidateDescriptor = resolvedCall.getCandidateDescriptor();
        if (!Intrinsics.areEqual((Object)candidateDescriptor.getName(), (Object)OperatorNameConventions.CONTAINS)) {
            return;
        }
        List<ValueParameterDescriptor> list = candidateDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"candidateDescriptor.valueParameters");
        Annotated annotated = (ValueParameterDescriptor)CollectionsKt.singleOrNull(list);
        if (!(annotated != null && (annotated = annotated.getType()) != null ? TypeUtilsKt.isAnyOrNullableAny((KotlinType)annotated) : false)) {
            return;
        }
        if (!(resolvedCall.getCall().getCallElement() instanceof KtBinaryExpression) || !resolvedCall.getStatus().possibleTransformToSuccess()) {
            return;
        }
        for (CallableDescriptor callableDescriptor : DescriptorUtilsKt.overriddenTreeUniqueAsSequence(candidateDescriptor, false)) {
            ClassDescriptor containingClass;
            DeclarationDescriptor declarationDescriptor = callableDescriptor.getContainingDeclaration();
            ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
            if (classDescriptor == null || !Intrinsics.areEqual((Object)DescriptorUtilsKt.fqNameOrNull(containingClass = classDescriptor), (Object)CONCURRENT_HASH_MAP_FQ_NAME)) continue;
            context.getTrace().report((Diagnostic)ErrorsJvm.CONCURRENT_HASH_MAP_CONTAINS_OPERATOR.on(context.getLanguageVersionSettings(), reportOn));
            break;
        }
    }
}

