/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.text.lookup.AbstractStringLookup;
import org.apache.commons.text.lookup.IllegalArgumentExceptions;

final class UrlEncoderStringLookup
extends AbstractStringLookup {
    static final UrlEncoderStringLookup INSTANCE = new UrlEncoderStringLookup();

    UrlEncoderStringLookup() {
    }

    String encode(String key2, String enc) throws UnsupportedEncodingException {
        return URLEncoder.encode(key2, enc);
    }

    @Override
    public String lookup(String key2) {
        if (key2 == null) {
            return null;
        }
        String enc = StandardCharsets.UTF_8.name();
        try {
            return this.encode(key2, enc);
        }
        catch (UnsupportedEncodingException e) {
            throw IllegalArgumentExceptions.format(e, "%s: source=%s, encoding=%s", e, key2, enc);
        }
    }
}

