/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.fogbugz;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.PasswordUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.BaseRepositoryImpl;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import icons.TasksCoreIcons;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.apache.commons.httpclient.methods.PostMethod;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="FogBugz")
public final class FogBugzRepository
extends BaseRepositoryImpl {
    private static final Logger LOG = Logger.getInstance(FogBugzRepository.class);
    private String myToken;

    public FogBugzRepository(TaskRepositoryType type) {
        super(type);
        this.setUrl("https://example.fogbugz.com");
    }

    private FogBugzRepository(FogBugzRepository other) {
        super(other);
        this.myToken = other.myToken;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && Objects.equals(this.myToken, ((FogBugzRepository)((Object)o)).myToken);
    }

    public FogBugzRepository() {
    }

    public Task[] getIssues(@Nullable String query, int max, long since) throws Exception {
        return this.getCases(StringUtil.notNullize((String)query));
    }

    private Task[] getCases(String q) throws Exception {
        this.loginIfNeeded();
        PostMethod method = new PostMethod(this.getUrl() + "/api.asp");
        method.addParameter("token", this.myToken);
        method.addParameter("cmd", "search");
        method.addParameter("q", q);
        method.addParameter("cols", "sTitle,fOpen,dtOpened,dtLastUpdated,ixCategory");
        int status = this.getHttpClient().executeMethod(method);
        if (status != 200) {
            throw new Exception("Error listing cases: " + method.getStatusLine());
        }
        Document document = new SAXBuilder(false).build(method.getResponseBodyAsStream()).getDocument();
        List errorNodes = XPath.newInstance((String)"/response/error").selectNodes((Object)document);
        if (!errorNodes.isEmpty()) {
            throw new Exception("Error listing cases: " + ((Element)errorNodes.get(0)).getText());
        }
        XPath commentPath = XPath.newInstance((String)"events/event");
        List nodes = XPath.newInstance((String)"/response/cases/case").selectNodes((Object)document);
        List tasks = ContainerUtil.mapNotNull((Collection)nodes, (Function)((NotNullFunction)element -> this.createCase((Element)element, commentPath)));
        return tasks.toArray(Task.EMPTY_ARRAY);
    }

    private static TaskType getType(Element element) {
        String category = element.getChildText("ixCategory");
        if ("1".equals(category)) {
            return TaskType.BUG;
        }
        if ("2".equals(category)) {
            return TaskType.FEATURE;
        }
        return TaskType.OTHER;
    }

    @NotNull
    private Task createCase(final Element element, final XPath commentPath) {
        final String id = element.getAttributeValue("ixBug");
        final String title = element.getChildTextTrim("sTitle");
        final TaskType type = FogBugzRepository.getType(element);
        return new Task(){

            @NotNull
            public String getId() {
                String string = id;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getSummary() {
                String string = title;
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Nullable
            public String getDescription() {
                return null;
            }

            public Comment @NotNull [] getComments() {
                List nodes;
                try {
                    nodes = commentPath.selectNodes((Object)element);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error selecting comment nodes", e);
                }
                List comments = ContainerUtil.mapNotNull((Collection)nodes, (Function)new NotNullFunction<Element, Comment>(){

                    @NotNull
                    public Comment fun(Element element) {
                        Comment comment = this.createComment(element);
                        if (comment == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return comment;
                    }

                    private Comment createComment(final Element element) {
                        return new Comment(){

                            public String getText() {
                                return element.getChildTextTrim("s");
                            }

                            @Nullable
                            public String getAuthor() {
                                return element.getChildTextTrim("sPerson");
                            }

                            @NotNull
                            public Date getDate() {
                                Date date = FogBugzRepository.parseDate(element.getChildTextTrim("dt"));
                                if (date == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                return date;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/fogbugz/FogBugzRepository$1$1$1", "getDate"));
                            }
                        };
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/fogbugz/FogBugzRepository$1$1", "fun"));
                    }
                });
                Comment[] commentArray = comments.toArray(Comment.EMPTY_ARRAY);
                if (commentArray == null) {
                    1.$$$reportNull$$$0(2);
                }
                return commentArray;
            }

            @NotNull
            public Icon getIcon() {
                Icon icon = TasksCoreIcons.Fogbugz;
                if (icon == null) {
                    1.$$$reportNull$$$0(3);
                }
                return icon;
            }

            @NotNull
            public TaskType getType() {
                TaskType taskType = type;
                if (taskType == null) {
                    1.$$$reportNull$$$0(4);
                }
                return taskType;
            }

            @NotNull
            public Date getUpdated() {
                Date date = FogBugzRepository.parseDate(element.getChildText("dtLastUpdated"));
                if (date == null) {
                    1.$$$reportNull$$$0(5);
                }
                return date;
            }

            @NotNull
            public Date getCreated() {
                Date date = FogBugzRepository.parseDate(element.getChildTextTrim("dtOpened"));
                if (date == null) {
                    1.$$$reportNull$$$0(6);
                }
                return date;
            }

            public boolean isClosed() {
                return !Boolean.parseBoolean(element.getChildTextTrim("fOpen"));
            }

            public boolean isIssue() {
                return true;
            }

            @NotNull
            public String getIssueUrl() {
                String string = FogBugzRepository.this.getUrl() + "/default.asp?" + this.getId();
                if (string == null) {
                    1.$$$reportNull$$$0(7);
                }
                return string;
            }

            @NotNull
            public TaskRepository getRepository() {
                FogBugzRepository fogBugzRepository = FogBugzRepository.this;
                if (fogBugzRepository == null) {
                    1.$$$reportNull$$$0(8);
                }
                return fogBugzRepository;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/tasks/fogbugz/FogBugzRepository$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSummary";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getComments";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIcon";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getType";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUpdated";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCreated";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIssueUrl";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRepository";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @Nullable
    public Task findTask(@NotNull String id) throws Exception {
        if (id == null) {
            FogBugzRepository.$$$reportNull$$$0(0);
        }
        Task[] tasks = this.getCases(id);
        return switch (tasks.length) {
            case 0 -> null;
            case 1 -> tasks[0];
            default -> {
                LOG.warn("Expected unique case for case id: " + id + ", got " + tasks.length + " instead. Using the first one.");
                yield tasks[0];
            }
        };
    }

    @Override
    @NotNull
    public BaseRepository clone() {
        return new FogBugzRepository(this);
    }

    private void loginIfNeeded() throws Exception {
        if (StringUtil.isEmpty((String)this.myToken)) {
            this.login(this.getLoginMethod());
        }
    }

    private void login(@NotNull PostMethod method) throws Exception {
        if (method == null) {
            FogBugzRepository.$$$reportNull$$$0(1);
        }
        LOG.debug("Requesting new token");
        int status = this.getHttpClient().executeMethod(method);
        if (status != 200) {
            throw new Exception("Error logging in: " + method.getStatusLine());
        }
        Document document = new SAXBuilder(false).build(method.getResponseBodyAsStream()).getDocument();
        XPath path = XPath.newInstance((String)"/response/token");
        Element result = (Element)path.selectSingleNode((Object)document);
        if (result == null) {
            Element error = (Element)XPath.newInstance((String)"/response/error").selectSingleNode((Object)document);
            throw new Exception(error == null ? "Error logging in" : error.getText());
        }
        this.myToken = result.getTextTrim();
    }

    @NotNull
    private PostMethod getLoginMethod() {
        PostMethod method = new PostMethod(this.getUrl() + "/api.asp");
        method.addParameter("cmd", "logon");
        method.addParameter("email", this.getUsername());
        method.addParameter("password", this.getPassword());
        PostMethod postMethod = method;
        if (postMethod == null) {
            FogBugzRepository.$$$reportNull$$$0(2);
        }
        return postMethod;
    }

    @NotNull
    private PostMethod getLogoutMethod() {
        PostMethod method = new PostMethod(this.getUrl() + "/api.asp");
        method.addParameter("cmd", "logoff");
        assert (this.myToken != null);
        method.addParameter("token", this.myToken);
        PostMethod postMethod = method;
        if (postMethod == null) {
            FogBugzRepository.$$$reportNull$$$0(3);
        }
        return postMethod;
    }

    @Nullable
    public TaskRepository.CancellableConnection createCancellableConnection() {
        return new TaskRepository.CancellableConnection(){
            PostMethod myMethod;

            protected void doTest() throws Exception {
                if (StringUtil.isNotEmpty((String)FogBugzRepository.this.myToken)) {
                    this.myMethod = FogBugzRepository.this.getLogoutMethod();
                    LOG.debug("Revoking previously used token");
                    FogBugzRepository.this.getHttpClient().executeMethod(this.myMethod);
                }
                this.myMethod = FogBugzRepository.this.getLoginMethod();
                FogBugzRepository.this.login(this.myMethod);
            }

            public void cancel() {
                if (this.myMethod != null) {
                    this.myMethod.abort();
                }
            }
        };
    }

    @NotNull
    private static Date parseDate(@NotNull String string) {
        Date date;
        if (string == null) {
            FogBugzRepository.$$$reportNull$$$0(4);
        }
        try {
            date = DatatypeFactory.newInstance().newXMLGregorianCalendar(string).toGregorianCalendar().getTime();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException("Error configuring datatype factory", e);
        }
        if (date == null) {
            FogBugzRepository.$$$reportNull$$$0(5);
        }
        return date;
    }

    public String getComment() {
        return "{id} (e.g. 2344245), {summary}";
    }

    @Tag(value="token")
    @NotNull
    public String getEncodedToken() {
        String string = PasswordUtil.encodePassword((String)this.myToken);
        if (string == null) {
            FogBugzRepository.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void setEncodedToken(@Nullable String token) {
        try {
            this.myToken = PasswordUtil.decodePassword((String)token);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/fogbugz/FogBugzRepository";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/fogbugz/FogBugzRepository";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoginMethod";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogoutMethod";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEncodedToken";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findTask";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "login";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseDate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

