/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.cms;

import java.io.IOException;
import org.gradle.internal.impldep.org.bouncycastle.asn1.cms.KEKIdentifier;
import org.gradle.internal.impldep.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.gradle.internal.impldep.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.gradle.internal.impldep.org.bouncycastle.cms.AuthAttributesProvider;
import org.gradle.internal.impldep.org.bouncycastle.cms.CMSException;
import org.gradle.internal.impldep.org.bouncycastle.cms.CMSSecureReadable;
import org.gradle.internal.impldep.org.bouncycastle.cms.KEKRecipient;
import org.gradle.internal.impldep.org.bouncycastle.cms.KEKRecipientId;
import org.gradle.internal.impldep.org.bouncycastle.cms.Recipient;
import org.gradle.internal.impldep.org.bouncycastle.cms.RecipientInformation;
import org.gradle.internal.impldep.org.bouncycastle.cms.RecipientOperator;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo kEKRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(kEKRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = kEKRecipientInfo;
        KEKIdentifier kEKIdentifier = kEKRecipientInfo.getKekid();
        this.rid = new KEKRecipientId(kEKIdentifier.getKeyIdentifier().getOctets());
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

