/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.search.AnnotatedElementsSearcher;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnnotatedMemberIndex;

public class AnnotatedMembersSearcher
implements QueryExecutor<PsiModifierListOwner, AnnotatedElementsSearch.Parameters> {
    @NotNull
    private static List<PsiModifierListOwner> getAnnotatedMemberCandidates(PsiClass clazz, GlobalSearchScope scope) {
        String name = (String)ReadAction.compute(() -> clazz.getName());
        if (name == null) {
            List<PsiModifierListOwner> list = Collections.emptyList();
            if (list == null) {
                AnnotatedMembersSearcher.$$$reportNull$$$0(0);
            }
            return list;
        }
        Collection members = (Collection)ReadAction.compute(() -> StubIndex.getElements(GrAnnotatedMemberIndex.KEY, (Object)name, (Project)clazz.getProject(), (GlobalSearchScope)scope, PsiElement.class));
        if (members.isEmpty()) {
            List<PsiModifierListOwner> list = Collections.emptyList();
            if (list == null) {
                AnnotatedMembersSearcher.$$$reportNull$$$0(1);
            }
            return list;
        }
        ArrayList<PsiModifierListOwner> result2 = new ArrayList<PsiModifierListOwner>();
        for (PsiElement element : members) {
            ApplicationManager.getApplication().runReadAction(() -> {
                PsiElement e;
                PsiElement psiElement = e = element instanceof GroovyFile ? ((GroovyFile)element).getPackageDefinition() : element;
                if (e instanceof PsiModifierListOwner) {
                    result2.add((PsiModifierListOwner)e);
                }
            });
        }
        ArrayList<PsiModifierListOwner> arrayList = result2;
        if (arrayList == null) {
            AnnotatedMembersSearcher.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public boolean execute(@NotNull AnnotatedElementsSearch.Parameters p, @NotNull Processor<? super PsiModifierListOwner> consumer) {
        List<Object> candidates;
        if (p == null) {
            AnnotatedMembersSearcher.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            AnnotatedMembersSearcher.$$$reportNull$$$0(4);
        }
        PsiClass annClass = p.getAnnotationClass();
        assert (annClass.isAnnotationType()) : "Annotation type should be passed to annotated members search";
        String annotationFQN = (String)ReadAction.compute(() -> annClass.getQualifiedName());
        assert (annotationFQN != null);
        SearchScope scope = p.getScope();
        if (scope instanceof GlobalSearchScope) {
            candidates = AnnotatedMembersSearcher.getAnnotatedMemberCandidates(annClass, (GlobalSearchScope)scope);
        } else {
            candidates = new ArrayList();
            for (PsiElement element : ((LocalSearchScope)scope).getScope()) {
                ApplicationManager.getApplication().runReadAction(() -> {
                    if (element instanceof GroovyPsiElement) {
                        ((GroovyPsiElement)element).accept(new GroovyRecursiveElementVisitor(){

                            @Override
                            public void visitMethod(@NotNull GrMethod method) {
                                if (method == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                candidates.add(method);
                            }

                            @Override
                            public void visitField(@NotNull GrField field) {
                                if (field == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                candidates.add(field);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2;
                                Object[] objectArray3 = new Object[3];
                                switch (n) {
                                    default: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "method";
                                        break;
                                    }
                                    case 1: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "field";
                                        break;
                                    }
                                }
                                objectArray2[1] = "org/jetbrains/plugins/groovy/findUsages/AnnotatedMembersSearcher$1";
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "visitMethod";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "visitField";
                                        break;
                                    }
                                }
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        });
                    }
                });
            }
        }
        for (PsiModifierListOwner psiModifierListOwner : candidates) {
            boolean accepted = (Boolean)ReadAction.compute(() -> {
                PsiModifierList list;
                if (AnnotatedElementsSearcher.isInstanceof((PsiElement)candidate, (Class[])p.getTypes()) && (list = candidate.getModifierList()) instanceof GrModifierList) {
                    for (GrAnnotation annotation : ((GrModifierList)list).getRawAnnotations()) {
                        if (!p.isApproximate() && !annotation.hasQualifiedName(annotationFQN) || consumer.process((Object)candidate)) continue;
                        return false;
                    }
                }
                return true;
            });
            if (accepted) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/findUsages/AnnotatedMembersSearcher";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotatedMemberCandidates";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/findUsages/AnnotatedMembersSearcher";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

