/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.conversions.ConvertIntegerToDecimalPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class ConvertIntegerToDecimalIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new ConvertIntegerToDecimalPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        BigInteger val;
        int textLength;
        GrLiteral exp;
        String textString;
        char lastChar;
        boolean isLong;
        if (element == null) {
            ConvertIntegerToDecimalIntention.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ConvertIntegerToDecimalIntention.$$$reportNull$$$0(1);
        }
        boolean bl = isLong = (lastChar = (textString = (exp = (GrLiteral)element).getText().replaceAll("_", "")).charAt((textLength = textString.length()) - 1)) == 'l' || lastChar == 'L';
        if (isLong) {
            textString = textString.substring(0, textLength - 1);
        }
        if (textString.startsWith("0x") || textString.startsWith("0X")) {
            rawIntString = textString.substring(2);
            val = new BigInteger(rawIntString, 16);
        } else if (textString.startsWith("0b") || textString.startsWith("0B")) {
            String rawString = textString.substring(2);
            val = new BigInteger(rawString, 2);
        } else {
            rawIntString = textString.substring(1);
            val = new BigInteger(rawIntString, 8);
        }
        Object decimalString = val.toString(10);
        if (isLong) {
            decimalString = (String)decimalString + "L";
        }
        PsiImplUtil.replaceExpression((String)decimalString, exp);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/intentions/conversions/ConvertIntegerToDecimalIntention";
        objectArray[2] = "processIntention";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

