/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrIfStatementImpl
extends GroovyPsiElementImpl
implements GrIfStatement {
    public GrIfStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrIfStatementImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    public void accept(@NotNull GroovyElementVisitor visitor2) {
        if (visitor2 == null) {
            GrIfStatementImpl.$$$reportNull$$$0(1);
        }
        visitor2.visitIfStatement(this);
    }

    public String toString() {
        return "IF statement";
    }

    @Override
    @Nullable
    public GrExpression getCondition() {
        PsiElement lParenth = this.getLParenth();
        if (lParenth == null) {
            return null;
        }
        PsiElement afterLParenth = PsiUtil.skipWhitespacesAndComments(lParenth.getNextSibling(), true);
        if (afterLParenth instanceof GrExpression) {
            return (GrExpression)afterLParenth;
        }
        return null;
    }

    @Override
    @Nullable
    public GrStatement getThenBranch() {
        ArrayList<GrStatement> statements2 = new ArrayList<GrStatement>();
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!(cur instanceof GrStatement)) continue;
            statements2.add((GrStatement)cur);
        }
        if (this.getCondition() == null && !statements2.isEmpty()) {
            return (GrStatement)statements2.get(0);
        }
        if (statements2.size() > 1) {
            return (GrStatement)statements2.get(1);
        }
        return null;
    }

    @Override
    @Nullable
    public GrStatement getElseBranch() {
        ArrayList<GrStatement> statements2 = new ArrayList<GrStatement>();
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!(cur instanceof GrStatement)) continue;
            statements2.add((GrStatement)cur);
        }
        if (statements2.size() == 3) {
            return (GrStatement)statements2.get(2);
        }
        return null;
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        PsiElement elseKeywordElement;
        GrStatement elseBranch;
        if (child == null) {
            GrIfStatementImpl.$$$reportNull$$$0(2);
        }
        if ((elseBranch = this.getElseBranch()) != null && child == elseBranch.getNode() && (elseKeywordElement = this.findChildByType(GroovyTokenTypes.kELSE)) != null) {
            super.deleteChildInternal(elseKeywordElement.getNode());
        }
        super.deleteChildInternal(child);
    }

    @Override
    @NotNull
    public <T extends GrStatement> T replaceThenBranch(@NotNull T newBranch) throws IncorrectOperationException {
        if (newBranch == null) {
            GrIfStatementImpl.$$$reportNull$$$0(3);
        }
        T t = PsiImplUtil.replaceBody(newBranch, this.getThenBranch(), this.getNode(), this.getProject());
        if (t == null) {
            GrIfStatementImpl.$$$reportNull$$$0(4);
        }
        return t;
    }

    @Override
    @NotNull
    public <T extends GrStatement> T replaceElseBranch(@NotNull T newBranch) throws IncorrectOperationException {
        if (newBranch == null) {
            GrIfStatementImpl.$$$reportNull$$$0(5);
        }
        T t = PsiImplUtil.replaceBody(newBranch, this.getElseBranch(), this.getNode(), this.getProject());
        if (t == null) {
            GrIfStatementImpl.$$$reportNull$$$0(6);
        }
        return t;
    }

    @Override
    public PsiElement getElseKeyword() {
        return this.findChildByType(GroovyTokenTypes.kELSE);
    }

    @Override
    public PsiElement getRParenth() {
        return this.findChildByType(GroovyTokenTypes.mRPAREN);
    }

    @Override
    public PsiElement getLParenth() {
        return this.findChildByType(GroovyTokenTypes.mLPAREN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newBranch";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrIfStatementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrIfStatementImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceThenBranch";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceElseBranch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "replaceThenBranch";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replaceElseBranch";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6 -> new IllegalStateException(string);
        };
    }
}

