/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.util.Consumer;
import com.intellij.util.ReflectionUtilRt;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.gradle.api.Action;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.UnknownModelException;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.adapter.TargetTypeProvider;
import org.gradle.tooling.internal.gradle.DefaultBuildIdentifier;
import org.gradle.tooling.internal.gradle.DefaultProjectIdentifier;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.BuildModel;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.ProjectIdentifier;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.build.JavaEnvironment;
import org.gradle.tooling.model.gradle.BasicGradleProject;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.Build;
import org.jetbrains.plugins.gradle.model.LegacyIdeaProjectModelAdapter;
import org.jetbrains.plugins.gradle.model.ModelsHolder;
import org.jetbrains.plugins.gradle.model.Project;
import org.jetbrains.plugins.gradle.model.ProjectImportModelProvider;
import org.jetbrains.plugins.gradle.model.internal.TurnOffDefaultTasks;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalBuildIdentifier;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalJavaEnvironment;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.Supplier;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.build.InternalBuildEnvironment;

public class ProjectImportAction
implements BuildAction<AllModels>,
Serializable {
    private static final ModelConverter NOOP_CONVERTER = new NoopConverter();
    public static final String IDEA_BACKGROUND_CONVERT = "idea.background.convert";
    public static final String IDEA_MODELS_PARALLEL_FETCH = "idea.models.parallel.fetch";
    private final Set<ProjectImportModelProvider> myProjectsLoadedModelProviders = new LinkedHashSet<ProjectImportModelProvider>();
    private final Set<ProjectImportModelProvider> myBuildFinishedModelProviders = new LinkedHashSet<ProjectImportModelProvider>();
    private final Set<Class<?>> myTargetTypes = new LinkedHashSet();
    private final boolean myIsPreviewMode;
    private final boolean myIsCompositeBuildsSupported;
    private boolean myUseProjectsLoadedPhase;
    private boolean myParallelModelsFetch;
    private AllModels myAllModels = null;
    @Nullable
    private transient GradleBuild myGradleBuild;
    private transient ExecutorService myConverterExecutor;
    private ModelConverter myModelConverter;

    public ProjectImportAction(boolean isPreviewMode, boolean isCompositeBuildsSupported) {
        this.myIsPreviewMode = isPreviewMode;
        this.myIsCompositeBuildsSupported = isCompositeBuildsSupported;
    }

    public void addProjectImportModelProvider(@NotNull ProjectImportModelProvider provider) {
        if (provider == null) {
            ProjectImportAction.$$$reportNull$$$0(0);
        }
        this.addProjectImportModelProvider(provider, false);
    }

    public void addProjectImportModelProvider(@NotNull ProjectImportModelProvider provider, boolean isProjectLoadedProvider) {
        if (provider == null) {
            ProjectImportAction.$$$reportNull$$$0(1);
        }
        if (isProjectLoadedProvider) {
            this.myProjectsLoadedModelProviders.add(provider);
        } else {
            this.myBuildFinishedModelProviders.add(provider);
        }
    }

    @ApiStatus.Internal
    public Set<Class<?>> getModelProvidersClasses() {
        LinkedHashSet result = new LinkedHashSet();
        for (ProjectImportModelProvider provider : this.myProjectsLoadedModelProviders) {
            result.add(provider.getClass());
        }
        for (ProjectImportModelProvider provider : this.myBuildFinishedModelProviders) {
            result.add(provider.getClass());
        }
        return result;
    }

    public void addTargetTypes(@NotNull Set<Class<?>> targetTypes) {
        if (targetTypes == null) {
            ProjectImportAction.$$$reportNull$$$0(2);
        }
        this.myTargetTypes.addAll(targetTypes);
    }

    public void prepareForPhasedExecuter() {
        this.myUseProjectsLoadedPhase = true;
    }

    public void prepareForNonPhasedExecuter() {
        this.myUseProjectsLoadedPhase = false;
    }

    @NotNull
    protected ModelConverter getToolingModelConverter(@NotNull BuildController controller) {
        if (controller == null) {
            ProjectImportAction.$$$reportNull$$$0(3);
        }
        ModelConverter modelConverter = NOOP_CONVERTER;
        if (modelConverter == null) {
            ProjectImportAction.$$$reportNull$$$0(4);
        }
        return modelConverter;
    }

    @Nullable
    public AllModels execute(BuildController controller) {
        boolean isProjectsLoadedAction;
        if (System.getProperties().containsKey(IDEA_MODELS_PARALLEL_FETCH)) {
            this.myParallelModelsFetch = Boolean.getBoolean(IDEA_MODELS_PARALLEL_FETCH);
        }
        if (!System.getProperties().containsKey(IDEA_BACKGROUND_CONVERT) || Boolean.getBoolean(IDEA_BACKGROUND_CONVERT)) {
            this.myConverterExecutor = Executors.newSingleThreadExecutor(new SimpleThreadFactory());
        }
        this.configureAdditionalTypes(controller);
        boolean bl = isProjectsLoadedAction = this.myAllModels == null && this.myUseProjectsLoadedPhase;
        if (isProjectsLoadedAction || !this.myUseProjectsLoadedPhase) {
            long startTime = System.currentTimeMillis();
            this.myGradleBuild = controller.getBuildModel();
            Build mainBuild = ProjectImportAction.convert(this.myGradleBuild);
            AllModels allModels = new AllModels(mainBuild);
            allModels.logPerformance("Get model GradleBuild", System.currentTimeMillis() - startTime);
            long startTimeBuildEnv = System.currentTimeMillis();
            BuildEnvironment buildEnvironment = (BuildEnvironment)controller.findModel(BuildEnvironment.class);
            allModels.setBuildEnvironment(ProjectImportAction.convert(buildEnvironment));
            allModels.logPerformance("Get model BuildEnvironment", System.currentTimeMillis() - startTimeBuildEnv);
            this.myAllModels = allModels;
            this.myModelConverter = this.getToolingModelConverter(controller);
        }
        assert (this.myGradleBuild != null);
        assert (this.myModelConverter != null);
        Set<GradleBuild> nestedBuilds = this.getNestedBuilds(this.myGradleBuild, controller);
        MyBuildController wrappedController = new MyBuildController(controller, this.myGradleBuild);
        this.fetchProjectBuildModels(wrappedController, isProjectsLoadedAction, this.myGradleBuild);
        this.addBuildModels(wrappedController, this.myAllModels, this.myGradleBuild, isProjectsLoadedAction);
        for (GradleBuild includedBuild : nestedBuilds) {
            if (!isProjectsLoadedAction) {
                this.myAllModels.getIncludedBuilds().add(ProjectImportAction.convert(includedBuild));
            }
            this.fetchProjectBuildModels(wrappedController, isProjectsLoadedAction, includedBuild);
            this.addBuildModels(wrappedController, this.myAllModels, includedBuild, isProjectsLoadedAction);
        }
        ProjectImportAction.setupIncludedBuildsHierarchy(this.myAllModels.getIncludedBuilds(), nestedBuilds);
        if (isProjectsLoadedAction) {
            wrappedController.getModel(TurnOffDefaultTasks.class);
        }
        if (this.myConverterExecutor != null) {
            this.myConverterExecutor.shutdown();
            try {
                this.myConverterExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return isProjectsLoadedAction && !this.myAllModels.hasModels() ? null : this.myAllModels;
    }

    private static void setupIncludedBuildsHierarchy(List<Build> builds, Set<GradleBuild> gradleBuilds) {
        HashSet<Build> updatedBuilds = new HashSet<Build>();
        HashMap<File, Build> rootDirsToBuilds = new HashMap<File, Build>();
        for (Build build : builds) {
            rootDirsToBuilds.put(build.getBuildIdentifier().getRootDir(), build);
        }
        for (GradleBuild gradleBuild : gradleBuilds) {
            Build build = (Build)rootDirsToBuilds.get(gradleBuild.getBuildIdentifier().getRootDir());
            if (build == null) continue;
            for (GradleBuild includedGradleBuild : gradleBuild.getIncludedBuilds()) {
                Build buildToUpdate = (Build)rootDirsToBuilds.get(includedGradleBuild.getBuildIdentifier().getRootDir());
                if (!(buildToUpdate instanceof DefaultBuild) || !updatedBuilds.add(buildToUpdate)) continue;
                ((DefaultBuild)buildToUpdate).setParentBuildIdentifier(new DefaultBuildIdentifier(gradleBuild.getBuildIdentifier().getRootDir()));
            }
        }
    }

    @ApiStatus.Internal
    public void setParallelModelsFetch(boolean parallelModelsFetch) {
        this.myParallelModelsFetch = parallelModelsFetch;
    }

    @Contract(value="null -> null")
    private static BuildEnvironment convert(final @Nullable BuildEnvironment buildEnvironment) {
        if (buildEnvironment == null) {
            return null;
        }
        return buildEnvironment instanceof InternalBuildEnvironment ? buildEnvironment : new InternalBuildEnvironment(new Supplier<InternalBuildIdentifier>(){

            @Override
            public InternalBuildIdentifier get() {
                return new InternalBuildIdentifier(buildEnvironment.getBuildIdentifier().getRootDir());
            }
        }, new Supplier<InternalJavaEnvironment>(){

            @Override
            public InternalJavaEnvironment get() {
                JavaEnvironment java = buildEnvironment.getJava();
                return new InternalJavaEnvironment(java.getJavaHome(), java.getJvmArguments());
            }
        }, new Supplier<File>(){

            @Override
            public File get() {
                return buildEnvironment.getGradle().getGradleUserHome();
            }
        }, buildEnvironment.getGradle().getGradleVersion());
    }

    private Set<GradleBuild> getNestedBuilds(@NotNull GradleBuild rootBuild, BuildController controller) {
        if (rootBuild == null) {
            ProjectImportAction.$$$reportNull$$$0(5);
        }
        BuildEnvironment environment = (BuildEnvironment)controller.getModel(BuildEnvironment.class);
        GradleVersion envGradleVersion = null;
        if (environment != null) {
            envGradleVersion = GradleVersion.version((String)environment.getGradle().getGradleVersion());
        }
        if (!this.myIsCompositeBuildsSupported) {
            return Collections.emptySet();
        }
        HashSet<String> processedBuildsPaths = new HashSet<String>();
        LinkedHashSet<GradleBuild> nestedBuilds = new LinkedHashSet<GradleBuild>();
        String rootBuildPath = rootBuild.getBuildIdentifier().getRootDir().getPath();
        processedBuildsPaths.add(rootBuildPath);
        ArrayDeque<? extends GradleBuild> queue = new ArrayDeque<GradleBuild>((Collection<? extends GradleBuild>)ProjectImportAction.getEditableBuilds(rootBuild, envGradleVersion));
        while (!queue.isEmpty()) {
            GradleBuild includedBuild = (GradleBuild)queue.remove();
            String includedBuildPath = includedBuild.getBuildIdentifier().getRootDir().getPath();
            if (!processedBuildsPaths.add(includedBuildPath)) continue;
            nestedBuilds.add(includedBuild);
            queue.addAll((Collection<? extends GradleBuild>)ProjectImportAction.getEditableBuilds(includedBuild, envGradleVersion));
        }
        return nestedBuilds;
    }

    private static DomainObjectSet<? extends GradleBuild> getEditableBuilds(@NotNull GradleBuild rootBuild, @Nullable GradleVersion version) {
        if (rootBuild == null) {
            ProjectImportAction.$$$reportNull$$$0(6);
        }
        if (version != null && version.compareTo(GradleVersion.version((String)"8.0")) >= 0) {
            DomainObjectSet builds = rootBuild.getEditableBuilds();
            if (builds.isEmpty()) {
                return rootBuild.getIncludedBuilds();
            }
            return builds;
        }
        return rootBuild.getIncludedBuilds();
    }

    private void fetchProjectBuildModels(BuildController controller, final boolean isProjectsLoadedAction, GradleBuild build) {
        ArrayList<4> buildActions = new ArrayList<4>();
        for (final BasicGradleProject gradleProject : build.getProjects()) {
            buildActions.add(new BuildAction<List<Runnable>>(){

                public List<Runnable> execute(BuildController controller) {
                    return ProjectImportAction.this.getProjectModels(controller, ProjectImportAction.this.myAllModels, gradleProject, isProjectsLoadedAction);
                }
            });
        }
        ArrayList<List> addFetchedModelActions = new ArrayList<List>(buildActions.size());
        if (this.myParallelModelsFetch) {
            addFetchedModelActions.addAll(controller.run(buildActions));
        } else {
            for (BuildAction buildAction : buildActions) {
                addFetchedModelActions.add((List)buildAction.execute(controller));
            }
        }
        for (List list : addFetchedModelActions) {
            for (Runnable action : list) {
                action.run();
            }
        }
    }

    @NotNull
    private static Build convert(@NotNull GradleBuild build) {
        if (build == null) {
            ProjectImportAction.$$$reportNull$$$0(7);
        }
        DefaultBuild rootProject = new DefaultBuild(build.getRootProject().getName(), build.getBuildIdentifier().getRootDir());
        for (BasicGradleProject project : build.getProjects()) {
            rootProject.addProject(project.getName(), project.getProjectIdentifier());
        }
        DefaultBuild defaultBuild = rootProject;
        if (defaultBuild == null) {
            ProjectImportAction.$$$reportNull$$$0(8);
        }
        return defaultBuild;
    }

    private void configureAdditionalTypes(BuildController controller) {
        if (this.myTargetTypes.isEmpty()) {
            return;
        }
        try {
            ProtocolToModelAdapter modelAdapter = (ProtocolToModelAdapter)ReflectionUtilRt.getField(controller.getClass(), (Object)controller, ProtocolToModelAdapter.class, (String)"adapter");
            if (modelAdapter == null) {
                return;
            }
            TargetTypeProvider typeProvider = (TargetTypeProvider)ReflectionUtilRt.getField(ProtocolToModelAdapter.class, (Object)modelAdapter, TargetTypeProvider.class, (String)"targetTypeProvider");
            if (typeProvider == null) {
                return;
            }
            Map targetTypes = (Map)ReflectionUtilRt.getField(typeProvider.getClass(), (Object)typeProvider, Map.class, (String)"configuredTargetTypes");
            if (targetTypes == null) {
                return;
            }
            for (Class<?> targetType : this.myTargetTypes) {
                targetTypes.put(targetType.getCanonicalName(), targetType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List<Runnable> getProjectModels(@NotNull BuildController controller, final @NotNull AllModels allModels, final @NotNull BasicGradleProject project, boolean isProjectsLoadedAction) {
        if (controller == null) {
            ProjectImportAction.$$$reportNull$$$0(9);
        }
        if (allModels == null) {
            ProjectImportAction.$$$reportNull$$$0(10);
        }
        if (project == null) {
            ProjectImportAction.$$$reportNull$$$0(11);
        }
        try {
            final ArrayList<Runnable> result = new ArrayList<Runnable>();
            Set<ProjectImportModelProvider> modelProviders = this.getModelProviders(isProjectsLoadedAction);
            for (ProjectImportModelProvider extension : modelProviders) {
                final HashSet<String> obtainedModels = new HashSet<String>();
                long startTime = System.currentTimeMillis();
                ProjectImportModelProvider.ProjectModelConsumer modelConsumer = new ProjectImportModelProvider.ProjectModelConsumer(){

                    @Override
                    public void consume(final @NotNull Object object, final @NotNull Class clazz) {
                        if (object == null) {
                            5.$$$reportNull$$$0(0);
                        }
                        if (clazz == null) {
                            5.$$$reportNull$$$0(1);
                        }
                        Runnable convert = new Runnable(){

                            @Override
                            public void run() {
                                Object o = ProjectImportAction.this.myModelConverter.convert(object);
                                allModels.addModel(o, clazz, project);
                            }
                        };
                        if (ProjectImportAction.this.myConverterExecutor != null) {
                            ProjectImportAction.this.myConverterExecutor.execute(convert);
                        } else {
                            result.add(convert);
                        }
                        obtainedModels.add(clazz.getName());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "object";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "clazz";
                                break;
                            }
                        }
                        objectArray[1] = "org/jetbrains/plugins/gradle/model/ProjectImportAction$5";
                        objectArray[2] = "consume";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                extension.populateProjectModels(controller, (Model)project, modelConsumer);
                allModels.logPerformance("Ran extension " + extension.getClass().getName() + " for project " + project.getProjectIdentifier().getProjectPath() + " obtained " + obtainedModels.size() + " model(s): " + ProjectImportAction.joinClassNamesToString(obtainedModels), System.currentTimeMillis() - startTime);
            }
            return result;
        }
        catch (Exception e) {
            if (!this.myIsPreviewMode) {
                throw new ExternalSystemException((Throwable)e);
            }
            return Collections.emptyList();
        }
    }

    private void addBuildModels(@NotNull BuildController controller, final @NotNull AllModels allModels, @NotNull GradleBuild buildModel, boolean isProjectsLoadedAction) {
        block6: {
            if (controller == null) {
                ProjectImportAction.$$$reportNull$$$0(12);
            }
            if (allModels == null) {
                ProjectImportAction.$$$reportNull$$$0(13);
            }
            if (buildModel == null) {
                ProjectImportAction.$$$reportNull$$$0(14);
            }
            try {
                Set<ProjectImportModelProvider> modelProviders = this.getModelProviders(isProjectsLoadedAction);
                for (ProjectImportModelProvider extension : modelProviders) {
                    final HashSet<String> obtainedModels = new HashSet<String>();
                    long startTime = System.currentTimeMillis();
                    ProjectImportModelProvider.BuildModelConsumer modelConsumer = new ProjectImportModelProvider.BuildModelConsumer(){

                        @Override
                        public void consumeProjectModel(final @NotNull ProjectModel projectModel, final @NotNull Object object, final @NotNull Class clazz) {
                            if (projectModel == null) {
                                6.$$$reportNull$$$0(0);
                            }
                            if (object == null) {
                                6.$$$reportNull$$$0(1);
                            }
                            if (clazz == null) {
                                6.$$$reportNull$$$0(2);
                            }
                            obtainedModels.add(clazz.getName());
                            Runnable convert = new Runnable(){

                                @Override
                                public void run() {
                                    Object converted = ProjectImportAction.this.myModelConverter.convert(object);
                                    allModels.addModel(converted, clazz, projectModel);
                                }
                            };
                            if (ProjectImportAction.this.myConverterExecutor != null) {
                                ProjectImportAction.this.myConverterExecutor.execute(convert);
                            } else {
                                convert.run();
                            }
                        }

                        @Override
                        public void consume(final @NotNull BuildModel buildModel, final @NotNull Object object, final @NotNull Class clazz) {
                            if (buildModel == null) {
                                6.$$$reportNull$$$0(3);
                            }
                            if (object == null) {
                                6.$$$reportNull$$$0(4);
                            }
                            if (clazz == null) {
                                6.$$$reportNull$$$0(5);
                            }
                            obtainedModels.add(clazz.getName());
                            Runnable convert = new Runnable(){

                                @Override
                                public void run() {
                                    Object converted = ProjectImportAction.this.myModelConverter.convert(object);
                                    allModels.addModel(converted, clazz, buildModel);
                                }
                            };
                            if (ProjectImportAction.this.myConverterExecutor != null) {
                                ProjectImportAction.this.myConverterExecutor.execute(convert);
                            } else {
                                convert.run();
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "projectModel";
                                    break;
                                }
                                case 1: 
                                case 4: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "object";
                                    break;
                                }
                                case 2: 
                                case 5: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "clazz";
                                    break;
                                }
                                case 3: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "buildModel";
                                    break;
                                }
                            }
                            objectArray2[1] = "org/jetbrains/plugins/gradle/model/ProjectImportAction$6";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "consumeProjectModel";
                                    break;
                                }
                                case 3: 
                                case 4: 
                                case 5: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "consume";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                    extension.populateBuildModels(controller, buildModel, modelConsumer);
                    allModels.logPerformance("Ran extension " + extension.getClass().getName() + " for build " + buildModel.getBuildIdentifier().getRootDir().getPath() + " obtained " + obtainedModels.size() + " model(s): " + ProjectImportAction.joinClassNamesToString(obtainedModels), System.currentTimeMillis() - startTime);
                }
            }
            catch (Exception e) {
                if (this.myIsPreviewMode) break block6;
                throw new ExternalSystemException((Throwable)e);
            }
        }
    }

    private Set<ProjectImportModelProvider> getModelProviders(boolean isProjectsLoadedAction) {
        LinkedHashSet<ProjectImportModelProvider> modelProviders = new LinkedHashSet<ProjectImportModelProvider>();
        if (!this.myUseProjectsLoadedPhase) {
            modelProviders.addAll(this.myProjectsLoadedModelProviders);
            modelProviders.addAll(this.myBuildFinishedModelProviders);
        } else {
            modelProviders = isProjectsLoadedAction ? this.myProjectsLoadedModelProviders : this.myBuildFinishedModelProviders;
        }
        return modelProviders;
    }

    @NotNull
    private static String joinClassNamesToString(@NotNull Set<String> names) {
        if (names == null) {
            ProjectImportAction.$$$reportNull$$$0(15);
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = names.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        String string = sb.toString();
        if (string == null) {
            ProjectImportAction.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetTypes";
                break;
            }
            case 3: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 4: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/model/ProjectImportAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootBuild";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "build";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allModels";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildModel";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/model/ProjectImportAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolingModelConverter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "joinClassNamesToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addProjectImportModelProvider";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addTargetTypes";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getToolingModelConverter";
                break;
            }
            case 4: 
            case 8: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNestedBuilds";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEditableBuilds";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getProjectModels";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addBuildModels";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "joinClassNamesToString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Experimental
    public static interface ModelConverter
    extends Serializable {
        public Object convert(Object var1);
    }

    public static final class AllModels
    extends ModelsHolder<BuildModel, ProjectModel> {
        @NotNull
        private final List<Build> includedBuilds;
        private final Map<String, Long> performanceTrace;
        private transient Map<String, String> myBuildsKeyPrefixesMapping;

        public AllModels(@NotNull Build mainBuild) {
            if (mainBuild == null) {
                AllModels.$$$reportNull$$$0(0);
            }
            super(mainBuild);
            this.includedBuilds = new ArrayList<Build>();
            this.performanceTrace = new ConcurrentHashMap<String, Long>();
        }

        public AllModels(@NotNull IdeaProject ideaProject) {
            if (ideaProject == null) {
                AllModels.$$$reportNull$$$0(1);
            }
            super(new LegacyIdeaProjectModelAdapter(ideaProject));
            this.includedBuilds = new ArrayList<Build>();
            this.performanceTrace = new ConcurrentHashMap<String, Long>();
            this.addModel(ideaProject, IdeaProject.class);
        }

        @Deprecated
        @NotNull
        @ApiStatus.ScheduledForRemoval
        public IdeaProject getIdeaProject() {
            IdeaProject ideaProject = this.getModel(IdeaProject.class);
            assert (ideaProject != null);
            IdeaProject ideaProject2 = ideaProject;
            if (ideaProject2 == null) {
                AllModels.$$$reportNull$$$0(2);
            }
            return ideaProject2;
        }

        @NotNull
        public Build getMainBuild() {
            Build build = (Build)this.getRootModel();
            if (build == null) {
                AllModels.$$$reportNull$$$0(3);
            }
            return build;
        }

        @NotNull
        public List<Build> getIncludedBuilds() {
            List<Build> list = this.includedBuilds;
            if (list == null) {
                AllModels.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        public List<Build> getAllBuilds() {
            ArrayList<Build> result = new ArrayList<Build>();
            result.add(this.getMainBuild());
            result.addAll(this.includedBuilds);
            ArrayList<Build> arrayList = result;
            if (arrayList == null) {
                AllModels.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        @Nullable
        public BuildEnvironment getBuildEnvironment() {
            return this.getModel(BuildEnvironment.class);
        }

        public void setBuildEnvironment(@Nullable BuildEnvironment buildEnvironment) {
            if (buildEnvironment != null) {
                this.addModel(buildEnvironment, BuildEnvironment.class);
            }
        }

        public void logPerformance(@NotNull String description, long millis) {
            if (description == null) {
                AllModels.$$$reportNull$$$0(6);
            }
            this.performanceTrace.put(description, millis);
        }

        public Map<String, Long> getPerformanceTrace() {
            return this.performanceTrace;
        }

        @Override
        public void applyPathsConverter(@NotNull Consumer<Object> pathsConverter) {
            if (pathsConverter == null) {
                AllModels.$$$reportNull$$$0(7);
            }
            super.applyPathsConverter(pathsConverter);
            BuildEnvironment buildEnvironment = this.getBuildEnvironment();
            if (buildEnvironment != null) {
                pathsConverter.consume((Object)buildEnvironment);
            }
            this.myBuildsKeyPrefixesMapping = new HashMap<String, String>();
            this.convertPaths(pathsConverter, this.getMainBuild());
            for (Build includedBuild : this.includedBuilds) {
                this.convertPaths(pathsConverter, includedBuild);
            }
        }

        private void convertPaths(@NotNull Consumer<Object> fileMapper, @NotNull Build build) {
            if (fileMapper == null) {
                AllModels.$$$reportNull$$$0(8);
            }
            if (build == null) {
                AllModels.$$$reportNull$$$0(9);
            }
            String originalKey = this.getBuildKeyPrefix(build.getBuildIdentifier());
            fileMapper.consume((Object)build);
            String currentKey = this.getBuildKeyPrefix(build.getBuildIdentifier());
            if (!originalKey.equals(currentKey)) {
                this.myBuildsKeyPrefixesMapping.put(currentKey, originalKey);
            }
        }

        @Override
        @NotNull
        protected String getBuildKeyPrefix(@NotNull BuildIdentifier buildIdentifier) {
            if (buildIdentifier == null) {
                AllModels.$$$reportNull$$$0(10);
            }
            String currentKey = super.getBuildKeyPrefix(buildIdentifier);
            String originalKey = this.myBuildsKeyPrefixesMapping == null ? null : this.myBuildsKeyPrefixesMapping.get(currentKey);
            String string = originalKey == null ? currentKey : originalKey;
            if (string == null) {
                AllModels.$$$reportNull$$$0(11);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mainBuild";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ideaProject";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/model/ProjectImportAction$AllModels";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathsConverter";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileMapper";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "build";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildIdentifier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/model/ProjectImportAction$AllModels";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIdeaProject";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMainBuild";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIncludedBuilds";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllBuilds";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBuildKeyPrefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 11: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "logPerformance";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "applyPathsConverter";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "convertPaths";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getBuildKeyPrefix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class SimpleThreadFactory
    implements ThreadFactory {
        private SimpleThreadFactory() {
        }

        @Override
        public Thread newThread(@NotNull Runnable runnable) {
            if (runnable == null) {
                SimpleThreadFactory.$$$reportNull$$$0(0);
            }
            return new Thread(runnable, "idea-tooling-model-converter");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "org/jetbrains/plugins/gradle/model/ProjectImportAction$SimpleThreadFactory", "newThread"));
        }
    }

    private static final class MyBuildController
    implements BuildController {
        private final BuildController myDelegate;
        private final GradleBuild myMainGradleBuild;
        private final Model myMyMainGradleBuildRootProject;

        private MyBuildController(@NotNull BuildController buildController, @NotNull GradleBuild mainGradleBuild) {
            if (buildController == null) {
                MyBuildController.$$$reportNull$$$0(0);
            }
            if (mainGradleBuild == null) {
                MyBuildController.$$$reportNull$$$0(1);
            }
            this.myDelegate = buildController;
            this.myMainGradleBuild = mainGradleBuild;
            this.myMyMainGradleBuildRootProject = this.myMainGradleBuild.getRootProject();
        }

        public <T> T getModel(Class<T> aClass) throws UnknownModelException {
            if (aClass == GradleBuild.class) {
                return (T)this.myMainGradleBuild;
            }
            return (T)this.myDelegate.getModel(this.myMyMainGradleBuildRootProject, aClass);
        }

        public <T> T findModel(Class<T> aClass) {
            if (aClass == GradleBuild.class) {
                return (T)this.myMainGradleBuild;
            }
            return (T)this.myDelegate.findModel(this.myMyMainGradleBuildRootProject, aClass);
        }

        public GradleBuild getBuildModel() {
            return this.myMainGradleBuild;
        }

        public <T> T getModel(Model model, Class<T> aClass) throws UnknownModelException {
            if (this.isMainBuild(model)) {
                return this.getModel(aClass);
            }
            return (T)this.myDelegate.getModel(model, aClass);
        }

        public <T> T findModel(Model model, Class<T> aClass) {
            if (this.isMainBuild(model)) {
                return this.findModel(aClass);
            }
            return (T)this.myDelegate.findModel(model, aClass);
        }

        public <T, P> T getModel(Class<T> aClass, Class<P> aClass1, Action<? super P> action) throws UnsupportedVersionException {
            return (T)this.myDelegate.getModel(this.myMyMainGradleBuildRootProject, aClass, aClass1, action);
        }

        public <T, P> T findModel(Class<T> aClass, Class<P> aClass1, Action<? super P> action) {
            return (T)this.myDelegate.findModel(this.myMyMainGradleBuildRootProject, aClass, aClass1, action);
        }

        public <T, P> T getModel(Model model, Class<T> aClass, Class<P> aClass1, Action<? super P> action) throws UnsupportedVersionException {
            if (this.isMainBuild(model)) {
                return this.getModel(aClass, aClass1, action);
            }
            return (T)this.myDelegate.getModel(model, aClass, aClass1, action);
        }

        public <T, P> T findModel(Model model, Class<T> aClass, Class<P> aClass1, Action<? super P> action) {
            if (this.isMainBuild(model)) {
                return this.findModel(aClass, aClass1, action);
            }
            return (T)this.myDelegate.findModel(model, aClass, aClass1, action);
        }

        public <T> List<T> run(Collection<? extends BuildAction<? extends T>> collection) {
            return this.myDelegate.run(collection);
        }

        public boolean getCanQueryProjectModelInParallel(Class<?> aClass) {
            return this.myDelegate.getCanQueryProjectModelInParallel(aClass);
        }

        private boolean isMainBuild(Model model) {
            return model == null || model == this.myMainGradleBuild;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "buildController";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mainGradleBuild";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/gradle/model/ProjectImportAction$MyBuildController";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class DefaultBuild
    implements Build,
    Serializable {
        private final String myName;
        private final DefaultBuildIdentifier myBuildIdentifier;
        private final Collection<Project> myProjects = new ArrayList<Project>(0);
        private DefaultBuildIdentifier myParentBuildIdentifier = null;

        private DefaultBuild(String name, File rootDir) {
            this.myName = name;
            this.myBuildIdentifier = new DefaultBuildIdentifier(rootDir);
        }

        @Override
        public String getName() {
            return this.myName;
        }

        public BuildIdentifier getBuildIdentifier() {
            return this.myBuildIdentifier;
        }

        @Override
        public Collection<Project> getProjects() {
            return this.myProjects;
        }

        @Override
        public BuildIdentifier getParentBuildIdentifier() {
            return this.myParentBuildIdentifier;
        }

        private void setParentBuildIdentifier(DefaultBuildIdentifier parentBuildIdentifier) {
            this.myParentBuildIdentifier = parentBuildIdentifier;
        }

        private void addProject(String name, ProjectIdentifier projectIdentifier) {
            String projectPath = projectIdentifier.getProjectPath();
            File rootDir = this.myBuildIdentifier.getRootDir();
            assert (rootDir.getPath().equals(projectIdentifier.getBuildIdentifier().getRootDir().getPath()));
            this.myProjects.add(new DefaultProjectModel(name, rootDir, projectPath));
        }

        private static final class DefaultProjectModel
        implements Project,
        Serializable {
            private final String myName;
            private final DefaultProjectIdentifier myProjectIdentifier;

            private DefaultProjectModel(@NotNull String name, @NotNull File rootDir, @NotNull String projectPath) {
                if (name == null) {
                    DefaultProjectModel.$$$reportNull$$$0(0);
                }
                if (rootDir == null) {
                    DefaultProjectModel.$$$reportNull$$$0(1);
                }
                if (projectPath == null) {
                    DefaultProjectModel.$$$reportNull$$$0(2);
                }
                this.myName = name;
                this.myProjectIdentifier = new DefaultProjectIdentifier(rootDir, projectPath);
            }

            @Override
            public String getName() {
                return this.myName;
            }

            public ProjectIdentifier getProjectIdentifier() {
                return this.myProjectIdentifier;
            }

            public String toString() {
                return "ProjectModel{name='" + this.myName + '\'' + ", id=" + this.myProjectIdentifier + '}';
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rootDir";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "projectPath";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/gradle/model/ProjectImportAction$DefaultBuild$DefaultProjectModel";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class NoopConverter
    implements ModelConverter {
        private NoopConverter() {
        }

        @Override
        public Object convert(Object object) {
            return object;
        }
    }

    private static interface GradleBuildConsumer {
        public void accept(@NotNull GradleBuild var1);
    }
}

