/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.UpperBoundChecker;
import org.jetbrains.kotlin.resolve.UpperBoundViolatedReporter;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeWithEnhancementKt;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004Jh\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142 \b\u0002\u0010\u0015\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00170\u0016J\\\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u001e\u0010\u0015\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J \u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/WarningAwareUpperBoundChecker;", "Lorg/jetbrains/kotlin/resolve/UpperBoundChecker;", "typeChecker", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeChecker;", "(Lorg/jetbrains/kotlin/types/checker/KotlinTypeChecker;)V", "checkBounds", "", "argumentReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "argumentType", "Lorg/jetbrains/kotlin/types/KotlinType;", "typeParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "substitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "typeAliasUsageElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "withOnlyCheckForWarning", "", "diagnosticForTypeAliases", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory3;", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "checkBoundsOfExpandedTypeAlias", "type", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "frontend.java"})
public final class WarningAwareUpperBoundChecker
extends UpperBoundChecker {
    public WarningAwareUpperBoundChecker(@NotNull KotlinTypeChecker typeChecker) {
        Intrinsics.checkNotNullParameter((Object)typeChecker, (String)"typeChecker");
        super(typeChecker);
    }

    public void checkBoundsOfExpandedTypeAlias(@NotNull KotlinType type, @NotNull KtExpression expression, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        List list = type.getConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParameters(...)");
        List typeParameters = list;
        Iterator iterator2 = type.getArguments().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            TypeProjection arg = (TypeProjection)iterator2.next();
            KotlinType kotlinType = arg.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            Object e = typeParameters.get(index);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)e;
            TypeSubstitutor typeSubstitutor = TypeSubstitutor.create((KotlinType)type);
            Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor, (String)"create(...)");
            WarningAwareUpperBoundChecker.checkBounds$default(this, null, kotlinType, typeParameterDescriptor, typeSubstitutor, trace, expression, true, null, 128, null);
        }
    }

    public void checkBounds(@Nullable KtTypeReference argumentReference, @NotNull KotlinType argumentType, @NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull TypeSubstitutor substitutor, @NotNull BindingTrace trace, @Nullable KtElement typeAliasUsageElement, @NotNull DiagnosticFactory3<KtElement, KotlinType, KotlinType, ClassifierDescriptor> diagnosticForTypeAliases) {
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        Intrinsics.checkNotNullParameter((Object)typeParameterDescriptor, (String)"typeParameterDescriptor");
        Intrinsics.checkNotNullParameter((Object)substitutor, (String)"substitutor");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter(diagnosticForTypeAliases, (String)"diagnosticForTypeAliases");
        this.checkBounds(argumentReference, argumentType, typeParameterDescriptor, substitutor, trace, typeAliasUsageElement, false, diagnosticForTypeAliases);
    }

    public final void checkBounds(@Nullable KtTypeReference argumentReference, @NotNull KotlinType argumentType, @NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull TypeSubstitutor substitutor, @NotNull BindingTrace trace, @Nullable KtElement typeAliasUsageElement, boolean withOnlyCheckForWarning, @NotNull DiagnosticFactory3<KtElement, KotlinType, KotlinType, ClassifierDescriptor> diagnosticForTypeAliases) {
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        Intrinsics.checkNotNullParameter((Object)typeParameterDescriptor, (String)"typeParameterDescriptor");
        Intrinsics.checkNotNullParameter((Object)substitutor, (String)"substitutor");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter(diagnosticForTypeAliases, (String)"diagnosticForTypeAliases");
        if (typeParameterDescriptor.getUpperBounds().isEmpty()) {
            return;
        }
        UpperBoundViolatedReporter diagnosticsReporter = new UpperBoundViolatedReporter(trace, argumentType, typeParameterDescriptor, null, diagnosticForTypeAliases, 8, null);
        DiagnosticFactory2<KtTypeReference, KotlinType, KotlinType> diagnosticFactory2 = ErrorsJvm.UPPER_BOUND_VIOLATED_BASED_ON_JAVA_ANNOTATIONS;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory2, (String)"UPPER_BOUND_VIOLATED_BASED_ON_JAVA_ANNOTATIONS");
        DiagnosticFactory3<KtElement, KotlinType, KotlinType, ClassifierDescriptor> diagnosticFactory3 = ErrorsJvm.UPPER_BOUND_VIOLATED_IN_TYPEALIAS_EXPANSION_BASED_ON_JAVA_ANNOTATIONS;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory3, (String)"UPPER_BOUND_VIOLATED_IN_\u2026BASED_ON_JAVA_ANNOTATIONS");
        UpperBoundViolatedReporter diagnosticsReporterForWarnings = new UpperBoundViolatedReporter(trace, argumentType, typeParameterDescriptor, diagnosticFactory2, diagnosticFactory3);
        for (KotlinType bound : typeParameterDescriptor.getUpperBounds()) {
            KotlinType enhancedBound;
            if (!withOnlyCheckForWarning) {
                Intrinsics.checkNotNull((Object)bound);
                boolean isBaseCheckPassed = this.checkBound(bound, argumentType, argumentReference, substitutor, typeAliasUsageElement, diagnosticsReporter);
                if (!isBaseCheckPassed) continue;
            }
            Intrinsics.checkNotNull((Object)bound);
            if (TypeWithEnhancementKt.getEnhancementDeeply((KotlinType)bound) == null) continue;
            KotlinType kotlinType = TypeWithEnhancementKt.getEnhancementDeeply((KotlinType)argumentType);
            if (kotlinType == null) {
                kotlinType = argumentType;
            }
            KotlinType argumentTypeEnhancement = kotlinType;
            this.checkBound(enhancedBound, argumentTypeEnhancement, argumentReference, substitutor, typeAliasUsageElement, diagnosticsReporterForWarnings);
        }
    }

    public static /* synthetic */ void checkBounds$default(WarningAwareUpperBoundChecker warningAwareUpperBoundChecker, KtTypeReference ktTypeReference, KotlinType kotlinType, TypeParameterDescriptor typeParameterDescriptor, TypeSubstitutor typeSubstitutor, BindingTrace bindingTrace, KtElement ktElement, boolean bl, DiagnosticFactory3 diagnosticFactory3, int n, Object object) {
        if ((n & 0x20) != 0) {
            ktElement = null;
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        if ((n & 0x80) != 0) {
            DiagnosticFactory3 diagnosticFactory32 = Errors.UPPER_BOUND_VIOLATED_IN_TYPEALIAS_EXPANSION;
            Intrinsics.checkNotNullExpressionValue((Object)diagnosticFactory32, (String)"UPPER_BOUND_VIOLATED_IN_TYPEALIAS_EXPANSION");
            diagnosticFactory3 = diagnosticFactory32;
        }
        warningAwareUpperBoundChecker.checkBounds(ktTypeReference, kotlinType, typeParameterDescriptor, typeSubstitutor, bindingTrace, ktElement, bl, (DiagnosticFactory3<KtElement, KotlinType, KotlinType, ClassifierDescriptor>)diagnosticFactory3);
    }
}

