/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.refactoring;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.RenameRefactoring;
import com.intellij.refactoring.openapi.impl.JavaRenameRefactoringImpl;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.NullableConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.JavaFXBundle;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxComponentIdReferenceProvider;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxFieldIdReferenceProvider;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxPropertyReference;
import org.jetbrains.plugins.javaFX.refactoring.JavaFxPropertyElement;
import org.jetbrains.plugins.javaFX.refactoring.JavaFxRenameAttributeProcessor;

public class JavaFxPropertyRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        PsiReference reference;
        if (dataContext == null) {
            JavaFxPropertyRenameHandler.$$$reportNull$$$0(0);
        }
        return (reference = JavaFxPropertyRenameHandler.getKnownReference(JavaFxPropertyRenameHandler.getReferences(dataContext))) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            JavaFxPropertyRenameHandler.$$$reportNull$$$0(1);
        }
        JavaFxPropertyRenameHandler.performInvoke(project, editor, dataContext);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            JavaFxPropertyRenameHandler.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            JavaFxPropertyRenameHandler.$$$reportNull$$$0(3);
        }
        JavaFxPropertyRenameHandler.performInvoke(project, null, dataContext);
    }

    private static void performInvoke(@NotNull Project project, @Nullable Editor editor, DataContext dataContext) {
        Map<PsiElement, String> elementsToRename;
        PsiReference[] references;
        PsiReference reference;
        if (project == null) {
            JavaFxPropertyRenameHandler.$$$reportNull$$$0(4);
        }
        if ((reference = JavaFxPropertyRenameHandler.getKnownReference(references = JavaFxPropertyRenameHandler.getReferences(dataContext))) == null) {
            return;
        }
        if (reference instanceof JavaFxComponentIdReferenceProvider.JavaFxIdReferenceBase && ((JavaFxComponentIdReferenceProvider.JavaFxIdReferenceBase)reference).isBuiltIn()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaFXBundle.message("javafx.property.rename.handler.error.message", new Object[0]), (String)JavaFXBundle.message("javafx.property.rename.handler.error.title", new Object[0]), null);
            return;
        }
        if (reference instanceof JavaFxPropertyReference) {
            JavaFxPropertyReference propertyReference = (JavaFxPropertyReference)reference;
            if (reference.resolve() != null) {
                elementsToRename = JavaFxPropertyRenameHandler.getElementsToRename(propertyReference, "a");
                if (!JavaFxPropertyRenameHandler.canRename(project, editor, elementsToRename.keySet())) {
                    return;
                }
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    String newName = (String)PsiElementRenameHandler.DEFAULT_NAME.getData(dataContext);
                    assert (newName != null) : "Rename property";
                    JavaFxPropertyRenameHandler.doRename(propertyReference, newName, false, false);
                    return;
                }
                PsiElement psiElement = JavaFxPropertyElement.fromReference(propertyReference);
                if (psiElement != null) {
                    new PropertyRenameDialog(propertyReference, psiElement, project, editor).show();
                }
            }
        }
        if (reference instanceof JavaFxFieldIdReferenceProvider.JavaFxControllerFieldRef) {
            XmlAttributeValue fxIdValueElement = ((JavaFxFieldIdReferenceProvider.JavaFxControllerFieldRef)reference).getXmlAttributeValue();
            elementsToRename = new HashSet();
            JavaFxRenameAttributeProcessor.visitReferencedElements(references, (NullableConsumer<? super PsiElement>)((NullableConsumer)arg_0 -> JavaFxPropertyRenameHandler.lambda$performInvoke$0((Set)((Object)elementsToRename), arg_0)));
            ContainerUtil.addIfNotNull((Collection)((Object)elementsToRename), (Object)JavaFxPropertyRenameHandler.getNestedControllerField(fxIdValueElement));
            if (!JavaFxPropertyRenameHandler.canRename(project, editor, (Collection<PsiElement>)((Object)elementsToRename))) {
                return;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                String newName = (String)PsiElementRenameHandler.DEFAULT_NAME.getData(dataContext);
                assert (newName != null) : "Rename property";
                JavaFxPropertyRenameHandler.doRenameFxId(fxIdValueElement, newName, false, false);
            } else {
                new RenameFxIdDialog(fxIdValueElement, editor).show();
            }
        }
    }

    private static boolean canRename(@NotNull Project project, @Nullable Editor editor, @NotNull Collection<PsiElement> elements) {
        if (project == null) {
            JavaFxPropertyRenameHandler.$$$reportNull$$$0(5);
        }
        if (elements == null) {
            JavaFxPropertyRenameHandler.$$$reportNull$$$0(6);
        }
        return elements.stream().allMatch(element -> PsiElementRenameHandler.canRename((Project)project, (Editor)editor, (PsiElement)element));
    }

    private static void doRename(JavaFxPropertyReference reference, String newName, boolean searchInComments, boolean isPreview) {
        PsiElement psiElement = JavaFxPropertyElement.fromReference(reference);
        if (psiElement == null) {
            return;
        }
        JavaRenameRefactoringImpl rename = new JavaRenameRefactoringImpl(psiElement.getProject(), psiElement, newName, searchInComments, false);
        rename.setPreviewUsages(isPreview);
        Map<PsiElement, String> elementsToRename = JavaFxPropertyRenameHandler.getElementsToRename(reference, newName);
        elementsToRename.forEach((arg_0, arg_1) -> ((RenameRefactoring)rename).addElement(arg_0, arg_1));
        rename.run();
    }

    @Nullable
    private static PsiReference getKnownReference(PsiReference[] references) {
        return (PsiReference)ContainerUtil.find((Object[])references, JavaFxPropertyRenameHandler::isKnown);
    }

    private static PsiReference @NotNull [] getReferences(DataContext dataContext) {
        Project project;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (file == null && editor != null && ApplicationManager.getApplication().isUnitTestMode() && (project = editor.getProject()) != null) {
            file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        }
        if (editor != null && file instanceof XmlFile && JavaFxFileTypeFactory.isFxml(file)) {
            int offset = editor.getCaretModel().getOffset();
            PsiReference reference = file.findReferenceAt(offset);
            if (reference instanceof PsiMultiReference) {
                PsiReference[] psiReferenceArray = ((PsiMultiReference)reference).getReferences();
                if (psiReferenceArray == null) {
                    JavaFxPropertyRenameHandler.$$$reportNull$$$0(7);
                }
                return psiReferenceArray;
            }
            if (JavaFxPropertyRenameHandler.isKnown(reference)) {
                PsiReference[] psiReferenceArray = new PsiReference[]{reference};
                if (psiReferenceArray == null) {
                    JavaFxPropertyRenameHandler.$$$reportNull$$$0(8);
                }
                return psiReferenceArray;
            }
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            JavaFxPropertyRenameHandler.$$$reportNull$$$0(9);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static boolean isKnown(PsiReference reference) {
        if (reference instanceof JavaFxPropertyReference || reference instanceof JavaFxFieldIdReferenceProvider.JavaFxControllerFieldRef) {
            return true;
        }
        if (reference instanceof JavaFxComponentIdReferenceProvider.JavaFxIdReferenceBase) {
            return ((JavaFxComponentIdReferenceProvider.JavaFxIdReferenceBase)reference).isBuiltIn();
        }
        return false;
    }

    @NotNull
    private static Map<PsiElement, String> getElementsToRename(@NotNull JavaFxPropertyReference reference, @NotNull String newPropertyName) {
        if (reference == null) {
            JavaFxPropertyRenameHandler.$$$reportNull$$$0(10);
        }
        if (newPropertyName == null) {
            JavaFxPropertyRenameHandler.$$$reportNull$$$0(11);
        }
        HashMap<PsiElement, String> rename = new HashMap<PsiElement, String>();
        JavaFxPropertyRenameHandler.putIfKeyNotNull(rename, reference.getGetter(), PropertyUtilBase.suggestGetterName((String)newPropertyName, (PsiType)reference.getType()));
        JavaFxPropertyRenameHandler.putIfKeyNotNull(rename, reference.getField(), newPropertyName);
        JavaFxPropertyRenameHandler.putIfKeyNotNull(rename, reference.getSetter(), PropertyUtilBase.suggestSetterName((String)newPropertyName));
        JavaFxPropertyRenameHandler.putIfKeyNotNull(rename, reference.getObservableGetter(), newPropertyName + "Property");
        JavaFxPropertyRenameHandler.putIfKeyNotNull(rename, reference.getStaticSetter(), PropertyUtilBase.suggestSetterName((String)newPropertyName));
        HashMap<PsiElement, String> hashMap = rename;
        if (hashMap == null) {
            JavaFxPropertyRenameHandler.$$$reportNull$$$0(12);
        }
        return hashMap;
    }

    private static <K, V> void putIfKeyNotNull(@NotNull Map<K, V> map, @Nullable K key, @NotNull V value) {
        if (map == null) {
            JavaFxPropertyRenameHandler.$$$reportNull$$$0(13);
        }
        if (value == null) {
            JavaFxPropertyRenameHandler.$$$reportNull$$$0(14);
        }
        if (key != null) {
            map.put(key, value);
        }
    }

    public static void doRenameFxId(XmlAttributeValue fxIdValueElement, String newName, boolean searchInComments, boolean previewUsages) {
        JavaRenameRefactoringImpl rename = new JavaRenameRefactoringImpl(fxIdValueElement.getProject(), (PsiElement)fxIdValueElement, newName, searchInComments, false);
        rename.setPreviewUsages(previewUsages);
        PsiField nestedControllerField = JavaFxPropertyRenameHandler.getNestedControllerField(fxIdValueElement);
        if (nestedControllerField != null) {
            rename.addElement((PsiElement)nestedControllerField, newName + "Controller");
        }
        rename.run();
    }

    @Nullable
    private static PsiField getNestedControllerField(@NotNull XmlAttributeValue fxIdValueElement) {
        PsiClass controllerClass;
        XmlTag tag;
        String fxId;
        if (fxIdValueElement == null) {
            JavaFxPropertyRenameHandler.$$$reportNull$$$0(15);
        }
        if (!StringUtil.isEmpty((String)(fxId = fxIdValueElement.getValue())) && (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)fxIdValueElement, XmlTag.class)) != null && "fx:include".equals(tag.getName()) && (controllerClass = JavaFxPsiUtil.getControllerClass(tag.getContainingFile())) != null) {
            return controllerClass.findFieldByName(fxId + "Controller", true);
        }
        return null;
    }

    private static /* synthetic */ void lambda$performInvoke$0(Set elementsToRename, PsiElement psiElement) {
        if (psiElement != null) {
            elementsToRename.add(psiElement);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/refactoring/JavaFxPropertyRenameHandler";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPropertyName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fxIdValueElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/refactoring/JavaFxPropertyRenameHandler";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToRename";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performInvoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canRename";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToRename";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "putIfKeyNotNull";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getNestedControllerField";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 12 -> new IllegalStateException(string);
        };
    }

    private static class PropertyRenameDialog
    extends RenameDialog {
        private final JavaFxPropertyReference myPropertyReference;

        protected PropertyRenameDialog(@NotNull JavaFxPropertyReference propertyReference, @NotNull PsiElement psiElement, @NotNull Project project, Editor editor) {
            if (propertyReference == null) {
                PropertyRenameDialog.$$$reportNull$$$0(0);
            }
            if (psiElement == null) {
                PropertyRenameDialog.$$$reportNull$$$0(1);
            }
            if (project == null) {
                PropertyRenameDialog.$$$reportNull$$$0(2);
            }
            super(project, psiElement, null, editor);
            this.myPropertyReference = propertyReference;
        }

        protected void doAction() {
            String newName = this.getNewName();
            boolean searchInComments = this.isSearchInComments();
            JavaFxPropertyRenameHandler.doRename(this.myPropertyReference, newName, searchInComments, this.isPreviewUsages());
            this.close(0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "propertyReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "psiElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/javaFX/refactoring/JavaFxPropertyRenameHandler$PropertyRenameDialog";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RenameFxIdDialog
    extends RenameDialog {
        RenameFxIdDialog(@NotNull XmlAttributeValue fxIdValueElement, Editor editor) {
            if (fxIdValueElement == null) {
                RenameFxIdDialog.$$$reportNull$$$0(0);
            }
            super(fxIdValueElement.getProject(), (PsiElement)fxIdValueElement, null, editor);
        }

        protected void doAction() {
            String newName = this.getNewName();
            PsiElement element = this.getPsiElement();
            assert (element instanceof XmlAttributeValue);
            JavaFxPropertyRenameHandler.doRenameFxId((XmlAttributeValue)element, newName, this.isSearchInComments(), this.isPreviewUsages());
            this.close(0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fxIdValueElement", "org/jetbrains/plugins/javaFX/refactoring/JavaFxPropertyRenameHandler$RenameFxIdDialog", "<init>"));
        }
    }
}

