/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.images;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.MarkdownIcons;
import org.intellij.plugins.markdown.editor.images.ConfigureImageDialog;
import org.intellij.plugins.markdown.editor.images.MarkdownImageData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\b'\u0018\u0000 \u001a*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH&J\u0017\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0015\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\u0002H&J\u0017\u0010\u0014\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0007\u001a\u00020\u0002H&\u00a2\u0006\u0002\u0010\u0015J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0007\u001a\u00020\u0002H&J\u000e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0019\u001a\u00020\u0010H\u0002\u00a8\u0006\u001c"}, d2={"Lorg/intellij/plugins/markdown/editor/images/ConfigureImageLineMarkerProviderBase;", "T", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInsight/daemon/LineMarkerProviderDescriptor;", "()V", "applyChanges", "", "element", "imageData", "Lorg/intellij/plugins/markdown/editor/images/MarkdownImageData;", "createDialog", "Lorg/intellij/plugins/markdown/editor/images/ConfigureImageDialog;", "(Lcom/intellij/psi/PsiElement;)Lorg/intellij/plugins/markdown/editor/images/ConfigureImageDialog;", "getLineMarkerInfo", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "getMarkerElementPresentation", "", "Lorg/jetbrains/annotations/Nls;", "getName", "obtainLeafElement", "obtainOuterElement", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "obtainPathText", "performAction", "processFileName", "filePath", "Companion", "ConfigureImageLineMarkerInfo", "intellij.markdown.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nConfigureImageLineMarkerProviderBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigureImageLineMarkerProviderBase.kt\norg/intellij/plugins/markdown/editor/images/ConfigureImageLineMarkerProviderBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
public abstract class ConfigureImageLineMarkerProviderBase<T extends PsiElement>
extends LineMarkerProviderDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final GutterIconRenderer.Alignment ALIGNMENT = GutterIconRenderer.Alignment.CENTER;

    @Nullable
    public abstract ConfigureImageDialog createDialog(@NotNull T var1);

    @Nullable
    public abstract String obtainPathText(@NotNull PsiElement var1);

    public abstract void applyChanges(@NotNull PsiElement var1, @NotNull MarkdownImageData var2);

    @Nullable
    public abstract PsiElement obtainLeafElement(@NotNull PsiElement var1);

    @Nullable
    public abstract T obtainOuterElement(@NotNull PsiElement var1);

    @Nullable
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiElement psiElement = this.obtainLeafElement(element2);
        if (psiElement == null) {
            return null;
        }
        PsiElement leaf = psiElement;
        TextRange textRange = leaf.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"leaf.textRange");
        return (LineMarkerInfo)new ConfigureImageLineMarkerInfo(element2, textRange);
    }

    public final void performAction(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        T t = this.obtainOuterElement(element2);
        if (t == null) {
            return;
        }
        T outerElement = t;
        ConfigureImageDialog configureImageDialog = this.createDialog(outerElement);
        if (configureImageDialog == null) {
            return;
        }
        ConfigureImageDialog dialog = configureImageDialog;
        dialog.show((Function1<? super MarkdownImageData, Unit>)((Function1)new Function1<MarkdownImageData, Unit>(this, element2){
            final /* synthetic */ ConfigureImageLineMarkerProviderBase<T> this$0;
            final /* synthetic */ PsiElement $element;
            {
                this.this$0 = $receiver;
                this.$element = $element;
                super(1);
            }

            public final void invoke(@NotNull MarkdownImageData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.applyChanges(this.$element, it);
            }
        }));
    }

    @NotNull
    public String getName() {
        String string = MarkdownBundle.message("markdown.configure.markdown.image.line.marker.provider.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"markdown.config\u2026ne.marker.provider.name\")");
        return string;
    }

    private final String processFileName(String filePath) {
        try {
            String uri = URI.create(FileUtil.toSystemIndependentName((String)filePath)).getPath();
            Path path = Paths.get(uri, new String[0]).getFileName();
            return path != null ? ((Object)path).toString() : null;
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
        catch (InvalidPathException exception) {
            return null;
        }
    }

    private final String getMarkerElementPresentation(PsiElement element2) {
        String string;
        String string2;
        block6: {
            block5: {
                string2 = this.obtainPathText(element2);
                if (string2 == null) break block5;
                String p0 = string2;
                boolean bl = false;
                String string3 = this.processFileName(p0);
                string2 = string3;
                if (string3 != null) break block6;
            }
            string2 = "";
        }
        String fileName = string2;
        if (((CharSequence)fileName).length() == 0) {
            String string4 = MarkdownBundle.message("markdown.configure.image.text", new Object[0]);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"markdown.configure.image.text\")");
        } else {
            Object[] objectArray = new Object[]{fileName};
            String string5 = MarkdownBundle.message("markdown.configure.image.line.marker.presentation", objectArray);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"markdown.config\u2026.presentation\", fileName)");
        }
        return string;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/intellij/plugins/markdown/editor/images/ConfigureImageLineMarkerProviderBase$Companion;", "", "()V", "ALIGNMENT", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer$Alignment;", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0001H\u0016J\u001a\u0010\n\u001a\u00020\u000b2\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\rH\u0016J\u001a\u0010\u000e\u001a\u00020\u000f2\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/editor/images/ConfigureImageLineMarkerProviderBase$ConfigureImageLineMarkerInfo;", "Lcom/intellij/codeInsight/daemon/MergeableLineMarkerInfo;", "Lcom/intellij/psi/PsiElement;", "element", "textRange", "Lcom/intellij/openapi/util/TextRange;", "(Lorg/intellij/plugins/markdown/editor/images/ConfigureImageLineMarkerProviderBase;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;)V", "canMergeWith", "", "info", "getCommonIcon", "Ljavax/swing/Icon;", "infos", "", "getCommonIconAlignment", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer$Alignment;", "getElementPresentation", "", "intellij.markdown.core"})
    private final class ConfigureImageLineMarkerInfo
    extends MergeableLineMarkerInfo<PsiElement> {
        public ConfigureImageLineMarkerInfo(@NotNull PsiElement element2, TextRange textRange) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
            super(element2, textRange, MarkdownIcons.ImageGutter, arg_0 -> ConfigureImageLineMarkerInfo._init_$lambda$0((Function1)new Function1<PsiElement, String>((Object)ConfigureImageLineMarkerProviderBase.this){

                @NotNull
                public final String invoke(@NotNull PsiElement p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((ConfigureImageLineMarkerProviderBase)((Object)this.receiver)).getMarkerElementPresentation(p0);
                }
            }, arg_0), (arg_0, arg_1) -> ConfigureImageLineMarkerInfo._init_$lambda$1(ConfigureImageLineMarkerProviderBase.this, arg_0, arg_1), ALIGNMENT, ConfigureImageLineMarkerInfo::_init_$lambda$2);
        }

        @NotNull
        public String getElementPresentation(@NotNull PsiElement element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            return ConfigureImageLineMarkerProviderBase.this.getMarkerElementPresentation(element2);
        }

        public boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> info) {
            Intrinsics.checkNotNullParameter(info, (String)"info");
            return info instanceof ConfigureImageLineMarkerInfo;
        }

        @NotNull
        public Icon getCommonIcon(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
            Intrinsics.checkNotNullParameter(infos, (String)"infos");
            Icon icon = ((MergeableLineMarkerInfo)CollectionsKt.first(infos)).getIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"infos.first().icon");
            return icon;
        }

        @NotNull
        public GutterIconRenderer.Alignment getCommonIconAlignment(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
            Intrinsics.checkNotNullParameter(infos, (String)"infos");
            return ALIGNMENT;
        }

        private static final String _init_$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (String)$tmp0.invoke(p0);
        }

        private static final void _init_$lambda$1(ConfigureImageLineMarkerProviderBase this$0, MouseEvent mouseEvent, PsiElement e) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullExpressionValue((Object)e, (String)"e");
            this$0.performAction(e);
        }

        private static final String _init_$lambda$2() {
            return MarkdownBundle.message("markdown.configure.image.text", new Object[0]);
        }
    }
}

