/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.google.authorization;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.AppUIUtilKt;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0015\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\r\u0010\n\u001a\u00070\b\u00a2\u0006\u0002\b\tH\u0002J\b\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0003J\u000f\u0010\u000f\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/intellij/plugins/markdown/google/authorization/AuthResultPage;", "", "()V", "createAuthPage", "", "isSuccess", "", "createPanelContent", "Lcom/intellij/openapi/util/text/HtmlChunk$Element;", "Lorg/jetbrains/annotations/NotNull;", "createPanelHeader", "getApplicationIcon", "getMessageElement", "loadFileFromResource", "path", "loadIcon", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.markdown.core"})
public final class AuthResultPage {
    @NotNull
    public static final AuthResultPage INSTANCE = new AuthResultPage();

    private AuthResultPage() {
    }

    @NotNull
    public final String createAuthPage(boolean isSuccess) {
        HtmlChunk.Element element2 = HtmlChunk.html();
        HtmlChunk[] htmlChunkArray = new HtmlChunk[2];
        HtmlChunk.Element element3 = HtmlChunk.head();
        String string = this.loadFileFromResource("googleAuth/googleAuthPage.css");
        if (string == null) {
            string = "";
        }
        htmlChunkArray[0] = element3.child((HtmlChunk)HtmlChunk.styleTag((String)string));
        HtmlChunk[] htmlChunkArray2 = new HtmlChunk[]{this.createPanelHeader(), this.createPanelContent(isSuccess)};
        htmlChunkArray[1] = HtmlChunk.body().child((HtmlChunk)HtmlChunk.div().attr("class", "central-div-panel").children(htmlChunkArray2));
        String string2 = element2.children(htmlChunkArray).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"html()\n    .children(\n  \u2026ccess)))\n    ).toString()");
        return string2;
    }

    private final HtmlChunk.Element createPanelHeader() {
        HtmlChunk.Element element2 = HtmlChunk.div().attr("class", "central-div-header").child((HtmlChunk)HtmlChunk.div().attr("class", "central-div-header-text").addText("JetBrains"));
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"div()\n    .attr(\"class\",\u2026ddText(\"JetBrains\")\n    )");
        return element2;
    }

    private final HtmlChunk.Element createPanelContent(boolean isSuccess) {
        HtmlChunk[] htmlChunkArray = new HtmlChunk[]{this.getApplicationIcon(), this.getMessageElement(isSuccess)};
        HtmlChunk.Element element2 = HtmlChunk.div().attr("class", "central-div-content").children(htmlChunkArray);
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"div()\n    .attr(\"class\",\u2026eElement(isSuccess)\n    )");
        return element2;
    }

    private final String loadIcon() {
        String string = AppUIUtilKt.findAppIcon();
        if (string == null) {
            return null;
        }
        String icon = string;
        if (!StringsKt.endsWith$default((String)icon, (String)".svg", (boolean)false, (int)2, null)) {
            return null;
        }
        File file = new File(icon);
        if (file.exists() && file.isFile()) {
            return FilesKt.readText((File)file, (Charset)Charsets.UTF_8);
        }
        return null;
    }

    private final HtmlChunk.Element getApplicationIcon() {
        String string = this.loadIcon();
        if (string == null) {
            string = "";
        }
        String icon = string;
        HtmlChunk.Element element2 = HtmlChunk.div().attr("class", "central-div-app-icon").addRaw(icon);
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"div().attr(\"class\", \"cen\u2026v-app-icon\").addRaw(icon)");
        return element2;
    }

    private final HtmlChunk.Element getMessageElement(boolean isSuccess) {
        String string = isSuccess ? MarkdownBundle.message("markdown.google.auth.result.success", new Object[0]) : MarkdownBundle.message("markdown.google.auth.result.failed", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (isSuccess) MarkdownB\u2026ogle.auth.result.failed\")");
        String text2 = string;
        String icon = isSuccess ? this.loadFileFromResource("googleAuth/success.svg") : this.loadFileFromResource("googleAuth/error.svg");
        HtmlChunk.Element element2 = HtmlChunk.div().attr("class", "central-div-content");
        HtmlChunk[] htmlChunkArray = new HtmlChunk[2];
        HtmlChunk.Element element3 = HtmlChunk.div().attr("class", "central-div-content-icon");
        String string2 = icon;
        if (string2 == null) {
            string2 = "";
        }
        htmlChunkArray[0] = element3.addRaw(string2);
        htmlChunkArray[1] = HtmlChunk.div().attr("class", "central-div-content-text").addText(text2);
        HtmlChunk.Element element4 = element2.children(htmlChunkArray);
        Intrinsics.checkNotNullExpressionValue((Object)element4, (String)"div()\n      .attr(\"class\u2026t\").addText(text)\n      )");
        return element4;
    }

    @NlsSafe
    private final String loadFileFromResource(String path) {
        String string;
        InputStream inputStream;
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)"org.intellij.plugins.markdown"));
        if (ideaPluginDescriptor == null) {
            throw new IllegalStateException("Couldn't find markdown plugin descriptor");
        }
        IdeaPluginDescriptor plugin = ideaPluginDescriptor;
        ClassLoader loader = plugin.getPluginClassLoader();
        if (loader != null && (inputStream = loader.getResourceAsStream(path)) != null) {
            Reader reader = new InputStreamReader(inputStream, Charsets.UTF_8);
            int n = 8192;
            string = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
        } else {
            string = null;
        }
        return string;
    }
}

