/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.psi.impl;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.LocalTimeCounter;
import org.intellij.lang.xpath.XPathFile;
import org.intellij.lang.xpath.context.ContextProvider;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathVariableReference;
import org.jetbrains.annotations.NotNull;

public final class XPathChangeUtil {
    private XPathChangeUtil() {
    }

    @NotNull
    public static XPathExpression createExpression(PsiElement context, String text) {
        XPathFile file = XPathChangeUtil.createXPathFile(context, text);
        XPathExpression child = (XPathExpression)PsiTreeUtil.getChildOfType((PsiElement)file, XPathExpression.class);
        assert (child != null);
        XPathExpression xPathExpression = child;
        if (xPathExpression == null) {
            XPathChangeUtil.$$$reportNull$$$0(0);
        }
        return xPathExpression;
    }

    @NotNull
    public static XPathVariableReference createVariableReference(PsiElement context, String name) {
        return (XPathVariableReference)XPathChangeUtil.createExpression(context, "$" + name);
    }

    @NotNull
    public static XPathFile createXPathFile(PsiElement context, String text) {
        XPathFile file = XPathChangeUtil.createXPathFile(context.getProject(), text, context.getContainingFile().getFileType());
        ContextProvider.copy(context.getContainingFile(), file);
        XPathFile xPathFile = file;
        if (xPathFile == null) {
            XPathChangeUtil.$$$reportNull$$$0(1);
        }
        return xPathFile;
    }

    @NotNull
    public static XPathFile createXPathFile(Project project, String text, FileType fileType) {
        XPathFile xPathFile = (XPathFile)PsiFileFactory.getInstance((Project)project).createFileFromText("dummy." + fileType.getDefaultExtension(), fileType, (CharSequence)text, LocalTimeCounter.currentTime(), true);
        if (xPathFile == null) {
            XPathChangeUtil.$$$reportNull$$$0(2);
        }
        return xPathFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/intellij/lang/xpath/psi/impl/XPathChangeUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpression";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createXPathFile";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

