/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.daemon.impl.analysis.CreateNSDeclarationIntentionFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.patterns.XmlTagPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.TypeOrElementOrAttributeReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ProcessingContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.xpath.psi.XPath2TypeElement;
import org.intellij.lang.xpath.xslt.context.XsltNamespaceContext;
import org.intellij.lang.xpath.xslt.impl.references.PrefixReference;
import org.intellij.lang.xpath.xslt.impl.references.XsltReferenceProvider;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XsltReferenceContributor {
    private XsltReferenceContributor() {
    }

    static class SchemaTypeProvider
    extends PsiReferenceProvider {
        static final PsiReferenceProvider INSTANCE = new SchemaTypeProvider();

        SchemaTypeProvider() {
        }

        public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            PsiReference[] psiReferenceArray;
            SchemaTypeReference reference;
            if (element == null) {
                SchemaTypeProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                SchemaTypeProvider.$$$reportNull$$$0(1);
            }
            if ((reference = SchemaTypeReference.create(element)) != null) {
                PsiReference[] psiReferenceArray2 = new PsiReference[1];
                psiReferenceArray = psiReferenceArray2;
                psiReferenceArray2[0] = reference;
            } else {
                psiReferenceArray = PsiReference.EMPTY_ARRAY;
            }
            if (psiReferenceArray == null) {
                SchemaTypeProvider.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/xpath/xslt/impl/XsltReferenceContributor$SchemaTypeProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/xpath/xslt/impl/XsltReferenceContributor$SchemaTypeProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferencesByElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferencesByElement";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static final class SchemaTypeReference
    extends TypeOrElementOrAttributeReference
    implements EmptyResolveMessageProvider {
        private static final Pattern NAME_PATTERN = Pattern.compile("(?:[\\w-]+:)[\\w-]+");

        private SchemaTypeReference(PsiElement element, TextRange range) {
            super(element, range, TypeOrElementOrAttributeReference.ReferenceType.TypeReference);
        }

        @Nullable
        private static TextRange getTextRange(PsiElement element) {
            Matcher matcher = NAME_PATTERN.matcher(element.getText());
            if (matcher.find()) {
                return TextRange.create((int)matcher.start(), (int)matcher.end());
            }
            return null;
        }

        public boolean isSoft() {
            String text = this.getCanonicalText();
            return super.isSoft() || SchemaTypeReference.isType(text, "yearMonthDuration") || SchemaTypeReference.isType(text, "dayTimeDuration");
        }

        private static boolean isType(String text, String name) {
            return name.equals(text) || text.endsWith(":" + name);
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = XPathBundle.message("inspection.message.unknown.type", new Object[0]);
            if (string == null) {
                SchemaTypeReference.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nullable
        public static SchemaTypeReference create(PsiElement element) {
            TextRange range = SchemaTypeReference.getTextRange(element);
            return range != null ? new SchemaTypeReference(element, range) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/XsltReferenceContributor$SchemaTypeReference", "getUnresolvedMessagePattern"));
        }
    }

    static class NamespacePrefixReference
    extends PrefixReference
    implements LocalQuickFixProvider {
        NamespacePrefixReference(PsiElement element) {
            super((XmlAttribute)element.getParent());
        }

        public Object @NotNull [] getVariants() {
            Object[] objectArray = XsltNamespaceContext.getPrefixes((XmlElement)this.myAttribute).toArray();
            if (objectArray == null) {
                NamespacePrefixReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        public @NotNull LocalQuickFix @Nullable [] getQuickFixes() {
            XmlAttributeValue valueElement = this.myAttribute.getValueElement();
            if (valueElement != null) {
                return new LocalQuickFix[]{new CreateNSDeclarationIntentionFix((PsiElement)valueElement, this.getCanonicalText()){

                    public boolean showHint(@NotNull Editor editor) {
                        if (editor == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return false;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/intellij/lang/xpath/xslt/impl/XsltReferenceContributor$NamespacePrefixReference$1", "showHint"));
                    }
                }};
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/impl/XsltReferenceContributor$NamespacePrefixReference", "getVariants"));
        }
    }

    public static class XML
    extends PsiReferenceContributor {
        public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
            if (registrar == null) {
                XML.$$$reportNull$$$0(0);
            }
            XmlTagPattern xsltTag = (XmlTagPattern)XmlPatterns.xmlTag().withNamespace("http://www.w3.org/1999/XSL/Transform");
            registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue((String[])new String[]{"name", "href", "mode", "elements", "exclude-result-prefixes", "extension-element-prefixes", "stylesheet-prefix"}).withSuperParent(2, (ElementPattern)xsltTag), (PsiReferenceProvider)new XsltReferenceProvider());
            registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue((String[])new String[]{"as"}).withValue(StandardPatterns.string().matches("[^()]+")).withSuperParent(2, (ElementPattern)xsltTag), SchemaTypeProvider.INSTANCE);
            registrar.registerReferenceProvider((ElementPattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue((String[])new String[]{"as"}).withSuperParent(2, (ElementPattern)xsltTag)).withValue(StandardPatterns.string().contains(":")), new PsiReferenceProvider(){

                public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (context == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    PsiReference[] psiReferenceArray = new PsiReference[]{new NamespacePrefixReference(element)};
                    if (psiReferenceArray == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return psiReferenceArray;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 2 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "context";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "org/intellij/lang/xpath/xslt/impl/XsltReferenceContributor$XML$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "org/intellij/lang/xpath/xslt/impl/XsltReferenceContributor$XML$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getReferencesByElement";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getReferencesByElement";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 2 -> new IllegalStateException(string);
                    };
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/intellij/lang/xpath/xslt/impl/XsltReferenceContributor$XML", "registerReferenceProviders"));
        }
    }

    public static class XPath
    extends PsiReferenceContributor {
        public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
            if (registrar == null) {
                XPath.$$$reportNull$$$0(0);
            }
            registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(XPath2TypeElement.class), SchemaTypeProvider.INSTANCE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/intellij/lang/xpath/xslt/impl/XsltReferenceContributor$XPath", "registerReferenceProviders"));
        }
    }
}

