/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.swing.Icon;
import org.intellij.lang.xpath.completion.CompletionLists;
import org.intellij.lang.xpath.context.ContextProvider;
import org.intellij.lang.xpath.context.XPathVersion;
import org.intellij.lang.xpath.psi.XPathElement;
import org.intellij.lang.xpath.psi.XPathElementVisitor;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.psi.XsltElement;
import org.intellij.lang.xpath.xslt.psi.XsltElementFactory;
import org.intellij.lang.xpath.xslt.psi.impl.XsltLanguage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class XsltElementImpl
extends LightElement
implements Iconable,
PsiElementNavigationItem,
XsltElement,
ItemPresentation {
    @NotNull
    protected final XmlTag myElement;
    protected final XsltElementFactory myElementFactory;
    private final int myHashCode;
    private PsiElement myNavigationElement;

    protected XsltElementImpl(XmlTag target) {
        super(target.getManager(), (Language)XsltLanguage.INSTANCE);
        this.myElement = target;
        this.myHashCode = this.myElement.hashCode();
        this.myElementFactory = XsltElementFactory.getInstance();
    }

    public PsiElement copy() {
        return this.myElementFactory.wrapElement((XmlTag)this.myElement.copy(), this.getClass());
    }

    public String getText() {
        return this.myElement.getText();
    }

    @Override
    public XmlTag getTag() {
        return this.myElement;
    }

    @NotNull
    public final ItemPresentation getPresentation() {
        XsltElementImpl xsltElementImpl = this;
        if (xsltElementImpl == null) {
            XsltElementImpl.$$$reportNull$$$0(0);
        }
        return xsltElementImpl;
    }

    @Nullable
    public Icon getIcon(boolean open) {
        return this.getIcon(0);
    }

    @Nullable
    public String getLocationString() {
        return "(in " + this.getContainingFile().getName() + ")";
    }

    public String getPresentableText() {
        return this.getName();
    }

    public PsiElement getTargetElement() {
        return this.myElement;
    }

    @Nullable
    public String getName() {
        XmlAttributeValue nameElement = this.getNameElement();
        return nameElement != null ? nameElement.getValue() : null;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            XsltElementImpl.$$$reportNull$$$0(1);
        }
        assert (this.myElement.isValid());
        this.myElement.setAttribute("name", name);
        return this;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        if (this.myNavigationElement == null && this.myElement.isValid()) {
            Class[] allInterfaces = CompletionLists.getAllInterfaces(this.myElement.getClass());
            this.myNavigationElement = (PsiElement)Proxy.newProxyInstance(this.getClass().getClassLoader(), allInterfaces, new InvocationHandler(){

                @Override
                @Nullable
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    try {
                        XmlAttributeValue nameElement = XsltElementImpl.this.getNameElement();
                        return switch (method.getName()) {
                            case "navigate" -> {
                                if (!$assertionsDisabled && nameElement == null) {
                                    throw new AssertionError();
                                }
                                ((NavigationItem)nameElement).navigate(((Boolean)args[0]).booleanValue());
                                yield null;
                            }
                            case "canNavigate" -> {
                                NavigationItem item;
                                yield nameElement instanceof NavigationItem && (item = (NavigationItem)nameElement).canNavigate();
                            }
                            case "getTextOffset" -> nameElement != null ? nameElement.getTextOffset() : XsltElementImpl.this.myElement.getTextOffset();
                            default -> method.invoke((Object)XsltElementImpl.this.myElement, args);
                        };
                    }
                    catch (InvocationTargetException e1) {
                        throw e1.getTargetException();
                    }
                }
            });
        }
        XsltElementImpl xsltElementImpl = this.myElement.isValid() ? this.myNavigationElement : this;
        if (xsltElementImpl == null) {
            XsltElementImpl.$$$reportNull$$$0(2);
        }
        return xsltElementImpl;
    }

    @Nullable
    public XmlAttribute getNameAttribute() {
        return this.myElement.getAttribute("name", null);
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        XmlAttribute nameAttribute = this.getNameAttribute();
        return nameAttribute != null ? XsltSupport.getAttValueToken(nameAttribute) : null;
    }

    @Nullable
    private XmlAttributeValue getNameElement() {
        XmlAttribute attribute = this.getNameAttribute();
        return attribute != null ? attribute.getValueElement() : null;
    }

    public PsiElement getOriginalElement() {
        return this.myElement.getOriginalElement();
    }

    public boolean isValid() {
        return this.myElement.isValid();
    }

    @NotNull
    public Language getLanguage() {
        XsltLanguage xsltLanguage = XsltLanguage.INSTANCE;
        if (xsltLanguage == null) {
            XsltElementImpl.$$$reportNull$$$0(3);
        }
        return xsltLanguage;
    }

    public void navigate(boolean b) {
        XmlAttributeValue nameElement = this.getNameElement();
        assert (nameElement != null);
        ((NavigationItem)nameElement).navigate(b);
    }

    public boolean canNavigate() {
        XmlAttributeValue nameElement = this.getNameElement();
        return this.myElement.isValid() && nameElement instanceof NavigationItem && ((NavigationItem)nameElement).canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    public void accept(@NotNull XPathElementVisitor visitor) {
        if (visitor == null) {
            XsltElementImpl.$$$reportNull$$$0(4);
        }
        visitor.visitXPathElement((XPathElement)((Object)this));
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            XsltElementImpl.$$$reportNull$$$0(5);
        }
        if (visitor instanceof XPathElementVisitor && this instanceof XPathElement) {
            this.accept((XPathElementVisitor)visitor);
        } else {
            this.myElement.accept(visitor);
        }
    }

    public int hashCode() {
        return this.myHashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XsltElementImpl that = (XsltElementImpl)o;
        return this.myElement.equals(that.myElement);
    }

    public PsiFile getContainingFile() {
        return this.myElement.getContainingFile();
    }

    public boolean isWritable() {
        return this.myElement.isWritable();
    }

    public PsiElement getParent() {
        return this.myElement.getParent();
    }

    public PsiElement @NotNull [] getChildren() {
        PsiElement[] psiElementArray = this.myElement.getChildren();
        if (psiElementArray == null) {
            XsltElementImpl.$$$reportNull$$$0(6);
        }
        return psiElementArray;
    }

    public TextRange getTextRange() {
        XmlAttributeValue nameElement = this.getNameElement();
        return nameElement != null ? nameElement.getTextRange() : this.myElement.getTextRange();
    }

    public int getStartOffsetInParent() {
        XmlAttributeValue nameElement = this.getNameElement();
        return nameElement != null ? nameElement.getStartOffsetInParent() : this.myElement.getStartOffsetInParent();
    }

    public char @NotNull [] textToCharArray() {
        XmlAttributeValue nameElement = this.getNameElement();
        char[] cArray = nameElement != null ? nameElement.textToCharArray() : this.myElement.textToCharArray();
        if (cArray == null) {
            XsltElementImpl.$$$reportNull$$$0(7);
        }
        return cArray;
    }

    public int getTextOffset() {
        XmlAttributeValue nameElement = this.getNameElement();
        return nameElement != null ? nameElement.getTextOffset() : this.myElement.getTextOffset();
    }

    public ASTNode getNode() {
        XmlAttributeValue nameElement = this.getNameElement();
        return nameElement != null ? nameElement.getNode() : this.myElement.getNode();
    }

    public PsiReference @NotNull [] getReferences() {
        XmlAttributeValue nameElement = this.getNameElement();
        PsiReference[] psiReferenceArray = nameElement != null ? nameElement.getReferences() : this.myElement.getReferences();
        if (psiReferenceArray == null) {
            XsltElementImpl.$$$reportNull$$$0(8);
        }
        return psiReferenceArray;
    }

    public boolean textMatches(@NotNull CharSequence charSequence) {
        XmlAttributeValue nameElement;
        if (charSequence == null) {
            XsltElementImpl.$$$reportNull$$$0(9);
        }
        return (nameElement = this.getNameElement()) != null ? nameElement.textMatches(charSequence) : this.myElement.textMatches(charSequence);
    }

    public boolean textMatches(@NotNull PsiElement psiElement) {
        XmlAttributeValue nameElement;
        if (psiElement == null) {
            XsltElementImpl.$$$reportNull$$$0(10);
        }
        return (nameElement = this.getNameElement()) != null ? nameElement.textMatches(psiElement) : this.myElement.textMatches(psiElement);
    }

    public PsiElement findElementAt(int i) {
        XmlAttributeValue nameElement = this.getNameElement();
        return nameElement != null ? nameElement.findElementAt(i) : this.myElement.findElementAt(i);
    }

    public void delete() throws IncorrectOperationException {
        this.myElement.delete();
    }

    protected static <S, T extends S> T[] convertArray(S[] elements, Class<T> aClass) {
        Object[] t = ArrayUtil.newArray(aClass, (int)elements.length);
        System.arraycopy(elements, 0, t, 0, elements.length);
        return t;
    }

    public ContextProvider getXPathContext() {
        throw new UnsupportedOperationException();
    }

    public XPathVersion getXPathVersion() {
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4, 5, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/psi/impl/XsltElementImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charSequence";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/psi/impl/XsltElementImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 4, 5, 9, 10 -> new IllegalArgumentException(string);
        };
    }
}

