/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.IExternalSystemSourceType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.DefaultExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.ModelFactory;

public final class DefaultExternalSourceSet
implements ExternalSourceSet {
    private static final long serialVersionUID = 2L;
    private String name;
    private Map<ExternalSystemSourceType, DefaultExternalSourceDirectorySet> sources;
    private final LinkedHashSet<ExternalDependency> dependencies;
    private Collection<File> artifacts;
    private String sourceCompatibility;
    private String targetCompatibility;
    private String jdkInstallationPath;
    private boolean isPreview;

    public DefaultExternalSourceSet() {
        this.sources = new HashMap<ExternalSystemSourceType, DefaultExternalSourceDirectorySet>(0);
        this.dependencies = new LinkedHashSet(0);
        this.artifacts = new ArrayList<File>(0);
    }

    public DefaultExternalSourceSet(ExternalSourceSet sourceSet) {
        this.name = sourceSet.getName();
        this.sourceCompatibility = sourceSet.getSourceCompatibility();
        this.targetCompatibility = sourceSet.getTargetCompatibility();
        this.isPreview = sourceSet.isPreview();
        Set entrySet = sourceSet.getSources().entrySet();
        this.sources = new HashMap<ExternalSystemSourceType, DefaultExternalSourceDirectorySet>(entrySet.size());
        for (Map.Entry entry : entrySet) {
            this.sources.put(ExternalSystemSourceType.from((IExternalSystemSourceType)((IExternalSystemSourceType)entry.getKey())), new DefaultExternalSourceDirectorySet((ExternalSourceDirectorySet)entry.getValue()));
        }
        this.dependencies = new LinkedHashSet(sourceSet.getDependencies().size());
        for (ExternalDependency dependency : sourceSet.getDependencies()) {
            this.dependencies.add(ModelFactory.createCopy(dependency));
        }
        this.artifacts = sourceSet.getArtifacts() == null ? new ArrayList<File>(0) : new ArrayList(sourceSet.getArtifacts());
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            DefaultExternalSourceSet.$$$reportNull$$$0(0);
        }
        return string;
    }

    public Collection<File> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(Collection<File> artifacts) {
        this.artifacts = artifacts;
    }

    @Nullable
    public String getSourceCompatibility() {
        return this.sourceCompatibility;
    }

    public boolean isPreview() {
        return this.isPreview;
    }

    public void setPreview(boolean preview) {
        this.isPreview = preview;
    }

    public void setSourceCompatibility(@Nullable String sourceCompatibility) {
        this.sourceCompatibility = sourceCompatibility;
    }

    @Nullable
    public String getTargetCompatibility() {
        return this.targetCompatibility;
    }

    public void setTargetCompatibility(@Nullable String targetCompatibility) {
        this.targetCompatibility = targetCompatibility;
    }

    public Collection<ExternalDependency> getDependencies() {
        return this.dependencies;
    }

    public void setName(String name) {
        this.name = name;
    }

    @NotNull
    public Map<? extends IExternalSystemSourceType, ? extends ExternalSourceDirectorySet> getSources() {
        Map<ExternalSystemSourceType, DefaultExternalSourceDirectorySet> map = this.sources;
        if (map == null) {
            DefaultExternalSourceSet.$$$reportNull$$$0(1);
        }
        return map;
    }

    public void setSources(Map<ExternalSystemSourceType, DefaultExternalSourceDirectorySet> sources) {
        this.sources = sources;
    }

    public String toString() {
        return "sourceSet '" + this.name + '\'';
    }

    @Nullable
    public String getJdkInstallationPath() {
        return this.jdkInstallationPath;
    }

    public void setJdkInstallationPath(@Nullable String jdkInstallationPath) {
        this.jdkInstallationPath = jdkInstallationPath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/gradle/model/DefaultExternalSourceSet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSources";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

