/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.util.resolve.deprecated;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.tooling.util.StringUtils;
import org.jetbrains.plugins.gradle.tooling.util.resolve.deprecated.DeprecatedDependencyResolver;
import org.jetbrains.plugins.gradle.tooling.util.resolve.deprecated.ExternalDepsResolutionResult;

@Deprecated
public class CompileDependenciesProvider {
    public static final String SCOPE = "COMPILE";
    private final SourceSet mySourceSet;
    private final Project myProject;
    private Configuration myConfiguration;
    private Configuration myCompileClasspathConfiguration;
    private Configuration myCompileConfiguration;
    private Configuration myCompileOnlyConfiguration;
    private Collection<ExternalDependency> myDependencies;
    private Collection<File> myFiles;
    private final Map<Configuration, Set<File>> myConfigurationFilesCache = new HashMap<Configuration, Set<File>>();

    public CompileDependenciesProvider(SourceSet sourceSet, Project project) {
        this.mySourceSet = sourceSet;
        this.myProject = project;
    }

    public Set<File> getDeprecatedCompileConfigurationFiles() {
        return this.getFilesFromCache(this.myConfiguration);
    }

    public Configuration getCompileClasspathConfiguration() {
        return this.myCompileClasspathConfiguration;
    }

    public Set<File> getCompileConfigurationFiles() {
        return this.getFilesFromCache(this.myCompileConfiguration);
    }

    public Set<File> getCompileOnlyConfigurationFiles() {
        return this.getFilesFromCache(this.myCompileOnlyConfiguration);
    }

    private Set<File> getFilesFromCache(Configuration key) {
        if (key == null) {
            return null;
        }
        Set cached = this.myConfigurationFilesCache.get(key);
        if (cached == null) {
            cached = key.getResolvedConfiguration().getLenientConfiguration().getFiles(Specs.SATISFIES_ALL);
            this.myConfigurationFilesCache.put(key, cached);
        }
        return cached;
    }

    public Collection<ExternalDependency> getDependencies() {
        return this.myDependencies;
    }

    public Collection<File> getFiles() {
        return this.myFiles;
    }

    public CompileDependenciesProvider resolve(DeprecatedDependencyResolver resolver) {
        boolean isMainSourceSet = this.mySourceSet.getName().equals("main");
        String deprecatedCompileConfigurationName = isMainSourceSet ? "compile" : StringUtils.toCamelCase(this.mySourceSet.getName(), false) + "Compile";
        Object configurationName = DeprecatedDependencyResolver.invokeMethod(this.mySourceSet, "getCompileConfigurationName", new Object[0]);
        assert (configurationName != null);
        String compileConfigurationName = configurationName.toString();
        this.myConfiguration = (Configuration)this.myProject.getConfigurations().findByName(deprecatedCompileConfigurationName);
        this.myCompileClasspathConfiguration = (Configuration)this.myProject.getConfigurations().findByName(compileConfigurationName + "Classpath");
        this.myCompileConfiguration = (Configuration)this.myProject.getConfigurations().findByName(compileConfigurationName);
        Configuration compileConfiguration = this.myCompileClasspathConfiguration != null ? this.myCompileClasspathConfiguration : this.myCompileConfiguration;
        this.myCompileOnlyConfiguration = DeprecatedDependencyResolver.isJavaLibraryPluginSupported ? (Configuration)this.myProject.getConfigurations().findByName(this.mySourceSet.getCompileOnlyConfigurationName()) : null;
        ExternalDepsResolutionResult externalDepsResolutionResult = resolver.resolveDependencies(compileConfiguration, SCOPE);
        this.myDependencies = externalDepsResolutionResult.getExternalDeps();
        this.myFiles = externalDepsResolutionResult.getResolvedFiles();
        return this;
    }
}

