/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api.auth.twoFA;

import circlet.client.api.ProfileIdentifier;
import circlet.client.api.auth.twoFA.Profile2FARequirement;
import circlet.client.api.auth.twoFA.TwoFactorAuthenticationSecret;
import circlet.client.api.auth.twoFA.TwoFactorAuthenticationStatus;
import circlet.common.permissions.EditTwoFactorAuthentication;
import circlet.common.permissions.SetUpTwoFactorAuthentication;
import circlet.common.permissions.ViewProfile;
import circlet.platform.api.Api;
import circlet.platform.api.annotations.DefaultParameterValues;
import circlet.platform.api.annotations.Http;
import circlet.platform.api.annotations.HttpApi;
import circlet.platform.api.annotations.HttpApiDoc;
import circlet.platform.api.annotations.Rest;
import circlet.platform.api.annotations.Rights;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import platform.common.ApiFlag;
import platform.common.ApiFlagAnnotation;
import platform.common.ApiFlags;
import platform.common.SpaceOnPremiseVersions;

@HttpApi(resource="team-directory/profiles")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\bg\u0018\u00002\u00020\u0001:\u0001\u0017J!\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u001f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0004\u001a\u00020\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u0019\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ%\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0019\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ-\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Lcirclet/client/api/auth/twoFA/TwoFactorAuthentications;", "Lcirclet/platform/api/Api;", "confirmTotp", "", "profile", "Lcirclet/client/api/ProfileIdentifier;", "code", "", "(Lcirclet/client/api/ProfileIdentifier;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getTwoFactorAuthenticationRequirements", "", "Lcirclet/client/api/auth/twoFA/Profile2FARequirement;", "(Lcirclet/client/api/ProfileIdentifier;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getTwoFactorAuthenticationStatus", "Lcirclet/client/api/auth/twoFA/TwoFactorAuthenticationStatus;", "removeTotp", "(Lcirclet/client/api/ProfileIdentifier;Ljava/lang/Integer;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setUpTotp", "Lcirclet/client/api/auth/twoFA/TwoFactorAuthenticationSecret;", "updateTotp", "enabled", "", "(Lcirclet/client/api/ProfileIdentifier;ZLjava/lang/Integer;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Flags", "client-api"})
public interface TwoFactorAuthentications
extends Api {
    @Rest.Get(path="{profile}/2-fa/status", displayName="Two-factor authentication status")
    @HttpApiDoc(doc="Get two-factor authentication status for a given profile ID. The response indicates whether two-factor authentication is active, not active, or not set up yet.")
    @Rights(rights={ViewProfile.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object getTwoFactorAuthenticationStatus(@NotNull ProfileIdentifier var1, @NotNull Continuation<? super TwoFactorAuthenticationStatus> var2);

    @Rest.Query(path="{profile}/2-fa/requirements", displayName="Two-factor authentication requirements")
    @HttpApiDoc(doc="Get two-factor authentication requirements for a given profile ID. The response indicates whether two-factor authentication is required by participation in some permission roles.")
    @Rights(rights={ViewProfile.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object getTwoFactorAuthenticationRequirements(@NotNull ProfileIdentifier var1, @NotNull Continuation<? super List<Profile2FARequirement>> var2);

    @Rest.Create(path="{profile}/2-fa/totp", displayName="Set up TOTP two-factor authentication")
    @HttpApiDoc(doc="Set up two-factor authentication using TOTP (Time-based One-time Password) for a given profile ID. The response will return a QR code (base64 encoded) that can be scanned with an app to setup two-factor authentication. The code that the app generates has to be confirmed in Space to enable TOTP.")
    @Rights(rights={SetUpTwoFactorAuthentication.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object setUpTotp(@NotNull ProfileIdentifier var1, @NotNull Continuation<? super TwoFactorAuthenticationSecret> var2);

    @Http.Post(path="{profile}/2-fa/totp/confirm", displayName="Confirm TOTP two-factor authentication settings")
    @HttpApiDoc(doc="Confirm two-factor authentication for a given profile ID using a TOTP (Time-based One-time Password) code from an app.")
    @Rights(rights={SetUpTwoFactorAuthentication.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object confirmTotp(@NotNull ProfileIdentifier var1, int var2, @NotNull Continuation<? super Unit> var3);

    @Rest.Update(path="{profile}/2-fa/totp", displayName="Update TOTP two-factor authentication settings")
    @HttpApiDoc(doc="Enable/disable two-factor authentication settings for a given profile ID")
    @Rights(rights={EditTwoFactorAuthentication.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object updateTotp(@NotNull ProfileIdentifier var1, boolean var2, @ApiFlagAnnotation(cls=Flags.RequireCodeOnDisablingOrDeleting2FA.class) @Nullable Integer var3, @NotNull Continuation<? super Unit> var4);

    @Rest.Delete(path="{profile}/2-fa/totp", displayName="Delete current TOTP two-factor authentication settings")
    @HttpApiDoc(doc="Remove two-factor authentication settings for a given profile ID. Previously generated TOTP (Time-based One-time Password) are rendered invalid.")
    @Rights(rights={EditTwoFactorAuthentication.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object removeTotp(@NotNull ProfileIdentifier var1, @ApiFlagAnnotation(cls=Flags.RequireCodeOnDisablingOrDeleting2FA.class) @Nullable Integer var2, @NotNull Continuation<? super Unit> var3);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcirclet/client/api/auth/twoFA/TwoFactorAuthentications$Flags;", "Lplatform/common/ApiFlags;", "()V", "RequireCodeOnDisablingOrDeleting2FA", "client-api"})
    public static final class Flags
    extends ApiFlags {
        @NotNull
        public static final Flags INSTANCE = new Flags();

        private Flags() {
            super("twoFactorAuthentication");
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcirclet/client/api/auth/twoFA/TwoFactorAuthentications$Flags$RequireCodeOnDisablingOrDeleting2FA;", "Lplatform/common/ApiFlag;", "()V", "client-api"})
        public static final class RequireCodeOnDisablingOrDeleting2FA
        extends ApiFlag {
            @NotNull
            public static final RequireCodeOnDisablingOrDeleting2FA INSTANCE = new RequireCodeOnDisablingOrDeleting2FA();

            private RequireCodeOnDisablingOrDeleting2FA() {
                super(1, INSTANCE, SpaceOnPremiseVersions.INSTANCE.getV2023_2());
            }
        }
    }
}

