/*
 * Decompiled with CFR 0.152.
 */
package circlet.code.github;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\nJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcirclet/code/github/GitHubCommonUtil;", "", "()V", "GITHUB_HTTPS_URL_PATTERN", "Lkotlin/text/Regex;", "getGITHUB_HTTPS_URL_PATTERN", "()Lkotlin/text/Regex;", "GITHUB_SSH_URL_PATTERN", "getGITHUB_SSH_URL_PATTERN", "getGitHubApiURL", "", "repo", "getGitHubPullRequestURL", "pr", "", "getGitHubRepoNameFromURL", "url", "getGitHubWebhookPageURL", "isGitHubRepository", "", "parseGithubURLSafe", "Lcirclet/code/github/GitHubCommonUtil$GitHubRepoName;", "GitHubRepoName", "code-common"})
@SourceDebugExtension(value={"SMAP\nGitHubCommonUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitHubCommonUtil.kt\ncirclet/code/github/GitHubCommonUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,31:1\n1#2:32\n*E\n"})
public final class GitHubCommonUtil {
    @NotNull
    public static final GitHubCommonUtil INSTANCE = new GitHubCommonUtil();
    @NotNull
    private static final Regex GITHUB_HTTPS_URL_PATTERN = new Regex("^https://github\\.com/(.*?)/(.*?)(\\.git|/.*)?$");
    @NotNull
    private static final Regex GITHUB_SSH_URL_PATTERN = new Regex("^git@github\\.com:(.*?)/(.*?)\\.git$");

    private GitHubCommonUtil() {
    }

    @NotNull
    public final Regex getGITHUB_HTTPS_URL_PATTERN() {
        return GITHUB_HTTPS_URL_PATTERN;
    }

    @NotNull
    public final Regex getGITHUB_SSH_URL_PATTERN() {
        return GITHUB_SSH_URL_PATTERN;
    }

    public final boolean isGitHubRepository(@NotNull String url2) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        return this.parseGithubURLSafe(url2) != null;
    }

    @Nullable
    public final GitHubRepoName parseGithubURLSafe(@NotNull String url2) {
        GitHubRepoName gitHubRepoName;
        MatchResult matchResult;
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        MatchResult matchResult2 = GITHUB_HTTPS_URL_PATTERN.matchEntire((CharSequence)url2);
        if (matchResult2 == null) {
            matchResult2 = GITHUB_SSH_URL_PATTERN.matchEntire((CharSequence)url2);
        }
        if ((matchResult = matchResult2) != null) {
            MatchResult it = matchResult;
            boolean bl = false;
            gitHubRepoName = new GitHubRepoName((String)it.getGroupValues().get(1), (String)it.getGroupValues().get(2));
        } else {
            gitHubRepoName = null;
        }
        return gitHubRepoName;
    }

    @Nullable
    public final String getGitHubRepoNameFromURL(@NotNull String url2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        GitHubRepoName gitHubRepoName = this.parseGithubURLSafe(url2);
        if (gitHubRepoName != null) {
            GitHubRepoName it = gitHubRepoName;
            boolean bl = false;
            string2 = it.getOwner() + "/" + it.getRepository();
        } else {
            string2 = null;
        }
        return string2;
    }

    @NotNull
    public final String getGitHubApiURL(@NotNull String repo) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        return "https://api.github.com/repos/" + this.getGitHubRepoNameFromURL(repo);
    }

    @NotNull
    public final String getGitHubWebhookPageURL(@NotNull String repo) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        return "https://github.com/" + this.getGitHubRepoNameFromURL(repo) + "/settings/hooks";
    }

    @NotNull
    public final String getGitHubPullRequestURL(@NotNull String repo, int pr) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        return "https://github.com/" + this.getGitHubRepoNameFromURL(repo) + "/pull/" + pr;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcirclet/code/github/GitHubCommonUtil$GitHubRepoName;", "", "owner", "", "repository", "(Ljava/lang/String;Ljava/lang/String;)V", "getOwner", "()Ljava/lang/String;", "getRepository", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "code-common"})
    public static final class GitHubRepoName {
        @NotNull
        private final String owner;
        @NotNull
        private final String repository;

        public GitHubRepoName(@NotNull String owner, @NotNull String repository2) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            this.owner = owner;
            this.repository = repository2;
        }

        @NotNull
        public final String getOwner() {
            return this.owner;
        }

        @NotNull
        public final String getRepository() {
            return this.repository;
        }

        @NotNull
        public final String component1() {
            return this.owner;
        }

        @NotNull
        public final String component2() {
            return this.repository;
        }

        @NotNull
        public final GitHubRepoName copy(@NotNull String owner, @NotNull String repository2) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            return new GitHubRepoName(owner, repository2);
        }

        public static /* synthetic */ GitHubRepoName copy$default(GitHubRepoName gitHubRepoName, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = gitHubRepoName.owner;
            }
            if ((n & 2) != 0) {
                string3 = gitHubRepoName.repository;
            }
            return gitHubRepoName.copy(string2, string3);
        }

        @NotNull
        public String toString() {
            return "GitHubRepoName(owner=" + this.owner + ", repository=" + this.repository + ")";
        }

        public int hashCode() {
            int result2 = this.owner.hashCode();
            result2 = result2 * 31 + this.repository.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GitHubRepoName)) {
                return false;
            }
            GitHubRepoName gitHubRepoName = (GitHubRepoName)other;
            if (!Intrinsics.areEqual((Object)this.owner, (Object)gitHubRepoName.owner)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.repository, (Object)gitHubRepoName.repository);
        }
    }
}

