/*
 * Decompiled with CFR 0.152.
 */
package circlet.code.gitlab;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000e\u001a\u00020\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcirclet/code/gitlab/GitLabCommonUtil;", "", "()V", "GITLAB_HTTPS_URL_PATTERN", "Lkotlin/text/Regex;", "getGITLAB_HTTPS_URL_PATTERN", "()Lkotlin/text/Regex;", "GITLAB_SSH_URL_PATTERN", "getGITLAB_SSH_URL_PATTERN", "getGitLabWebhookPageURL", "", "repoUrl", "isGitLabRepository", "", "url", "parseGitlabURLSafe", "Lcirclet/code/gitlab/GitLabCommonUtil$GitLabRepoName;", "GitLabRepoName", "code-common"})
@SourceDebugExtension(value={"SMAP\nGitLabCommonUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabCommonUtil.kt\ncirclet/code/gitlab/GitLabCommonUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,20:1\n1#2:21\n*E\n"})
public final class GitLabCommonUtil {
    @NotNull
    public static final GitLabCommonUtil INSTANCE = new GitLabCommonUtil();
    @NotNull
    private static final Regex GITLAB_HTTPS_URL_PATTERN = new Regex("^https://gitlab\\.com/(.*?)/(.*?)(\\.git|/.*)?$");
    @NotNull
    private static final Regex GITLAB_SSH_URL_PATTERN = new Regex("^git@gitlab\\.com:(.*?)/(.*?)\\.git$");

    private GitLabCommonUtil() {
    }

    @NotNull
    public final Regex getGITLAB_HTTPS_URL_PATTERN() {
        return GITLAB_HTTPS_URL_PATTERN;
    }

    @NotNull
    public final Regex getGITLAB_SSH_URL_PATTERN() {
        return GITLAB_SSH_URL_PATTERN;
    }

    public final boolean isGitLabRepository(@NotNull String url2) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        return this.parseGitlabURLSafe(url2) != null;
    }

    @Nullable
    public final GitLabRepoName parseGitlabURLSafe(@NotNull String url2) {
        GitLabRepoName gitLabRepoName;
        MatchResult matchResult;
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        MatchResult matchResult2 = GITLAB_HTTPS_URL_PATTERN.matchEntire((CharSequence)url2);
        if (matchResult2 == null) {
            matchResult2 = GITLAB_SSH_URL_PATTERN.matchEntire((CharSequence)url2);
        }
        if ((matchResult = matchResult2) != null) {
            MatchResult it = matchResult;
            boolean bl = false;
            gitLabRepoName = new GitLabRepoName((String)it.getGroupValues().get(1), (String)it.getGroupValues().get(2));
        } else {
            gitLabRepoName = null;
        }
        return gitLabRepoName;
    }

    @NotNull
    public final String getGitLabWebhookPageURL(@NotNull String repoUrl) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)repoUrl, (String)"repoUrl");
        GitLabRepoName gitLabRepoName = this.parseGitlabURLSafe(repoUrl);
        if (gitLabRepoName != null) {
            GitLabRepoName it = gitLabRepoName;
            boolean bl = false;
            string2 = it.getOwner() + "/" + it.getRepository();
        } else {
            string2 = null;
        }
        return "https://gitlab.com/" + string2 + "/-/hooks";
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcirclet/code/gitlab/GitLabCommonUtil$GitLabRepoName;", "", "owner", "", "repository", "(Ljava/lang/String;Ljava/lang/String;)V", "getOwner", "()Ljava/lang/String;", "getRepository", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "code-common"})
    public static final class GitLabRepoName {
        @NotNull
        private final String owner;
        @NotNull
        private final String repository;

        public GitLabRepoName(@NotNull String owner, @NotNull String repository2) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            this.owner = owner;
            this.repository = repository2;
        }

        @NotNull
        public final String getOwner() {
            return this.owner;
        }

        @NotNull
        public final String getRepository() {
            return this.repository;
        }

        @NotNull
        public final String component1() {
            return this.owner;
        }

        @NotNull
        public final String component2() {
            return this.repository;
        }

        @NotNull
        public final GitLabRepoName copy(@NotNull String owner, @NotNull String repository2) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            return new GitLabRepoName(owner, repository2);
        }

        public static /* synthetic */ GitLabRepoName copy$default(GitLabRepoName gitLabRepoName, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = gitLabRepoName.owner;
            }
            if ((n & 2) != 0) {
                string3 = gitLabRepoName.repository;
            }
            return gitLabRepoName.copy(string2, string3);
        }

        @NotNull
        public String toString() {
            return "GitLabRepoName(owner=" + this.owner + ", repository=" + this.repository + ")";
        }

        public int hashCode() {
            int result2 = this.owner.hashCode();
            result2 = result2 * 31 + this.repository.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GitLabRepoName)) {
                return false;
            }
            GitLabRepoName gitLabRepoName = (GitLabRepoName)other;
            if (!Intrinsics.areEqual((Object)this.owner, (Object)gitLabRepoName.owner)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.repository, (Object)gitLabRepoName.repository);
        }
    }
}

