/*
 * Decompiled with CFR 0.152.
 */
package circlet.code.review.discussions;

import circlet.client.api.CodeLine;
import circlet.client.api.DeclarationsDiff;
import circlet.client.api.FileContent;
import circlet.client.api.FileContentDiff;
import circlet.client.api.InlineDiff;
import circlet.client.api.SideBySideDiff;
import circlet.client.api.code.DiffLineNumber;
import circlet.code.review.discussions.DiffLine;
import circlet.code.review.discussions.DiffLineKt;
import circlet.code.review.discussions.DiffLineRange;
import circlet.code.review.discussions.DiffLineRangeCalculatorKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import libraries.klogging.KLogger;
import org.jetbrains.annotations.NotNull;
import runtime.code.InlineDiffLine;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0016J\u001e\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0018j\b\u0012\u0004\u0012\u00020\u0007`\u00192\u0006\u0010\u0010\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcirclet/code/review/discussions/DiffLineRangeCalculator;", "", "diff", "Lcirclet/client/api/FileContentDiff;", "(Lcirclet/client/api/FileContentDiff;)V", "lineNumberIndices", "", "Lcirclet/client/api/code/DiffLineNumber;", "", "lines", "", "Lcirclet/code/review/discussions/DiffLine;", "newLinesCount", "oldLinesCount", "getLinesContent", "Lcirclet/client/api/CodeLine;", "range", "Lkotlin/ranges/IntRange;", "type", "Lcirclet/client/api/code/DiffLineNumber$Side;", "linesCount", "normalizeRange", "Lcirclet/code/review/discussions/DiffLineRange;", "rangeToLines", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "code-app-state"})
@SourceDebugExtension(value={"SMAP\nDiffLineRangeCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffLineRangeCalculator.kt\ncirclet/code/review/discussions/DiffLineRangeCalculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 KLogger.kt\nlibraries/klogging/KLogger\n*L\n1#1,68:1\n1559#2:69\n1590#2,4:70\n1774#2,4:74\n1774#2,4:78\n1603#2,9:82\n1855#2:91\n1856#2:94\n1612#2:95\n1549#2:101\n1620#2,3:102\n766#2:105\n857#2,2:106\n1#3:92\n1#3:93\n35#4,5:96\n*S KotlinDebug\n*F\n+ 1 DiffLineRangeCalculator.kt\ncirclet/code/review/discussions/DiffLineRangeCalculator\n*L\n12#1:69\n12#1:70,4\n15#1:74,4\n21#1:78,4\n34#1:82,9\n34#1:91\n34#1:94\n34#1:95\n55#1:101\n55#1:102,3\n61#1:105\n61#1:106,2\n34#1:93\n51#1:96,5\n*E\n"})
public final class DiffLineRangeCalculator {
    @NotNull
    private final FileContentDiff diff;
    @NotNull
    private final List<DiffLine> lines;
    @NotNull
    private final Map<DiffLineNumber, Integer> lineNumberIndices;
    private final int oldLinesCount;
    private final int newLinesCount;

    /*
     * WARNING - void declaration
     */
    public DiffLineRangeCalculator(@NotNull FileContentDiff diff) {
        int n;
        int n2;
        InlineDiffLine it;
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        this.diff = diff;
        this.lines = DiffLineKt.toDiffLines(this.diff);
        Object object = this.lines;
        DiffLineRangeCalculator diffLineRangeCalculator = this;
        boolean $i$f$mapIndexed2 = false;
        void var4_7 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index2;
            void diffLine;
            int n3;
            if ((n3 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            DiffLine diffLine2 = (DiffLine)item$iv$iv;
            int n4 = n3;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)diffLine.getNumber(), (Object)((int)index2)));
        }
        diffLineRangeCalculator.lineNumberIndices = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        DiffLineRangeCalculator diffLineRangeCalculator2 = this;
        object = this.diff;
        if (object instanceof InlineDiff) {
            int n5;
            void $this$count$iv;
            Iterable $i$f$mapIndexed2 = ((InlineDiff)this.diff).getLines();
            diffLineRangeCalculator = diffLineRangeCalculator2;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n5 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    it = (InlineDiffLine)element$iv;
                    boolean bl = false;
                    if (!(it.getOldLineNum() != null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n5 = count$iv;
            }
            int n6 = n5;
            diffLineRangeCalculator2 = diffLineRangeCalculator;
            n2 = n6;
        } else if (object instanceof SideBySideDiff) {
            Object object2 = ((SideBySideDiff)this.diff).getLeft();
            n2 = object2 != null && (object2 = ((FileContent)object2).getLines()) != null ? object2.size() : 0;
        } else if (object instanceof DeclarationsDiff) {
            n2 = 0;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        diffLineRangeCalculator2.oldLinesCount = n2;
        DiffLineRangeCalculator diffLineRangeCalculator3 = this;
        object = this.diff;
        if (object instanceof InlineDiff) {
            int n7;
            Iterable $this$count$iv = ((InlineDiff)this.diff).getLines();
            diffLineRangeCalculator = diffLineRangeCalculator3;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n7 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    it = (InlineDiffLine)element$iv;
                    boolean bl = false;
                    if (!(it.getNewLineNum() != null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n7 = count$iv;
            }
            int n8 = n7;
            diffLineRangeCalculator3 = diffLineRangeCalculator;
            n = n8;
        } else if (object instanceof SideBySideDiff) {
            Object object3 = ((SideBySideDiff)this.diff).getRight();
            n = object3 != null && (object3 = ((FileContent)object3).getLines()) != null ? object3.size() : 0;
        } else if (object instanceof DeclarationsDiff) {
            n = 0;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        diffLineRangeCalculator3.newLinesCount = n;
    }

    public final int linesCount(@NotNull DiffLineNumber.Side type2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1: {
                n = this.newLinesCount;
                break;
            }
            case 2: {
                n = this.oldLinesCount;
                break;
            }
            default: {
                throw new IllegalStateException("trying to get lines count for empty side of the diff".toString());
            }
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CodeLine> getLinesContent(@NotNull IntRange range3, @NotNull DiffLineNumber.Side type2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)range3, (String)"range");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        Iterable $this$mapNotNull$iv = (Iterable)range3;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            CodeLine codeLine;
            int element$iv$iv$iv;
            int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            int it = element$iv$iv;
            boolean bl2 = false;
            Integer n = this.lineNumberIndices.get(new DiffLineNumber(it, type2));
            if (n != null) {
                int it2 = ((Number)n).intValue();
                boolean bl3 = false;
                codeLine = this.lines.get(it2).getLine();
            } else {
                codeLine = null;
            }
            if (codeLine == null) continue;
            CodeLine it$iv$iv = codeLine;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final DiffLineRange normalizeRange(@NotNull DiffLineRange range3) {
        Intrinsics.checkNotNullParameter((Object)range3, (String)"range");
        Integer n = this.lineNumberIndices.get(range3.getStart());
        if (n == null) {
            return range3;
        }
        int startIndex = n;
        Integer n2 = this.lineNumberIndices.get(range3.getEndInclusive());
        if (n2 == null) {
            return range3;
        }
        int endIndex = n2;
        return startIndex > endIndex ? new DiffLineRange(range3.getEndInclusive(), range3.getStart()) : range3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LinkedHashSet<DiffLineNumber> rangeToLines(@NotNull DiffLineRange range3) {
        DiffLineNumber lastLine;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)range3, (String)"range");
        Integer n = this.lineNumberIndices.get(range3.getStart());
        if (n == null) {
            return new LinkedHashSet<DiffLineNumber>();
        }
        int startIndex = n;
        Integer n2 = this.lineNumberIndices.get(range3.getEndInclusive());
        if (n2 == null) {
            return new LinkedHashSet<DiffLineNumber>();
        }
        int endIndex = n2;
        if (startIndex > endIndex) {
            KLogger this_$iv = DiffLineRangeCalculatorKt.access$getLog$p();
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                boolean bl = false;
                String msgStr$iv = "startIndex " + startIndex + " is bigger than the end one " + endIndex + ", use normalizeRange() to avoid this";
                this_$iv.error(msgStr$iv);
            }
            return new LinkedHashSet<DiffLineNumber>();
        }
        Iterable $this$map$iv = this.lines;
        boolean $i$f$map = false;
        Iterable msgStr$iv = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DiffLine diffLine = (DiffLine)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getNumber());
        }
        List rangeLines = ((List)destination$iv$iv).subList(startIndex, endIndex + 1);
        if (this.diff instanceof SideBySideDiff && (lastLine = (DiffLineNumber)CollectionsKt.lastOrNull(rangeLines)) != null && lastLine.getType() == DiffLineNumber.Side.NEW) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = rangeLines;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DiffLineNumber it = (DiffLineNumber)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() != DiffLineNumber.Side.EMPTY_OLD || it.getNumber() <= lastLine.getNumber())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            rangeLines = (List)destination$iv$iv2;
        }
        return new LinkedHashSet<DiffLineNumber>(rangeLines);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DiffLineNumber.Side.values().length];
            try {
                nArray[DiffLineNumber.Side.NEW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiffLineNumber.Side.OLD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

