/*
 * Decompiled with CFR 0.152.
 */
package circlet.common.documents;

import circlet.common.documents.DocumentPermissionChecker;
import circlet.common.permissions.ArchiveDocuments;
import circlet.common.permissions.DeleteDocumentsForever;
import circlet.common.permissions.EditDocuments;
import circlet.common.permissions.ManageDocuments;
import circlet.common.permissions.ManageDocuments2;
import circlet.common.permissions.Right;
import circlet.common.permissions.ViewDocuments;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\r"}, d2={"Lcirclet/common/documents/DocumentPermissions;", "", "()V", "canAdministrate", "", "checker", "Lcirclet/common/documents/DocumentPermissionChecker;", "canArchive", "canBeMoved", "canDeleteForever", "canEdit", "canRestore", "canView", "common"})
public final class DocumentPermissions {
    @NotNull
    public static final DocumentPermissions INSTANCE = new DocumentPermissions();

    private DocumentPermissions() {
    }

    public final boolean canView(@NotNull DocumentPermissionChecker checker) {
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        return checker.hasPermission((Right)ViewDocuments.INSTANCE);
    }

    public final boolean canEdit(@NotNull DocumentPermissionChecker checker) {
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        return checker.hasPermission((Right)EditDocuments.INSTANCE);
    }

    public final boolean canArchive(@NotNull DocumentPermissionChecker checker) {
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        return checker.hasPermission((Right)ArchiveDocuments.INSTANCE);
    }

    public final boolean canDeleteForever(@NotNull DocumentPermissionChecker checker) {
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        return checker.hasPermission((Right)DeleteDocumentsForever.INSTANCE);
    }

    public final boolean canRestore(@NotNull DocumentPermissionChecker checker) {
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        return checker.canRestore();
    }

    public final boolean canAdministrate(@NotNull DocumentPermissionChecker checker) {
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        return checker.hasPermission((Right)ManageDocuments2.INSTANCE) || checker.hasPermission((Right)ManageDocuments.INSTANCE);
    }

    public final boolean canBeMoved(@NotNull DocumentPermissionChecker checker) {
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        return checker.hasPermission((Right)ManageDocuments2.INSTANCE) || checker.hasPermission((Right)ManageDocuments.INSTANCE);
    }
}

