/*
 * Decompiled with CFR 0.152.
 */
package circlet.m2.contacts2;

import circlet.client.api.chat.ChatContactRecord;
import circlet.client.api.chat.M2UnreadStatus;
import circlet.m2.contacts2.ContactFilter;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c2\u0003J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c2\u0003J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c2\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c2\u0003JI\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0004H\u00d6\u0001R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcirclet/m2/contacts2/ContactHomeFilter;", "Lcirclet/m2/contacts2/ContactFilter;", "types", "", "", "showUnreadTypes", "showMentionsTypes", "hiddenResolvedChannelTypes", "(Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "filter", "contact", "Lcirclet/client/api/chat/ChatContactRecord;", "opened", "hashCode", "", "toString", "app-state"})
public final class ContactHomeFilter
implements ContactFilter {
    @NotNull
    private final Set<String> types;
    @NotNull
    private final Set<String> showUnreadTypes;
    @NotNull
    private final Set<String> showMentionsTypes;
    @NotNull
    private final Set<String> hiddenResolvedChannelTypes;

    public ContactHomeFilter(@NotNull Set<String> types, @NotNull Set<String> showUnreadTypes, @NotNull Set<String> showMentionsTypes, @NotNull Set<String> hiddenResolvedChannelTypes) {
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Intrinsics.checkNotNullParameter(showUnreadTypes, (String)"showUnreadTypes");
        Intrinsics.checkNotNullParameter(showMentionsTypes, (String)"showMentionsTypes");
        Intrinsics.checkNotNullParameter(hiddenResolvedChannelTypes, (String)"hiddenResolvedChannelTypes");
        this.types = types;
        this.showUnreadTypes = showUnreadTypes;
        this.showMentionsTypes = showMentionsTypes;
        this.hiddenResolvedChannelTypes = hiddenResolvedChannelTypes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean filter(@NotNull ChatContactRecord contact2, boolean opened) {
        Intrinsics.checkNotNullParameter((Object)contact2, (String)"contact");
        String type2 = contact2.getChannelType();
        if (this.types.contains(type2)) {
            boolean bl;
            if (!this.hiddenResolvedChannelTypes.contains(type2)) return true;
            if (!contact2.getDetails().resolved()) return true;
            M2UnreadStatus m2UnreadStatus = contact2.getUnreadStatus();
            if (m2UnreadStatus != null) {
                if (m2UnreadStatus.getUnread()) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            if (opened) return true;
        }
        if (contact2.getPinned()) return true;
        CharSequence charSequence = contact2.getDraft();
        if (charSequence != null) {
            if (!StringsKt.isBlank((CharSequence)charSequence)) return true;
        }
        boolean bl = true;
        if (!bl) return true;
        if (this.showUnreadTypes.contains(type2)) {
            boolean bl2;
            M2UnreadStatus m2UnreadStatus = contact2.getUnreadStatus();
            if (m2UnreadStatus != null) {
                if (m2UnreadStatus.getUnread()) {
                    return true;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) return true;
            if (opened) return true;
        }
        if (!this.showMentionsTypes.contains(type2)) return false;
        M2UnreadStatus m2UnreadStatus = contact2.getUnreadStatus();
        if ((m2UnreadStatus != null ? m2UnreadStatus.getCounter() : 0) > 0) return true;
        if (!opened) return false;
        return true;
    }

    private final Set<String> component1() {
        return this.types;
    }

    private final Set<String> component2() {
        return this.showUnreadTypes;
    }

    private final Set<String> component3() {
        return this.showMentionsTypes;
    }

    private final Set<String> component4() {
        return this.hiddenResolvedChannelTypes;
    }

    @NotNull
    public final ContactHomeFilter copy(@NotNull Set<String> types, @NotNull Set<String> showUnreadTypes, @NotNull Set<String> showMentionsTypes, @NotNull Set<String> hiddenResolvedChannelTypes) {
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Intrinsics.checkNotNullParameter(showUnreadTypes, (String)"showUnreadTypes");
        Intrinsics.checkNotNullParameter(showMentionsTypes, (String)"showMentionsTypes");
        Intrinsics.checkNotNullParameter(hiddenResolvedChannelTypes, (String)"hiddenResolvedChannelTypes");
        return new ContactHomeFilter(types, showUnreadTypes, showMentionsTypes, hiddenResolvedChannelTypes);
    }

    public static /* synthetic */ ContactHomeFilter copy$default(ContactHomeFilter contactHomeFilter, Set set, Set set2, Set set3, Set set4, int n, Object object) {
        if ((n & 1) != 0) {
            set = contactHomeFilter.types;
        }
        if ((n & 2) != 0) {
            set2 = contactHomeFilter.showUnreadTypes;
        }
        if ((n & 4) != 0) {
            set3 = contactHomeFilter.showMentionsTypes;
        }
        if ((n & 8) != 0) {
            set4 = contactHomeFilter.hiddenResolvedChannelTypes;
        }
        return contactHomeFilter.copy(set, set2, set3, set4);
    }

    @NotNull
    public String toString() {
        return "ContactHomeFilter(types=" + this.types + ", showUnreadTypes=" + this.showUnreadTypes + ", showMentionsTypes=" + this.showMentionsTypes + ", hiddenResolvedChannelTypes=" + this.hiddenResolvedChannelTypes + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.types).hashCode();
        result2 = result2 * 31 + ((Object)this.showUnreadTypes).hashCode();
        result2 = result2 * 31 + ((Object)this.showMentionsTypes).hashCode();
        result2 = result2 * 31 + ((Object)this.hiddenResolvedChannelTypes).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ContactHomeFilter)) {
            return false;
        }
        ContactHomeFilter contactHomeFilter = (ContactHomeFilter)other;
        if (!Intrinsics.areEqual(this.types, contactHomeFilter.types)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.showUnreadTypes, contactHomeFilter.showUnreadTypes)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.showMentionsTypes, contactHomeFilter.showMentionsTypes)) {
            return false;
        }
        return Intrinsics.areEqual(this.hiddenResolvedChannelTypes, contactHomeFilter.hiddenResolvedChannelTypes);
    }
}

