/*
 * Decompiled with CFR 0.152.
 */
package circlet.pipelines.api;

import circlet.client.api.automation.JobExecutionDisplayStatus;
import circlet.pipelines.api.ExitCode;
import circlet.pipelines.api.FailureConditionDTO;
import circlet.pipelines.api.JobExecutionStatusFilterOption;
import circlet.pipelines.api.JobExecutionWithProblems;
import circlet.pipelines.api.ResourcesStatus;
import circlet.pipelines.common.api.ActionExecutionStatus;
import circlet.pipelines.common.api.ActionExecutionStatusKt;
import circlet.pipelines.common.api.ExecutionStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a$\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00022\b\b\u0002\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u001a\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0007\u001a\u001a\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u001a,\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00022\u0010\b\u0002\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00192\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u001a\"\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u001a\u0014\u0010\u001c\u001a\u00020\u0007*\u00020\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u001a\u001a\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0001*\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u0001\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001f"}, d2={"AwaitingExecutionStatuses", "", "Lcirclet/pipelines/common/api/ExecutionStatus;", "getAwaitingExecutionStatuses", "()Ljava/util/List;", "ResourceRelatedDisplayStatuses", "", "Lcirclet/client/api/automation/JobExecutionDisplayStatus;", "getResourceRelatedDisplayStatuses", "()Ljava/util/Set;", "getActionStatusPresentationEnum", "status", "Lcirclet/pipelines/common/api/ActionExecutionStatus;", "exitCode", "Lcirclet/pipelines/api/ExitCode;", "getExecutionDisplayStatus", "failedBySomeReason", "", "resourcesStatus", "Lcirclet/pipelines/api/ResourcesStatus;", "getExecutionStatusFromDisplayStatus", "getJobStatusPresentationEnum", "execution", "Lcirclet/pipelines/api/JobExecutionWithProblems;", "failureConditions", "", "Lcirclet/pipelines/api/FailureConditionDTO;", "getStepStatusPresentationEnum", "displayStatus", "displayStatuses", "Lcirclet/pipelines/api/JobExecutionStatusFilterOption;", "pipelines-api"})
@SourceDebugExtension(value={"SMAP\nExecutionStatusPresentation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecutionStatusPresentation.kt\ncirclet/pipelines/api/ExecutionStatusPresentationKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n1#2:117\n1360#3:118\n1446#3,5:119\n*S KotlinDebug\n*F\n+ 1 ExecutionStatusPresentation.kt\ncirclet/pipelines/api/ExecutionStatusPresentationKt\n*L\n63#1:118\n63#1:119,5\n*E\n"})
public final class ExecutionStatusPresentationKt {
    @NotNull
    private static final List<ExecutionStatus> AwaitingExecutionStatuses;
    @NotNull
    private static final Set<JobExecutionDisplayStatus> ResourceRelatedDisplayStatuses;

    @NotNull
    public static final List<ExecutionStatus> getAwaitingExecutionStatuses() {
        return AwaitingExecutionStatuses;
    }

    @NotNull
    public static final Set<JobExecutionDisplayStatus> getResourceRelatedDisplayStatuses() {
        return ResourceRelatedDisplayStatuses;
    }

    @NotNull
    public static final JobExecutionDisplayStatus getExecutionDisplayStatus(@NotNull ExecutionStatus status2, boolean failedBySomeReason, @Nullable ResourcesStatus resourcesStatus) {
        JobExecutionDisplayStatus jobExecutionDisplayStatus;
        Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
        if (failedBySomeReason) {
            return JobExecutionDisplayStatus.Failed;
        }
        ResourcesStatus resourcesStatus2 = resourcesStatus;
        switch (resourcesStatus2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[resourcesStatus2.ordinal()]) {
            case 1: {
                return JobExecutionDisplayStatus.NoSuitableWorkers;
            }
            case 2: {
                return JobExecutionDisplayStatus.WaitingForWorkers;
            }
            case 3: {
                return JobExecutionDisplayStatus.WaitingForWorkers;
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$1[status2.ordinal()]) {
            case 1: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Awaiting;
                break;
            }
            case 2: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Awaiting;
                break;
            }
            case 3: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Awaiting;
                break;
            }
            case 4: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Running;
                break;
            }
            case 5: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Restarting;
                break;
            }
            case 6: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Finishing;
                break;
            }
            case 7: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Succeeded;
                break;
            }
            case 8: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Failed;
                break;
            }
            case 9: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Stopped;
                break;
            }
            case 10: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Stopped;
                break;
            }
            case 11: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Finishing;
                break;
            }
            case 12: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Succeeded;
                break;
            }
            case 13: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Skipped;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return jobExecutionDisplayStatus;
    }

    public static /* synthetic */ JobExecutionDisplayStatus getExecutionDisplayStatus$default(ExecutionStatus executionStatus, boolean bl, ResourcesStatus resourcesStatus, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            resourcesStatus = null;
        }
        return ExecutionStatusPresentationKt.getExecutionDisplayStatus(executionStatus, bl, resourcesStatus);
    }

    @NotNull
    public static final List<ExecutionStatus> getExecutionStatusFromDisplayStatus(@NotNull JobExecutionDisplayStatus status2) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)((Object)status2), (String)"status");
        switch (WhenMappings.$EnumSwitchMapping$2[status2.ordinal()]) {
            case 1: {
                list2 = AwaitingExecutionStatuses;
                break;
            }
            case 2: {
                list2 = CollectionsKt.listOf((Object)ExecutionStatus.RUNNING);
                break;
            }
            case 3: {
                list2 = CollectionsKt.listOf((Object)ExecutionStatus.RESTARTING);
                break;
            }
            case 4: {
                list2 = CollectionsKt.listOf((Object)ExecutionStatus.FINISHING);
                break;
            }
            case 5: {
                list2 = CollectionsKt.listOf((Object)ExecutionStatus.TERMINATED);
                break;
            }
            case 6: {
                list2 = CollectionsKt.listOf((Object)ExecutionStatus.FINISHED);
                break;
            }
            case 7: {
                list2 = CollectionsKt.listOf((Object)ExecutionStatus.FAILED);
                break;
            }
            case 8: {
                list2 = CollectionsKt.listOf((Object)ExecutionStatus.SKIPPED);
                break;
            }
            default: {
                list2 = CollectionsKt.emptyList();
            }
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<JobExecutionDisplayStatus> displayStatuses(@Nullable List<? extends JobExecutionStatusFilterOption> $this$displayStatuses) {
        List list2;
        List<? extends JobExecutionStatusFilterOption> list3 = $this$displayStatuses;
        if (list3 != null) {
            void $this$flatMapTo$iv$iv;
            List<? extends JobExecutionStatusFilterOption> it = list3;
            boolean bl = false;
            Iterable $this$flatMap$iv = it;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                JobExecutionStatusFilterOption it2 = (JobExecutionStatusFilterOption)((Object)element$iv$iv);
                boolean bl2 = false;
                Iterable list$iv$iv = ArraysKt.toList((Object[])it2.getDisplayStatus());
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        return list2;
    }

    @NotNull
    public static final JobExecutionDisplayStatus getJobStatusPresentationEnum(@NotNull ExecutionStatus status2, @Nullable Collection<? extends FailureConditionDTO> failureConditions, @Nullable ResourcesStatus resourcesStatus) {
        Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
        Collection<? extends FailureConditionDTO> collection = failureConditions;
        return ExecutionStatusPresentationKt.getExecutionDisplayStatus(status2, collection != null ? !collection.isEmpty() : false, resourcesStatus);
    }

    public static /* synthetic */ JobExecutionDisplayStatus getJobStatusPresentationEnum$default(ExecutionStatus executionStatus, Collection collection, ResourcesStatus resourcesStatus, int n, Object object) {
        if ((n & 2) != 0) {
            collection = null;
        }
        if ((n & 4) != 0) {
            resourcesStatus = null;
        }
        return ExecutionStatusPresentationKt.getJobStatusPresentationEnum(executionStatus, collection, resourcesStatus);
    }

    @NotNull
    public static final JobExecutionDisplayStatus getJobStatusPresentationEnum(@NotNull JobExecutionWithProblems execution, @Nullable ResourcesStatus resourcesStatus) {
        Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
        return ExecutionStatusPresentationKt.getJobStatusPresentationEnum(execution.getStatus(), execution.getFailureConditions(), resourcesStatus);
    }

    public static /* synthetic */ JobExecutionDisplayStatus getJobStatusPresentationEnum$default(JobExecutionWithProblems jobExecutionWithProblems, ResourcesStatus resourcesStatus, int n, Object object) {
        if ((n & 2) != 0) {
            resourcesStatus = null;
        }
        return ExecutionStatusPresentationKt.getJobStatusPresentationEnum(jobExecutionWithProblems, resourcesStatus);
    }

    @NotNull
    public static final JobExecutionDisplayStatus displayStatus(@NotNull JobExecutionWithProblems $this$displayStatus, @Nullable ResourcesStatus resourcesStatus) {
        Intrinsics.checkNotNullParameter((Object)$this$displayStatus, (String)"<this>");
        return ExecutionStatusPresentationKt.getJobStatusPresentationEnum($this$displayStatus, resourcesStatus);
    }

    @NotNull
    public static final JobExecutionDisplayStatus getStepStatusPresentationEnum(@NotNull ExecutionStatus status2, @NotNull ExitCode exitCode, @Nullable ResourcesStatus resourcesStatus) {
        Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
        Intrinsics.checkNotNullParameter((Object)exitCode, (String)"exitCode");
        ExitCode.Available available = exitCode instanceof ExitCode.Available ? (ExitCode.Available)exitCode : null;
        Integer exitCodeValue = available != null ? Integer.valueOf(available.getExitCode()) : null;
        return ExecutionStatusPresentationKt.getExecutionDisplayStatus(status2, exitCodeValue != null && exitCodeValue != 0, resourcesStatus);
    }

    public static /* synthetic */ JobExecutionDisplayStatus getStepStatusPresentationEnum$default(ExecutionStatus executionStatus, ExitCode exitCode, ResourcesStatus resourcesStatus, int n, Object object) {
        if ((n & 4) != 0) {
            resourcesStatus = null;
        }
        return ExecutionStatusPresentationKt.getStepStatusPresentationEnum(executionStatus, exitCode, resourcesStatus);
    }

    @NotNull
    public static final JobExecutionDisplayStatus getActionStatusPresentationEnum(@NotNull ActionExecutionStatus status2, @NotNull ExitCode exitCode) {
        JobExecutionDisplayStatus jobExecutionDisplayStatus;
        Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
        Intrinsics.checkNotNullParameter((Object)exitCode, (String)"exitCode");
        if (ActionExecutionStatusKt.isFinished(status2) && (!(exitCode instanceof ExitCode.Available) || ((ExitCode.Available)exitCode).getExitCode() != 0)) {
            return JobExecutionDisplayStatus.Failed;
        }
        switch (WhenMappings.$EnumSwitchMapping$3[status2.ordinal()]) {
            case 1: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Awaiting;
                break;
            }
            case 2: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Running;
                break;
            }
            case 3: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Succeeded;
                break;
            }
            case 4: {
                jobExecutionDisplayStatus = JobExecutionDisplayStatus.Stopped;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return jobExecutionDisplayStatus;
    }

    static {
        Object[] objectArray = new ExecutionStatus[]{ExecutionStatus.SCHEDULED, ExecutionStatus.READY_TO_START, ExecutionStatus.PENDING};
        AwaitingExecutionStatuses = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new JobExecutionDisplayStatus[]{JobExecutionDisplayStatus.WaitingForWorkers, JobExecutionDisplayStatus.NoSuitableWorkers};
        ResourceRelatedDisplayStatuses = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[ResourcesStatus.values().length];
            try {
                nArray[ResourcesStatus.NO_SUITABLE_WORKERS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourcesStatus.SUITABLE_WORKERS_BUSY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourcesStatus.LIMITS_REACHED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ExecutionStatus.values().length];
            try {
                nArray[ExecutionStatus.SCHEDULED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionStatus.READY_TO_START.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionStatus.PENDING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionStatus.RUNNING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionStatus.RESTARTING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionStatus.FINISHING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionStatus.FINISHED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionStatus.FAILED.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionStatus.TERMINATING.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionStatus.TERMINATED.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionStatus.HIBERNATING.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionStatus.HIBERNATED.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionStatus.SKIPPED.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[JobExecutionDisplayStatus.values().length];
            try {
                nArray[JobExecutionDisplayStatus.Awaiting.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JobExecutionDisplayStatus.Running.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JobExecutionDisplayStatus.Restarting.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JobExecutionDisplayStatus.Finishing.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JobExecutionDisplayStatus.Stopped.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JobExecutionDisplayStatus.Succeeded.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JobExecutionDisplayStatus.Failed.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JobExecutionDisplayStatus.Skipped.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[ActionExecutionStatus.values().length];
            try {
                nArray[ActionExecutionStatus.PENDING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionExecutionStatus.RUNNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionExecutionStatus.FINISHED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionExecutionStatus.TERMINATED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

